/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.navigation.DriftCandidate;
import au.gov.amsa.risky.format.Fix;
import au.gov.amsa.risky.format.HasFix;
import au.gov.amsa.risky.format.NavigationalStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class DriftDetectorOperator
implements Observable.Operator<DriftCandidate, HasFix> {
    private final Func1<Fix, Boolean> isCandidate;
    private final Options options;
    private static final long NOT_DRIFTING = Long.MAX_VALUE;
    private static final long MMSI_NOT_SET = 0L;

    public DriftDetectorOperator(Options options) {
        this.isCandidate = DriftDetectorOperator.isCandidate(options);
        this.options = options;
    }

    public Subscriber<? super HasFix> call(final Subscriber<? super DriftCandidate> child) {
        return new Subscriber<HasFix>(child){
            private Item a;
            private Item b;
            private long driftingSince;
            private long mmsi;
            {
                super(x0);
                this.driftingSince = Long.MAX_VALUE;
                this.mmsi = 0L;
            }

            public void onCompleted() {
                child.onCompleted();
            }

            public void onError(Throwable e) {
                child.onError(e);
            }

            public void onNext(HasFix f) {
                try {
                    Fix fix = f.fix();
                    if (this.mmsi != 0L && (long)fix.mmsi() != this.mmsi) {
                        this.a = null;
                        this.b = null;
                        this.driftingSince = Long.MAX_VALUE;
                    }
                    this.mmsi = fix.mmsi();
                    if (this.outOfTimeOrder(fix)) {
                        this.request(1L);
                        return;
                    }
                    Item item = (Boolean)DriftDetectorOperator.this.isCandidate.call((Object)fix) != false ? new Drifter(f, false) : new NonDrifter(fix.time());
                    if (this.a == null) {
                        this.a = item;
                        this.processAB();
                    } else if (this.b == null) {
                        this.b = item;
                        this.processAB();
                    } else {
                        this.processABC(item);
                    }
                }
                catch (RuntimeException e) {
                    this.onError(e);
                }
            }

            private boolean outOfTimeOrder(Fix fix) {
                if (this.b != null && fix.time() < this.b.time()) {
                    return true;
                }
                return this.a != null && fix.time() < this.a.time();
            }

            private void processABC(Item c) {
                if (!DriftDetectorOperator.isDrifter(this.a) || DriftDetectorOperator.isDrifter(this.b) || DriftDetectorOperator.isDrifter(c)) {
                    if (DriftDetectorOperator.isDrifter(this.a) && !DriftDetectorOperator.isDrifter(this.b) && DriftDetectorOperator.isDrifter(c)) {
                        if (DriftDetectorOperator.this.withinNonDriftingThreshold(this.b, c)) {
                            this.b = c;
                            this.processAB();
                        } else {
                            this.a = c;
                            this.b = null;
                            this.request(1L);
                        }
                    } else {
                        System.out.println(this.a + "," + this.b + "," + c);
                        this.unexpected();
                    }
                }
            }

            private void unexpected() {
                throw new RuntimeException("unexpected");
            }

            private void processAB() {
                if (!DriftDetectorOperator.isDrifter(this.a)) {
                    this.a = null;
                    if (this.b != null) {
                        this.unexpected();
                    }
                    this.request(1L);
                } else if (this.b == null) {
                    this.request(1L);
                } else if (!this.a.emitted()) {
                    if (DriftDetectorOperator.isDrifter(this.b)) {
                        if (!DriftDetectorOperator.this.expired(this.a, this.b)) {
                            this.driftingSince = this.a.time();
                            child.onNext((Object)new DriftCandidate(this.a.fix(), this.a.time()));
                            child.onNext((Object)new DriftCandidate(this.b.fix(), this.a.time()));
                            this.a = new Drifter(this.a.fix(), true);
                            this.b = null;
                        } else {
                            this.a = this.b;
                            this.b = null;
                            this.request(1L);
                        }
                    }
                } else if (DriftDetectorOperator.isDrifter(this.b)) {
                    if (!DriftDetectorOperator.this.expired(this.a, this.b)) {
                        child.onNext((Object)new DriftCandidate(this.b.fix(), this.driftingSince));
                        this.a = new Drifter(this.b.fix(), true);
                        this.b = null;
                        this.request(1L);
                    } else {
                        this.a = this.b;
                        this.b = null;
                        this.request(1L);
                    }
                }
            }
        };
    }

    private boolean expired(Item a, Item b) {
        return b.time() - a.time() >= this.options.expiryAgeMs();
    }

    private boolean withinNonDriftingThreshold(Item a, Item b) {
        return b.time() - a.time() < this.options.nonDriftingThresholdMs();
    }

    private static boolean isDrifter(Item item) {
        return item instanceof Drifter;
    }

    @VisibleForTesting
    static Func1<Fix, Boolean> isCandidate(Options options) {
        return f -> {
            if (f.courseOverGroundDegrees().isPresent() && f.headingDegrees().isPresent() && f.speedOverGroundKnots().isPresent() && (!f.navigationalStatus().isPresent() || f.navigationalStatus().get() != NavigationalStatus.AT_ANCHOR && f.navigationalStatus().get() != NavigationalStatus.MOORED)) {
                double diff = DriftDetectorOperator.diff(((Float)f.courseOverGroundDegrees().get()).floatValue(), ((Float)f.headingDegrees().get()).floatValue());
                return diff >= (double)options.minHeadingCogDifference() && diff <= (double)options.maxHeadingCogDifference() && ((Float)f.speedOverGroundKnots().get()).floatValue() <= options.maxDriftingSpeedKnots() && ((Float)f.speedOverGroundKnots().get()).floatValue() > options.minDriftingSpeedKnots();
            }
            return false;
        };
    }

    static double diff(double a, double b) {
        Preconditions.checkArgument((a >= 0.0 && a < 360.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((b >= 0.0 && b < 360.0 ? 1 : 0) != 0);
        double value = a < b ? a + 360.0 - b : a - b;
        if (value > 180.0) {
            return 360.0 - value;
        }
        return value;
    }

    public static final class Options {
        @VisibleForTesting
        static final int DEFAULT_HEADING_COG_DIFFERENCE_MIN = 45;
        @VisibleForTesting
        static final int DEFAULT_HEADING_COG_DIFFERENCE_MAX = 135;
        @VisibleForTesting
        static final float DEFAULT_MIN_DRIFTING_SPEED_KNOTS = 0.25f;
        @VisibleForTesting
        static final float DEFAULT_MAX_DRIFTING_SPEED_KNOTS = 20.0f;
        private static final long DEFAULT_EXPIRY_AGE_MS = TimeUnit.HOURS.toMillis(6L);
        private static final long DEFAULT_NON_DRIFTING_THRESHOLD_MS = TimeUnit.MINUTES.toMillis(5L);
        private final int minHeadingCogDifference;
        private final int maxHeadingCogDifference;
        private final float minDriftingSpeedKnots;
        private final float maxDriftingSpeedKnots;
        private final long expiryAgeMs;
        private final long nonDriftingThresholdMs;

        public static Options instance() {
            return Holder.INSTANCE;
        }

        public Options(int minHeadingCogDifference, int maxHeadingCogDifference, float minDriftingSpeedKnots, float maxDriftingSpeedKnots, long expiryAgeMs, long nonDriftingThresholdMs) {
            Preconditions.checkArgument((minHeadingCogDifference >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((minDriftingSpeedKnots >= 0.0f ? 1 : 0) != 0);
            Preconditions.checkArgument((minHeadingCogDifference <= maxHeadingCogDifference ? 1 : 0) != 0);
            Preconditions.checkArgument((minDriftingSpeedKnots <= maxDriftingSpeedKnots ? 1 : 0) != 0);
            Preconditions.checkArgument((expiryAgeMs > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((nonDriftingThresholdMs >= 0L ? 1 : 0) != 0);
            this.minHeadingCogDifference = minHeadingCogDifference;
            this.maxHeadingCogDifference = maxHeadingCogDifference;
            this.minDriftingSpeedKnots = minDriftingSpeedKnots;
            this.maxDriftingSpeedKnots = maxDriftingSpeedKnots;
            this.expiryAgeMs = expiryAgeMs;
            this.nonDriftingThresholdMs = nonDriftingThresholdMs;
        }

        public int maxHeadingCogDifference() {
            return this.maxHeadingCogDifference;
        }

        public int minHeadingCogDifference() {
            return this.minHeadingCogDifference;
        }

        public float maxDriftingSpeedKnots() {
            return this.maxDriftingSpeedKnots;
        }

        public float minDriftingSpeedKnots() {
            return this.minDriftingSpeedKnots;
        }

        public long expiryAgeMs() {
            return this.expiryAgeMs;
        }

        public long nonDriftingThresholdMs() {
            return this.nonDriftingThresholdMs;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("Options [minHeadingCogDifference=");
            b.append(this.minHeadingCogDifference);
            b.append(", maxHeadingCogDifference=");
            b.append(this.maxHeadingCogDifference);
            b.append(", minDriftingSpeedKnots=");
            b.append(this.minDriftingSpeedKnots);
            b.append(", maxDriftingSpeedKnots=");
            b.append(this.maxDriftingSpeedKnots);
            b.append(", expiryAgeMs=");
            b.append(this.expiryAgeMs);
            b.append(", nonDriftingThresholdMs=");
            b.append(this.nonDriftingThresholdMs);
            b.append("]");
            return b.toString();
        }

        static /* synthetic */ long access$400() {
            return DEFAULT_EXPIRY_AGE_MS;
        }

        static /* synthetic */ long access$500() {
            return DEFAULT_NON_DRIFTING_THRESHOLD_MS;
        }

        private static class Holder {
            static Options INSTANCE = new Options(45, 135, 0.25f, 20.0f, Options.access$400(), Options.access$500());

            private Holder() {
            }
        }
    }

    private static class NonDrifter
    implements Item {
        private final long time;

        NonDrifter(long time) {
            this.time = time;
        }

        @Override
        public long time() {
            return this.time;
        }

        public Fix fix() {
            throw new RuntimeException("unexpected");
        }

        @Override
        public boolean emitted() {
            return false;
        }
    }

    private static class Drifter
    implements Item {
        private final HasFix fix;
        private final boolean emitted;

        Drifter(HasFix fix, boolean emitted) {
            this.fix = fix;
            this.emitted = emitted;
        }

        @Override
        public long time() {
            return this.fix.fix().time();
        }

        @Override
        public HasFix fix() {
            return this.fix;
        }

        @Override
        public boolean emitted() {
            return this.emitted;
        }
    }

    private static interface Item {
        public long time();

        public HasFix fix();

        public boolean emitted();
    }
}

