/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.navigation.DriftCandidate;
import au.gov.amsa.navigation.DriftDetectorOperator;
import au.gov.amsa.risky.format.HasFix;
import rx.Observable;

public class DriftDetector {
    public Observable<DriftCandidate> getCandidates(Observable<HasFix> o, DriftDetectorOperator.Options options) {
        return o.lift(DriftDetector.detectDriftCandidates(options));
    }

    public static DriftDetectorTransformer detectDrift() {
        return new DriftDetectorTransformer(DriftDetectorOperator.Options.instance());
    }

    private static Observable.Operator<DriftCandidate, HasFix> detectDriftCandidates(DriftDetectorOperator.Options options) {
        return new DriftDetectorOperator(options);
    }

    public static DriftDetectorTransformer detectDrift(DriftDetectorOperator.Options options) {
        return new DriftDetectorTransformer(options);
    }

    public static class DriftDetectorTransformer
    implements Observable.Transformer<HasFix, DriftCandidate> {
        private final DriftDetector d = new DriftDetector();
        private final DriftDetectorOperator.Options options;

        public DriftDetectorTransformer(DriftDetectorOperator.Options options) {
            this.options = options;
        }

        public Observable<DriftCandidate> call(Observable<HasFix> o) {
            return this.d.getCandidates(o, this.options).onBackpressureBuffer();
        }
    }
}

