/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.navigation.DriftCandidate;
import au.gov.amsa.risky.format.AisClass;
import au.gov.amsa.risky.format.FixImpl;
import au.gov.amsa.risky.format.HasFix;
import au.gov.amsa.risky.format.NavigationalStatus;
import au.gov.amsa.streams.Strings;
import com.github.davidmoten.rx.Checked;
import com.google.common.base.Optional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public final class DriftCandidates {
    public static Observable<DriftCandidate> fromCsv(Reader reader) {
        return Strings.lines((Reader)reader).filter(DriftCandidates.nonBlankLinesOnly()).map(line -> DriftCandidates.toDriftCandidate(line));
    }

    private static DriftCandidate toDriftCandidate(String line) {
        String[] items = line.split(",");
        int i = 0;
        int mmsi = Integer.parseInt(items[i++]);
        float lat = Float.parseFloat(items[i++]);
        float lon = Float.parseFloat(items[i++]);
        long time = Long.parseLong(items[i++]);
        String cls = items[i++];
        float course = Float.parseFloat(items[i++]);
        float heading = Float.parseFloat(items[i++]);
        float speedKnots = Float.parseFloat(items[i++]);
        String status = items[i++];
        long driftingSince = Long.parseLong(items[i++]);
        Optional navigationalStatus = status.trim().length() == 0 ? Optional.absent() : Optional.of((Object)NavigationalStatus.valueOf((String)status));
        if (cls.trim().length() == 0) {
            throw new RuntimeException("cls should not be empty");
        }
        AisClass aisClass = AisClass.A.name().equals(cls) ? AisClass.A : AisClass.B;
        FixImpl fix = new FixImpl(mmsi, lat, lon, time, Optional.absent(), Optional.absent(), navigationalStatus, Optional.of((Object)Float.valueOf(speedKnots)), Optional.of((Object)Float.valueOf(course)), Optional.of((Object)Float.valueOf(heading)), aisClass);
        return new DriftCandidate((HasFix)fix, driftingSince);
    }

    public static Observable<DriftCandidate> fromCsv(File file, boolean zipped) {
        Action1 disposeAction = reader -> {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        Func0 resourceFactory = Checked.f0(() -> {
            InputStream is = zipped ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            return new InputStreamReader(is);
        });
        Func1 obFactory = reader -> DriftCandidates.fromCsv(reader);
        return Observable.using((Func0)resourceFactory, (Func1)obFactory, (Action1)disposeAction, (boolean)true);
    }

    private static Func1<String, Boolean> nonBlankLinesOnly() {
        return line -> line.trim().length() > 0;
    }
}

