/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.navigation.CollisionCandidate;
import au.gov.amsa.navigation.Comparators;
import au.gov.amsa.navigation.Identifier;
import au.gov.amsa.navigation.IdentifierPair;
import au.gov.amsa.navigation.Region;
import au.gov.amsa.navigation.State;
import au.gov.amsa.navigation.Times;
import au.gov.amsa.navigation.VesselPosition;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rx.slf4j.Logging;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.observables.GroupedObservable;

public class CollisionDetector {
    private static final long MAX_TIME_INTERVAL_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final double MAX_VESSEL_SPEED_METRES_PER_SECOND = 24.0;
    private static final double LATITUDE_DELTA = (double)(2L * MAX_TIME_INTERVAL_MS / 1000L) * 24.0 / 111120.0;
    private static Func1<Entry<VesselPosition, Point>, VesselPosition> toVesselPosition = entry -> (VesselPosition)entry.value();

    public Observable<CollisionCandidate> getCandidates(Observable<VesselPosition> o) {
        return CollisionDetector.getCandidatesForAStream(o);
    }

    public static Observable.Transformer<VesselPosition, CollisionCandidate> detectCollisionCandidates() {
        return o -> new CollisionDetector().getCandidates((Observable<VesselPosition>)o);
    }

    private static Func1<VesselPosition, Region> toRegion() {
        return new Func1<VesselPosition, Region>(){

            public Region call(VesselPosition p) {
                double maxLat = 15.0;
                double minLat = -50.0;
                double minLon = -70.0;
                double maxLon = 179.0;
                int numRegions = Runtime.getRuntime().availableProcessors();
                int x = (int)Math.floor((p.lon() - minLon) / (maxLon - minLon) * (double)numRegions);
                double lonCellSize = (maxLon - minLon) / (double)numRegions;
                double longitudeDelta = Math.abs(minLat) > Math.abs(maxLat) ? CollisionDetector.longitudeDelta(minLat) : CollisionDetector.longitudeDelta(maxLat);
                return new Region(maxLat, minLon + (double)x * lonCellSize - longitudeDelta, minLat, minLon + (double)(x + 1) * lonCellSize + longitudeDelta);
            }
        };
    }

    public static Observable<CollisionCandidate> getCandidatesForAStream(Observable<VesselPosition> o) {
        return o.scan((Object)new State(), CollisionDetector.nextState()).lift((Observable.Operator)Logging.logger().showCount("positions").showRateSince("rate (pos/s)", TimeUnit.SECONDS.toMillis(10L)).showRateSinceStart("overall rate").every(10000).showValue().value(state -> "state.map.size=" + state.mapSize() + ", state.rtree.size=" + state.tree().size()).log()).flatMap(CollisionDetector.toCollisionCandidatesForPosition()).groupBy(CollisionDetector.byIdPair()).flatMap(CollisionDetector.onlyRepeating());
    }

    private static Func2<State, VesselPosition, State> nextState() {
        return (state, p) -> state.nextState(MAX_TIME_INTERVAL_MS, (VesselPosition)p);
    }

    private static Func1<State, Observable<CollisionCandidate>> toCollisionCandidatesForPosition() {
        return state -> {
            if (!state.last().isPresent()) {
                return Observable.empty();
            }
            return CollisionDetector.toCollisionCandidatesForPosition(state);
        };
    }

    private static Observable<CollisionCandidate> toCollisionCandidatesForPosition(State state) {
        VesselPosition p = (VesselPosition)state.last().get();
        Optional<VesselPosition> next = state.nextPosition();
        double longitudeDelta = CollisionDetector.longitudeDelta(p.lat());
        Rectangle searchRegion = Geometries.rectangle((double)(p.lon() - longitudeDelta), (double)(p.lat() - LATITUDE_DELTA), (double)(p.lon() + longitudeDelta), (double)(p.lat() + LATITUDE_DELTA));
        Observable near = state.tree().search(searchRegion).map(toVesselPosition).filter(CollisionDetector.aroundInTime(p, MAX_TIME_INTERVAL_MS));
        Observable othersByVessel = near.filter(CollisionDetector.not(CollisionDetector.isVessel(p.id()))).groupBy(CollisionDetector.byId()).flatMap(CollisionDetector.toSortedSet());
        Observable collisionCandidates = othersByVessel.flatMap(CollisionDetector.toCollisionCandidates2(p, next));
        return collisionCandidates;
    }

    private static <T> Func1<T, Boolean> not(Func1<T, Boolean> f) {
        return t -> (Boolean)f.call(t) == false;
    }

    private static double longitudeDelta(double lat) {
        return LATITUDE_DELTA / Math.cos(Math.toRadians(lat));
    }

    private static Func1<GroupedObservable<IdentifierPair, CollisionCandidate>, Observable<? extends CollisionCandidate>> onlyRepeating() {
        return g -> g.buffer(2).flatMap(CollisionDetector.isSmallTimePeriod());
    }

    private static Func1<List<CollisionCandidate>, Observable<CollisionCandidate>> isSmallTimePeriod() {
        return list -> {
            Optional min = Optional.absent();
            Optional max = Optional.absent();
            for (CollisionCandidate c : list) {
                if (!min.isPresent() || c.position1().time() < (Long)min.get()) {
                    min = Optional.of((Object)c.position1().time());
                }
                if (max.isPresent() && c.position1().time() <= (Long)max.get()) continue;
                max = Optional.of((Object)c.position1().time());
            }
            if ((Long)max.get() - (Long)min.get() < TimeUnit.MINUTES.toMillis(5L)) {
                return Observable.from((Iterable)list);
            }
            return Observable.empty();
        };
    }

    private static Func1<? super CollisionCandidate, IdentifierPair> byIdPair() {
        return c -> new IdentifierPair(c.position1().id(), c.position2().id());
    }

    private static Func1<TreeSet<VesselPosition>, Observable<CollisionCandidate>> toCollisionCandidates2(VesselPosition p, Optional<VesselPosition> next) {
        return set -> {
            Optional other = Optional.fromNullable((Object)set.lower(p));
            if (other.isPresent()) {
                Optional<Times> times = p.intersectionTimes((VesselPosition)other.get());
                if (times.isPresent()) {
                    Optional<Long> tCollision = CollisionDetector.plus(((Times)times.get()).leastPositive(), p.time());
                    if (tCollision.isPresent() && (Long)tCollision.get() < p.time() + MAX_TIME_INTERVAL_MS) {
                        Optional otherNext = Optional.fromNullable((Object)set.higher(other.get()));
                        if (otherNext.isPresent() && ((VesselPosition)otherNext.get()).time() < (Long)tCollision.get()) {
                            return Observable.empty();
                        }
                        if (next.isPresent() && ((VesselPosition)next.get()).time() < (Long)tCollision.get()) {
                            return Observable.empty();
                        }
                        return Observable.just((Object)new CollisionCandidate(p, (VesselPosition)other.get(), (Long)tCollision.get()));
                    }
                    return Observable.empty();
                }
                return Observable.empty();
            }
            return Observable.empty();
        };
    }

    private static Optional<Long> plus(Optional<Long> a, long b) {
        if (a.isPresent()) {
            return Optional.of((Object)((Long)a.get() + b));
        }
        return Optional.absent();
    }

    private static Func1<GroupedObservable<Identifier, VesselPosition>, Observable<TreeSet<VesselPosition>>> toSortedSet() {
        return g -> g.toList().map(singleVesselPositions -> {
            TreeSet<VesselPosition> set = new TreeSet<VesselPosition>(Comparators.timeIdMessageIdComparator);
            set.addAll((Collection<VesselPosition>)singleVesselPositions);
            return set;
        });
    }

    private static Func1<VesselPosition, Identifier> byId() {
        return position -> position.id();
    }

    private static Func1<VesselPosition, Boolean> aroundInTime(VesselPosition position, long maxTimeIntervalMs) {
        return p -> Math.abs(p.time() - position.time()) <= maxTimeIntervalMs;
    }

    private static Func1<VesselPosition, Boolean> isVessel(Identifier id) {
        return p -> p.id().equals(id);
    }
}

