/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.navigation.VesselPosition;
import com.github.davidmoten.grumpy.core.Position;
import java.util.Date;

public class CollisionCandidate {
    private final VesselPosition p1;
    private final VesselPosition p2;
    private final long time;

    public CollisionCandidate(VesselPosition p1, VesselPosition p2, long time) {
        this.p1 = p1;
        this.p2 = p2;
        this.time = time;
    }

    public VesselPosition position1() {
        return this.p1;
    }

    public VesselPosition position2() {
        return this.p2;
    }

    public long time() {
        return this.time;
    }

    public String toString() {
        return "CollisionCandidate [\np1=" + this.p1 + ", \np2=" + this.p2 + ", \ncollisionTime=" + new Date(this.time) + "\nseparationKm=" + this.separationKm() + "]";
    }

    public double separationKm() {
        return new Position(this.p1.lat(), this.p1.lon()).getDistanceToKm(new Position(this.p2.lat(), this.p2.lon()));
    }
}

