/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.util.nmea.saver;

import au.gov.amsa.util.nmea.saver.FileFactory;
import java.io.File;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class FileFactoryPerDay
implements FileFactory {
    private static DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC();
    private File directory;

    public FileFactoryPerDay(File directory) {
        this.directory = directory;
        directory.mkdirs();
    }

    @Override
    public File file(String line, long arrivalTime) {
        return new File(this.directory, this.date(arrivalTime) + ".txt");
    }

    @Override
    public String key(String line, long arrivalTime) {
        return this.date(arrivalTime);
    }

    private String date(long arrivalTime) {
        return dtf.print(arrivalTime);
    }
}

