/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessage;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.HasMmsi;
import au.gov.amsa.ais.Util;

public class AisAidToNavigation
implements AisMessage,
HasMmsi {
    private static final Integer LONGITUDE_NOT_AVAILABLE = 108600000;
    private static final Integer LATITUDE_NOT_AVAILABLE = 54600000;
    private final AisExtractor extractor;
    private final String source;
    private final int messageId;
    private final int repeatIndicator;
    private final int mmsi;
    private final String name;
    private final int dimensionA;
    private final int dimensionB;
    private final int dimensionC;
    private final int dimensionD;
    private final int typeOfElectronicPositionFixingDevice;
    private final boolean isHighAccuracyPosition;
    private final boolean isVirtualAtoN;
    private final boolean isAtonOff;
    private final boolean isAtonInAssignedMode;
    private final Double longitude;
    private final Double latitude;
    private final int timeSecondsOnly;
    private final String atonStatus;
    private final int atonType;
    private final boolean isUsingRAIM;

    public AisAidToNavigation(String message, String source, int padBits) {
        this(Util.getAisExtractorFactory(), message, source, padBits);
    }

    private AisAidToNavigation(AisExtractorFactory factory, String message, String source, int padBits) {
        this.source = source;
        this.extractor = factory.create(message, 172, padBits);
        this.messageId = this.extractor.getValue(0, 6);
        Util.checkMessageId(this.getMessageId(), AisMessageType.ATON_REPORT);
        this.repeatIndicator = this.extractor.getValue(6, 8);
        this.mmsi = this.extractor.getValue(8, 38);
        this.atonType = this.extractor.getValue(38, 43);
        this.name = this.extractor.getString(43, 163);
        this.isHighAccuracyPosition = Util.areEqual(this.extractor.getValue(163, 164), 1);
        this.longitude = AisAidToNavigation.extractLongitude(this.extractor);
        this.latitude = AisAidToNavigation.extractLatitude(this.extractor);
        this.dimensionA = this.extractor.getValue(219, 228);
        this.dimensionB = this.extractor.getValue(228, 237);
        this.dimensionC = this.extractor.getValue(237, 243);
        this.dimensionD = this.extractor.getValue(243, 249);
        this.typeOfElectronicPositionFixingDevice = this.extractor.getValue(249, 253);
        this.timeSecondsOnly = this.extractor.getValue(253, 259);
        this.isAtonOff = Util.areEqual(this.extractor.getValue(259, 260), 1);
        this.atonStatus = this.extractor.getString(260, 268);
        this.isUsingRAIM = Util.areEqual(this.extractor.getValue(268, 269), 1);
        this.isVirtualAtoN = Util.areEqual(this.extractor.getValue(269, 270), 1);
        this.isAtonInAssignedMode = Util.areEqual(this.extractor.getValue(270, 271), 1);
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    public int getRepeatIndicator() {
        return this.repeatIndicator;
    }

    @Override
    public int getMmsi() {
        return this.mmsi;
    }

    public boolean isHighAccuracyPosition() {
        return this.isHighAccuracyPosition;
    }

    public boolean isVirtualAtoN() {
        return this.isVirtualAtoN;
    }

    public boolean isAtonOff() {
        return this.isAtonOff;
    }

    public boolean isAtonInAssignedMode() {
        return this.isAtonInAssignedMode;
    }

    public String getAtonStatus() {
        return this.atonStatus;
    }

    public String getName() {
        return this.name;
    }

    public int getAtoNType() {
        return this.atonType;
    }

    public int getDimensionA() {
        return this.dimensionA;
    }

    public int getDimensionB() {
        return this.dimensionB;
    }

    public int getDimensionC() {
        return this.dimensionC;
    }

    public int getDimensionD() {
        return this.dimensionD;
    }

    public int getLengthMetres() {
        return this.getDimensionA() + this.getDimensionB();
    }

    public int getWidthMetres() {
        return this.getDimensionC() + this.getDimensionD();
    }

    public int getTypeOfElectronicPositionFixingDevice() {
        return this.typeOfElectronicPositionFixingDevice;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    static Double extractLongitude(AisExtractor extractor) {
        int val = extractor.getSignedValue(164, 192);
        if (val == LONGITUDE_NOT_AVAILABLE) {
            return null;
        }
        Util.checkLong((double)val / 600000.0);
        return (double)val / 600000.0;
    }

    static Double extractLatitude(AisExtractor extractor) {
        int val = extractor.getSignedValue(192, 219);
        if (val == LATITUDE_NOT_AVAILABLE) {
            return null;
        }
        Util.checkLat((double)val / 600000.0);
        return (double)val / 600000.0;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public int getTimeSecondsOnly() {
        return this.timeSecondsOnly;
    }

    public boolean isUsingRAIM() {
        return this.isUsingRAIM;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AisAidToNavigation [source=");
        builder.append(this.source);
        builder.append(", messageId=");
        builder.append(this.messageId);
        builder.append(", repeatIndicator=");
        builder.append(this.repeatIndicator);
        builder.append(", mmsi=");
        builder.append(this.mmsi);
        builder.append(", atonType=");
        builder.append(this.atonType);
        builder.append(", atonStatus=");
        builder.append(this.atonStatus);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", isHighAccuracyPosition=");
        builder.append(this.isHighAccuracyPosition);
        builder.append(", longitude=");
        builder.append(this.longitude);
        builder.append(", latitude=");
        builder.append(this.latitude);
        builder.append(", dimensionA=");
        builder.append(this.dimensionA);
        builder.append(", dimensionB=");
        builder.append(this.dimensionB);
        builder.append(", dimensionC=");
        builder.append(this.dimensionC);
        builder.append(", dimensionD=");
        builder.append(this.dimensionD);
        builder.append(", typeOfElectronicPositionFixingDevice=");
        builder.append(this.typeOfElectronicPositionFixingDevice);
        builder.append(", timeSecondsOnly=");
        builder.append(this.timeSecondsOnly);
        builder.append(", isAtonOff=");
        builder.append(this.isAtonOff);
        builder.append(", isUsingRAIM=");
        builder.append(this.isUsingRAIM);
        builder.append(", isVirtualAtoN=");
        builder.append(this.isVirtualAtoN);
        builder.append(", isAtonInAssignedMode=");
        builder.append(this.isAtonInAssignedMode);
        builder.append("]");
        return builder.toString();
    }
}

