/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.AisParseException;
import com.google.common.annotations.VisibleForTesting;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.TimeZone;

public final class Util {
    static TimeZone TIME_ZONE_UTC = TimeZone.getTimeZone("UTC");
    private static Charset ASCII_8_BIT_CHARSET = Charset.forName("ISO-8859-1");
    private static AisExtractorFactory extractorFactory = new AisExtractorFactory(){

        @Override
        public AisExtractor create(String message, int minLength, int padBits) {
            return new AisExtractor(message, minLength, padBits);
        }
    };

    private Util() {
    }

    static void forTestCoverageOnly() {
        new Util();
    }

    protected static int getValueByBinStr(String binaryString, boolean signed) {
        Integer value = Integer.parseInt(binaryString, 2);
        if (signed && binaryString.charAt(0) == '1') {
            char[] invert = new char[binaryString.length()];
            Arrays.fill(invert, '1');
            value = value ^ Integer.parseInt(new String(invert), 2);
            value = value + 1;
            value = -value.intValue();
        }
        return value;
    }

    protected static String decodeMessage(String encodedMessage) {
        return Util.getDecodedStr(Util.ascii8To6bitBin(encodedMessage.getBytes(ASCII_8_BIT_CHARSET)));
    }

    @VisibleForTesting
    static byte[] ascii8To6bitBin(byte[] toDecBytes) {
        byte[] convertedBytes = new byte[toDecBytes.length];
        int sum = 0;
        int _6bitBin = 0;
        for (int i = 0; i < toDecBytes.length; ++i) {
            sum = 0;
            _6bitBin = 0;
            if (toDecBytes[i] < 48) {
                throw new AisParseException(AisParseException.INVALID_CHARACTER + " " + (char)toDecBytes[i]);
            }
            if (toDecBytes[i] > 119) {
                throw new AisParseException(AisParseException.INVALID_CHARACTER + " " + (char)toDecBytes[i]);
            }
            if (toDecBytes[i] > 87) {
                if (toDecBytes[i] < 96) {
                    throw new AisParseException(AisParseException.INVALID_CHARACTER + " " + (char)toDecBytes[i]);
                }
                sum = toDecBytes[i] + 40;
            } else {
                sum = toDecBytes[i] + 40;
            }
            if (sum == 0) continue;
            sum = sum > 128 ? (sum += 32) : (sum += 40);
            _6bitBin = sum & 0x3F;
            convertedBytes[i] = (byte)_6bitBin;
        }
        return convertedBytes;
    }

    private static String getDecodedStr(byte[] decBytes) {
        int n = decBytes.length * 6;
        int capacity = Util.leastPowerOf2GreaterThanOrEqualTo(n);
        StringBuilder decStr = new StringBuilder(capacity);
        for (int i = 0; i < decBytes.length; ++i) {
            int j;
            byte decByte = decBytes[i];
            String bitStr = Integer.toBinaryString(decByte);
            int padding = Math.max(0, 6 - bitStr.length());
            for (j = 0; j < padding; ++j) {
                decStr.append('0');
            }
            for (j = 0; j < 6 - padding; ++j) {
                decStr.append(bitStr.charAt(j));
            }
        }
        return decStr.toString();
    }

    static int leastPowerOf2GreaterThanOrEqualTo(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    protected static String getAsciiStringFrom6BitStr(String str) {
        StringBuilder txt = new StringBuilder();
        for (int i = 0; i < str.length(); i += 6) {
            byte _byte = (byte)Integer.parseInt(str.substring(i, i + 6), 2);
            char convChar = (char)(_byte = Util.convert6BitCharToStandardAscii(_byte));
            if (convChar == '@') break;
            txt.append((char)_byte);
        }
        return txt.toString().trim();
    }

    @VisibleForTesting
    static byte convert6BitCharToStandardAscii(byte byteToConvert) {
        byte b = 0;
        if (byteToConvert < 32) {
            b = (byte)(byteToConvert + 64);
        } else if (byteToConvert < 63) {
            b = byteToConvert;
        }
        return b;
    }

    public static void checkLatLong(double lat, double lon) {
        Util.checkArgument(lon <= 181.0, "longitude out of range " + lon);
        Util.checkArgument(lon > -180.0, "longitude out of range " + lon);
        Util.checkArgument(lat <= 91.0, "latitude out of range " + lat);
        Util.checkArgument(lat > -90.0, "latitude out of range " + lat);
    }

    public static void checkLat(double lat) {
        Util.checkArgument(lat <= 91.0, "latitude out of range ");
        Util.checkArgument(lat > -90.0, "latitude out of range ");
    }

    public static void checkLong(double lon) {
        Util.checkArgument(lon <= 181.0, "longitude out of range");
        Util.checkArgument(lon > -180.0, "longitude out of range");
    }

    public static void checkArgument(boolean b, String message) {
        if (!b) {
            throw new AisParseException(message);
        }
    }

    public static AisExtractorFactory getAisExtractorFactory() {
        return extractorFactory;
    }

    public static void checkMessageId(int messageId, AisMessageType ... messageTypes) {
        boolean found = false;
        for (AisMessageType messageType : messageTypes) {
            if (messageType.getId() != messageId) continue;
            found = true;
        }
        if (!found) {
            StringBuffer s = new StringBuffer();
            for (AisMessageType messageType : messageTypes) {
                if (s.length() > 0) {
                    s.append(",");
                }
                s.append(messageType.getId() + "");
            }
            Util.checkArgument(found, "messageId must be in [" + s + "]  but was " + messageId);
        }
    }

    public static boolean areEqual(int i, int j) {
        return i == j;
    }

    public static boolean isClassAPositionReport(int messageId) {
        return messageId == 1 || messageId == 2 || messageId == 3;
    }
}

