/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import au.gov.amsa.ais.AisExtractor;
import com.google.common.annotations.VisibleForTesting;

public class Communications {
    private final int startIndex;
    private final int syncState;
    private final int slotTimeout;
    private final Integer receivedStations;
    private final Integer slotNumber;
    private final Integer hourUtc;
    private final Integer minuteUtc;
    private final Integer slotOffset;

    public Communications(AisExtractor extractor, int startIndex) {
        this.startIndex = startIndex;
        this.syncState = extractor.getValue(startIndex, startIndex + 2);
        this.slotTimeout = extractor.getValue(startIndex + 2, startIndex + 5);
        this.receivedStations = Communications.getReceivedStations(extractor, this.slotTimeout, startIndex);
        this.slotNumber = Communications.getSlotNumber(extractor, this.slotTimeout, startIndex);
        this.hourUtc = Communications.getHourUtc(extractor, this.slotTimeout, startIndex);
        this.minuteUtc = Communications.getMinuteUtc(extractor, this.slotTimeout, startIndex);
        this.slotOffset = Communications.getSlotOffset(extractor, this.slotTimeout, startIndex);
    }

    @VisibleForTesting
    static Integer getReceivedStations(AisExtractor extractor, int slotTimeout, int startIndex) {
        if (slotTimeout == 3 || slotTimeout == 5 || slotTimeout == 7) {
            return extractor.getValue(startIndex + 5, startIndex + 19);
        }
        return null;
    }

    @VisibleForTesting
    static Integer getSlotNumber(AisExtractor extractor, int slotTimeout, int startIndex) {
        if (slotTimeout == 2 || slotTimeout == 4 || slotTimeout == 6) {
            return extractor.getValue(startIndex + 5, startIndex + 19);
        }
        return null;
    }

    private static Integer getHourUtc(AisExtractor extractor, int slotTimeout, int startIndex) {
        if (slotTimeout == 1) {
            int hours = extractor.getValue(startIndex + 5, startIndex + 10);
            return hours;
        }
        return null;
    }

    private static Integer getMinuteUtc(AisExtractor extractor, int slotTimeout, int startIndex) {
        if (slotTimeout == 1) {
            int minutes = extractor.getValue(startIndex + 10, startIndex + 17);
            return minutes;
        }
        return null;
    }

    private static Integer getSlotOffset(AisExtractor extractor, int slotTimeout, int startIndex) {
        if (slotTimeout == 0) {
            return extractor.getValue(startIndex + 5, startIndex + 19);
        }
        return null;
    }

    public int getSyncState() {
        return this.syncState;
    }

    public int getSlotTimeout() {
        return this.slotTimeout;
    }

    public Integer getReceivedStations() {
        return this.receivedStations;
    }

    public Integer getSlotNumber() {
        return this.slotNumber;
    }

    public Integer getHourUtc() {
        return this.hourUtc;
    }

    public Integer getMinuteUtc() {
        return this.minuteUtc;
    }

    public Integer getMinutesUtc() {
        return Communications.getMinutesUtc(this.slotTimeout, this.hourUtc, this.minuteUtc);
    }

    private static Integer getMinutesUtc(int slotTimeout, Integer hour, Integer minute) {
        if (slotTimeout == 1) {
            return hour * 60 + minute;
        }
        return null;
    }

    public Integer getSlotOffset() {
        return this.slotOffset;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Communications [startIndex=");
        builder.append(this.startIndex);
        builder.append(", syncState=");
        builder.append(this.syncState);
        builder.append(", slotTimeout=");
        builder.append(this.slotTimeout);
        builder.append(", receivedStations=");
        builder.append(this.receivedStations);
        builder.append(", slotNumber=");
        builder.append(this.slotNumber);
        builder.append(", hourUtc=");
        builder.append(this.hourUtc);
        builder.append(", minuteUtc=");
        builder.append(this.minuteUtc);
        builder.append(", slotOffset=");
        builder.append(this.slotOffset);
        builder.append("]");
        return builder.toString();
    }
}

