/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.util.nmea;

import au.gov.amsa.util.nmea.NmeaMessage;
import au.gov.amsa.util.nmea.NmeaMessageParseException;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class NmeaMessageParser {
    private static final String CHECKSUM_DELIMITER = "*";
    private static final String PARAMETER_DELIMITER = ",";
    private static final String CODE_DELIMITER = ":";

    public NmeaMessage parse(String line) {
        String remaining;
        LinkedHashMap<String, String> tags = Maps.newLinkedHashMap();
        if (line.startsWith("\\")) {
            int tagFinish = line.lastIndexOf(92, line.length() - 1);
            if (tagFinish == -1) {
                throw new NmeaMessageParseException("no matching \\ symbol to finish tag block: " + line);
            }
            if (tagFinish == 0) {
                throw new NmeaMessageParseException("tag block is empty or not terminated");
            }
            tags = NmeaMessageParser.extractTags(line.substring(1, tagFinish));
            remaining = line.substring(tagFinish + 1);
        } else {
            remaining = line;
        }
        if (!remaining.contains(CHECKSUM_DELIMITER)) {
            throw new NmeaMessageParseException("checksum delimiter * not found");
        }
        String[] items = NmeaMessageParser.getNmeaItems(remaining);
        String checksum = line.substring(line.indexOf(42) + 1);
        return new NmeaMessage(tags, Arrays.asList(items), checksum);
    }

    private static String[] getNmeaItems(String line) {
        String[] items = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)line, (String)PARAMETER_DELIMITER);
        String last = items[items.length - 1];
        if (last.contains(CHECKSUM_DELIMITER)) {
            items[items.length - 1] = last.substring(0, last.lastIndexOf(42));
        }
        return items;
    }

    public static LinkedHashMap<String, String> extractTags(String s) {
        String[] items;
        LinkedHashMap map = Maps.newLinkedHashMap();
        s = s.substring(0, s.lastIndexOf(CHECKSUM_DELIMITER));
        for (String item : items = s.split(PARAMETER_DELIMITER)) {
            int i = item.indexOf(CODE_DELIMITER);
            if (i == -1) {
                throw new NmeaMessageParseException("TAG BLOCK parameter is not is format 'a:b' :" + s);
            }
            map.put(item.substring(0, i), item.substring(i + 1));
        }
        return map;
    }
}

