/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.Util;
import au.gov.amsa.ais.message.AisShipStatic;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Calendar;
import java.util.TimeZone;

public class AisShipStaticA
implements AisShipStatic {
    private final String source;
    private final int messageId;
    private Integer repeatIndicator;
    private final int mmsi;
    private Integer aisVersionIndicator;
    private Integer imo;
    private String callsign;
    private String name;
    private Integer dimensionA;
    private Integer dimensionB;
    private Integer dimensionC;
    private Integer dimensionD;
    private Integer typeOfElectronicPositionFixingDevice;
    private Long expectedTimeOfArrival;
    private Long expectedTimeOfArrivalUnprocessed;
    private Double maximumPresentStaticDraughtMetres;
    private String destination;
    private Boolean dataTerminalAvailable;
    private Integer spare;
    private Integer shipType;
    private final AisExtractor extractor;

    public AisShipStaticA(String message, String source, int padBits) {
        this(Util.getAisExtractorFactory(), message, source, padBits);
    }

    public AisShipStaticA(AisExtractorFactory factory, String message, String source, int padBits) {
        this.source = source;
        this.extractor = factory.create(message, 421, padBits);
        this.messageId = this.extractor.getValue(0, 6);
        Util.checkMessageId(this.getMessageId(), AisMessageType.STATIC_AND_VOYAGE_RELATED_DATA);
        this.mmsi = this.extractor.getValue(8, 38);
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public int getRepeatIndicator() {
        if (this.repeatIndicator == null) {
            this.repeatIndicator = this.extractor.getValue(6, 8);
        }
        return this.repeatIndicator;
    }

    @Override
    public int getMmsi() {
        return this.mmsi;
    }

    public int getAisVersionIndicator() {
        if (this.aisVersionIndicator == null) {
            this.aisVersionIndicator = this.extractor.getValue(38, 40);
        }
        return this.aisVersionIndicator;
    }

    public Optional<Integer> getImo() {
        if (this.imo == null) {
            this.imo = this.extractor.getValue(40, 70);
        }
        if (this.imo == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)this.imo);
    }

    public String getCallsign() {
        if (this.callsign == null) {
            this.callsign = this.extractor.getString(70, 112);
        }
        return this.callsign;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.extractor.getString(112, 232);
        }
        return this.name;
    }

    @Override
    public int getShipType() {
        if (this.shipType == null) {
            this.shipType = this.extractor.getValue(232, 240);
        }
        return this.shipType;
    }

    @Override
    public Optional<Integer> getDimensionA() {
        if (this.dimensionA == null) {
            this.dimensionA = this.extractor.getValue(240, 249);
        }
        if (this.dimensionA == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)this.dimensionA);
    }

    @Override
    public Optional<Integer> getDimensionB() {
        if (this.dimensionB == null) {
            this.dimensionB = this.extractor.getValue(249, 258);
        }
        if (this.dimensionB == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)this.dimensionB);
    }

    @Override
    public Optional<Integer> getDimensionC() {
        if (this.dimensionC == null) {
            this.dimensionC = this.extractor.getValue(258, 264);
        }
        if (this.dimensionC == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)this.dimensionC);
    }

    @Override
    public Optional<Integer> getDimensionD() {
        if (this.dimensionD == null) {
            this.dimensionD = this.extractor.getValue(264, 270);
        }
        if (this.dimensionD == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)this.dimensionD);
    }

    @Override
    public Optional<Integer> getLengthMetres() {
        Optional<Integer> a = this.getDimensionA();
        Optional<Integer> b = this.getDimensionB();
        if (a.isPresent() && b.isPresent()) {
            return Optional.of((Object)((Integer)a.get() + (Integer)b.get()));
        }
        Optional<Integer> c = this.getDimensionC();
        Optional<Integer> d = this.getDimensionD();
        if (!a.isPresent() && !c.isPresent() && b.isPresent() && d.isPresent()) {
            return b;
        }
        return Optional.absent();
    }

    @Override
    public Optional<Integer> getWidthMetres() {
        Optional<Integer> c = this.getDimensionC();
        Optional<Integer> d = this.getDimensionD();
        if (c.isPresent() && d.isPresent()) {
            return Optional.of((Object)((Integer)c.get() + (Integer)d.get()));
        }
        Optional<Integer> a = this.getDimensionA();
        Optional<Integer> b = this.getDimensionB();
        if (!a.isPresent() && !c.isPresent() && b.isPresent() && d.isPresent()) {
            return d;
        }
        return Optional.absent();
    }

    public int getTypeOfElectronicPositionFixingDevice() {
        if (this.typeOfElectronicPositionFixingDevice == null) {
            this.typeOfElectronicPositionFixingDevice = this.extractor.getValue(270, 274);
        }
        return this.typeOfElectronicPositionFixingDevice;
    }

    private static long getExpectedTimeOfArrival(int month, int day, int hour, int minute) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        int year = cal.get(1);
        return AisShipStaticA.getExpectedTimeOfArrival(year, month, day, hour, minute);
    }

    @VisibleForTesting
    static long getExpectedTimeOfArrival(int year, int month, int day, int hour, int minute) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(year, month - 1, day, hour, minute);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public long getExpectedTimeOfArrival() {
        if (this.expectedTimeOfArrival == null) {
            int month = this.extractor.getValue(274, 278);
            int day = this.extractor.getValue(278, 283);
            int hour = this.extractor.getValue(283, 288);
            int minute = this.extractor.getValue(288, 294);
            this.expectedTimeOfArrival = AisShipStaticA.getExpectedTimeOfArrival(month, day, hour, minute);
        }
        return this.expectedTimeOfArrival;
    }

    public long getExpectedTimeOfArrivalUnprocessed() {
        if (this.expectedTimeOfArrivalUnprocessed == null) {
            this.expectedTimeOfArrivalUnprocessed = this.extractor.getValue(274, 294);
        }
        return this.expectedTimeOfArrivalUnprocessed;
    }

    public double getMaximumPresentStaticDraughtMetres() {
        if (this.maximumPresentStaticDraughtMetres == null) {
            this.maximumPresentStaticDraughtMetres = (double)this.extractor.getValue(294, 302) / 10.0;
        }
        return this.maximumPresentStaticDraughtMetres;
    }

    public String getDestination() {
        if (this.destination == null) {
            this.destination = this.extractor.getString(302, 422);
        }
        return this.destination;
    }

    public boolean getDataTerminalAvailable() {
        if (this.dataTerminalAvailable == null) {
            this.dataTerminalAvailable = Util.areEqual(this.extractor.getValue(422, 423), 0);
        }
        return this.dataTerminalAvailable;
    }

    public int getSpare() {
        if (this.spare == null) {
            this.spare = this.extractor.getValue(423, 424);
        }
        return this.spare;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AisShipStaticA [source=");
        b.append(this.source);
        b.append(", messageId=");
        b.append(this.getMessageId());
        b.append(", repeatIndicator=");
        b.append(this.getRepeatIndicator());
        b.append(", mmsi=");
        b.append(this.mmsi);
        b.append(", aisVersionIndicator=");
        b.append(this.getAisVersionIndicator());
        b.append(", imo=");
        b.append(this.getImo());
        b.append(", callsign=");
        b.append(this.getCallsign());
        b.append(", name=");
        b.append(this.getName());
        b.append(", dimensionA=");
        b.append(this.getDimensionA());
        b.append(", dimensionB=");
        b.append(this.getDimensionB());
        b.append(", dimensionC=");
        b.append(this.getDimensionC());
        b.append(", dimensionD=");
        b.append(this.getDimensionD());
        b.append(", typeOfElectronicPositionFixingDevice=");
        b.append(this.getTypeOfElectronicPositionFixingDevice());
        b.append(", expectedTimeOfArrival=");
        b.append(this.getExpectedTimeOfArrival());
        b.append(", expectedTimeOfArrivalUnprocessed=");
        b.append(this.getExpectedTimeOfArrivalUnprocessed());
        b.append(", maximumPresentStaticDraughtMetres=");
        b.append(this.getMaximumPresentStaticDraughtMetres());
        b.append(", destination=");
        b.append(this.getDestination());
        b.append(", dataTerminalAvailable=");
        b.append(this.getDataTerminalAvailable());
        b.append(", spare=");
        b.append(this.getSpare());
        b.append(", shipType=");
        b.append(this.getShipType());
        b.append("]");
        return b.toString();
    }
}

