/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import au.gov.amsa.ais.AisNmeaBuffer;
import au.gov.amsa.ais.AisNmeaMessage;
import au.gov.amsa.ais.AisParseException;
import au.gov.amsa.ais.LineAndTime;
import au.gov.amsa.ais.NmeaMessageExactEarthTimestamp;
import au.gov.amsa.ais.NmeaStreamProcessorListener;
import au.gov.amsa.util.nmea.NmeaMessage;
import au.gov.amsa.util.nmea.NmeaMessageParseException;
import au.gov.amsa.util.nmea.NmeaUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NmeaStreamProcessor {
    private static final int DEFAULT_NMEA_BUFFER_SIZE = 100;
    private static final int DEFAULT_LOG_COUNT_FREQUENCY = 100000;
    private static Logger log = LoggerFactory.getLogger(NmeaStreamProcessor.class);
    private static final long MAXIMUM_ARRIVAL_TIME_DIFFERENCE_MS = 1000L;
    private final NmeaStreamProcessorListener listener;
    private final List<LineAndTime> lines = Lists.newArrayList();
    private final boolean matchWithTimestampLine;
    private final AtomicLong count = new AtomicLong();
    private final long logCountFrequency;
    private final AisNmeaBuffer nmeaBuffer;

    public NmeaStreamProcessor(NmeaStreamProcessorListener listener, boolean matchWithTimestampLine, long logCountFrequency, int nmeaBufferSize) {
        this.listener = listener;
        this.matchWithTimestampLine = matchWithTimestampLine;
        this.logCountFrequency = logCountFrequency;
        this.nmeaBuffer = new AisNmeaBuffer(nmeaBufferSize);
    }

    public NmeaStreamProcessor(NmeaStreamProcessorListener listener, boolean matchWithTimestampLine, long logCountFrequency) {
        this(listener, matchWithTimestampLine, logCountFrequency, 100);
    }

    public NmeaStreamProcessor(NmeaStreamProcessorListener listener, boolean matchWithTimestampLine) {
        this(listener, matchWithTimestampLine, 100000L, 100);
    }

    public void line(String line) {
        this.line(line, System.currentTimeMillis());
    }

    synchronized void line(String line, long arrivalTime) {
        NmeaMessage nmea;
        if (this.count.incrementAndGet() % this.logCountFrequency == 0L) {
            log.info("count=" + this.count.get() + ",buffer size=" + this.lines.size());
        }
        try {
            nmea = NmeaUtil.parseNmea(line);
        }
        catch (NmeaMessageParseException e) {
            this.listener.invalidNmea(line, arrivalTime, e.getMessage());
            return;
        }
        if (!nmea.isSingleSentence()) {
            Optional<NmeaMessage> joined;
            Optional<List<NmeaMessage>> messages = this.nmeaBuffer.add(nmea);
            if (messages.isPresent() && (joined = AisNmeaBuffer.concatenateMessages((List)messages.get())).isPresent()) {
                if (((NmeaMessage)joined.get()).getUnixTimeMillis() != null) {
                    this.listener.message(((NmeaMessage)joined.get()).toLine(), ((NmeaMessage)joined.get()).getUnixTimeMillis());
                } else {
                    this.listener.message(((NmeaMessage)joined.get()).toLine(), arrivalTime);
                }
            }
            return;
        }
        if (nmea.getUnixTimeMillis() != null) {
            this.listener.message(line, nmea.getUnixTimeMillis());
            return;
        }
        if (!this.matchWithTimestampLine) {
            this.listener.message(line, arrivalTime);
            return;
        }
        if (!NmeaUtil.isValid(line)) {
            return;
        }
        this.addLine(line, arrivalTime);
        log.debug("buffer lines=" + this.lines.size());
        Integer earliestTimestampLineIndex = NmeaStreamProcessor.getEarliestTimestampLineIndex(this.lines);
        Set<Integer> removeThese = earliestTimestampLineIndex != null ? this.matchWithClosestAisMessageIfBufferLargeEnough(arrivalTime, earliestTimestampLineIndex) : this.findExpiredIndexesBeforeIndex(this.lastIndex());
        TreeSet orderedIndexes = Sets.newTreeSet(removeThese);
        Iterator iterator = orderedIndexes.descendingSet().iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.removeLineWithIndex(index);
        }
    }

    private int lastIndex() {
        return this.lines.size() - 1;
    }

    private Set<Integer> findExpiredIndexesBeforeIndex(int index) {
        long indexTime = this.getLineTime(index);
        HashSet removeThese = Sets.newHashSet();
        for (int i = index - 1; i >= 0; --i) {
            if (indexTime - this.getLineTime(i) <= 1000L) continue;
            this.listener.timestampNotFound(this.getLine(i), this.getLineTime(i));
            removeThese.add(i);
        }
        return removeThese;
    }

    private Set<Integer> matchWithClosestAisMessageIfBufferLargeEnough(long arrivalTime, Integer earliestTimestampLineIndex) {
        String timestampLine = this.getLine(earliestTimestampLineIndex);
        long time = this.getLineTime(earliestTimestampLineIndex);
        log.debug("ts=" + timestampLine + ",time=" + time);
        Set<Integer> removeThese = arrivalTime - time > 1000L ? this.matchWithClosestAisMessageAndFindIndexesToRemove(earliestTimestampLineIndex, timestampLine, time) : this.findExpiredIndexesBeforeIndex(earliestTimestampLineIndex);
        return removeThese;
    }

    private Set<Integer> matchWithClosestAisMessageAndFindIndexesToRemove(int earliestTimestampLineIndex, String timestampLine, long time) {
        NmeaMessageExactEarthTimestamp timestamp = new NmeaMessageExactEarthTimestamp(timestampLine);
        String checksum = timestamp.getFollowingSequenceChecksum();
        log.debug("looking for checksum=" + checksum);
        Integer lowestTimeDiffIndex = this.findClosestMatchingMessageInTermsOfArrivalTime(time, checksum);
        HashSet removeThese = lowestTimeDiffIndex != null ? this.reportMatchAndFindIndexesToRemove(earliestTimestampLineIndex, timestamp, lowestTimeDiffIndex) : Sets.newHashSet((Object[])new Integer[]{earliestTimestampLineIndex});
        return removeThese;
    }

    private Integer findClosestMatchingMessageInTermsOfArrivalTime(long time, String checksum) {
        Long lowestTimeDiff = null;
        Integer lowestTimeDiffIndex = null;
        for (int i = 0; i < this.getNumLines(); ++i) {
            String msg = this.getLine(i);
            Long msgTime = this.getLineTime(i);
            if (NmeaMessageExactEarthTimestamp.isExactEarthTimestamp(msg)) continue;
            try {
                boolean closer;
                AisNmeaMessage nmea = new AisNmeaMessage(msg);
                if (!nmea.getChecksum().equals(checksum)) continue;
                long diff = Math.abs(msgTime - time);
                boolean bl = closer = (lowestTimeDiff == null || diff < lowestTimeDiff) && diff <= 1000L;
                if (!closer) continue;
                lowestTimeDiff = diff;
                lowestTimeDiffIndex = i;
                continue;
            }
            catch (AisParseException e) {
                log.debug(e.getMessage());
            }
        }
        return lowestTimeDiffIndex;
    }

    private Set<Integer> reportMatchAndFindIndexesToRemove(Integer earliestTimestampLineIndex, NmeaMessageExactEarthTimestamp timestamp, Integer lowestTimeDiffIndex) {
        String msg = this.getLine(lowestTimeDiffIndex);
        log.debug("found matching msg=" + msg);
        this.listener.message(msg, timestamp.getTime());
        int maxIndex = Math.max(lowestTimeDiffIndex, earliestTimestampLineIndex);
        int minIndex = Math.min(lowestTimeDiffIndex, earliestTimestampLineIndex);
        return Sets.newHashSet((Object[])new Integer[]{minIndex, maxIndex});
    }

    private void addLine(String line, long time) {
        this.lines.add(new LineAndTime(line, time));
    }

    private int getNumLines() {
        return this.lines.size();
    }

    private String getLine(int index) {
        return this.lines.get(index).getLine();
    }

    private long getLineTime(int index) {
        return this.lines.get(index).getTime();
    }

    private void removeLineWithIndex(int index) {
        this.lines.remove(index);
    }

    @VisibleForTesting
    List<LineAndTime> getBuffer() {
        return Lists.newArrayList(this.lines);
    }

    private static Integer getEarliestTimestampLineIndex(List<LineAndTime> lines) {
        Integer i = 0;
        for (LineAndTime line : lines) {
            if (NmeaMessageExactEarthTimestamp.isExactEarthTimestamp(line.getLine())) {
                return i;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return null;
    }
}

