/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import au.gov.amsa.ais.AisParseException;
import au.gov.amsa.ais.Util;
import au.gov.amsa.util.nmea.NmeaMessage;
import au.gov.amsa.util.nmea.NmeaMessageParseException;
import au.gov.amsa.util.nmea.NmeaUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.Calendar;
import java.util.regex.Pattern;

public class NmeaMessageExactEarthTimestamp {
    private final NmeaMessage nmea;
    private final long time;
    private final String followingSequenceChecksum;
    private static final Pattern pghpPattern = Pattern.compile("^(\\\\.*\\\\)?\\$PGHP.*$");

    public NmeaMessageExactEarthTimestamp(String line) {
        this.nmea = NmeaUtil.parseNmea(line);
        try {
            Util.checkArgument(NmeaMessageExactEarthTimestamp.isPghp(line), "not an ExactEarth timestamp: " + line);
            this.getFollowingSequenceChecksum();
            int year = Integer.parseInt(this.getItem(2));
            int month = Integer.parseInt(this.getItem(3));
            int day = Integer.parseInt(this.getItem(4));
            int hour = Integer.parseInt(this.getItem(5));
            int minute = Integer.parseInt(this.getItem(6));
            int second = Integer.parseInt(this.getItem(7));
            int millisecond = Integer.parseInt(this.getItem(8));
            this.time = NmeaMessageExactEarthTimestamp.getTime(year, month, day, hour, minute, second, millisecond);
            this.followingSequenceChecksum = this.extractFollowingSequenceChecksum();
        }
        catch (RuntimeException e) {
            throw new AisParseException(e);
        }
    }

    @VisibleForTesting
    static boolean isPghp(String line) {
        if (line == null) {
            return false;
        }
        return pghpPattern.matcher(line).matches();
    }

    public static boolean isExactEarthTimestamp(String line) {
        try {
            new NmeaMessageExactEarthTimestamp(line);
            return true;
        }
        catch (AisParseException e) {
            return false;
        }
        catch (NmeaMessageParseException e) {
            return false;
        }
    }

    private String getItem(int index) {
        return this.nmea.getItems().get(index);
    }

    private static long getTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Calendar cal = Calendar.getInstance(Util.TIME_ZONE_UTC);
        cal.set(year, month - 1, day, hour, minute, second);
        cal.set(14, millisecond);
        return cal.getTimeInMillis();
    }

    public long getTime() {
        return this.time;
    }

    public String getFollowingSequenceChecksum() {
        return this.followingSequenceChecksum;
    }

    private String extractFollowingSequenceChecksum() {
        return this.getItem(13);
    }
}

