/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;

public final class AtonTypeDecoder {
    private static String[] categoryTypes = new String[]{"Fixed - ", "Floating - "};
    private static String[] atonTypes = new String[]{"Not specified", "Reference point", "RACON", "Fixed structure", "Reserved for future use", "Light, without sectors", "Light, with sectors", "Leading Light Front", "Leading Light Rear", "Beacon, Cardinal N", "Beacon, Cardinal E", "Beacon, Cardinal S", "Beacon, Cardinal W", "Beacon, Port hand", "Beacon, Starboard hand", "Beacon, Preferred Channel port hand", "Beacon, Preferred Channel starboard hand", "Beacon, Isolated danger", "Beacon, Safe water", "Beacon, Special mark", "Cardinal Mark N", "Cardinal Mark E", "Cardinal Mark S", "Cardinal Mark W", "Port hand Mark", "Starboard hand Mark", "Preferred Channel Port hand", "Preferred Channel Starboard hand", "Isolated danger", "Safe Water", "Special Mark", "Light Vessel, LANBY, Rigs"};

    private AtonTypeDecoder() {
    }

    @VisibleForTesting
    static void forTestCoverageOnly() {
        new AtonTypeDecoder();
    }

    public static String getAtonType(BigInteger ts) {
        if (ts == null) {
            return null;
        }
        return AtonTypeDecoder.getAtonType(ts.intValue());
    }

    public static String getAtonType(Integer ts) {
        if (ts == null) {
            return null;
        }
        if (ts < 0 || ts > 31) {
            return "unknown code " + ts;
        }
        if (ts >= 0 && ts < 5) {
            return atonTypes[ts];
        }
        if (ts < 20) {
            return categoryTypes[0] + atonTypes[ts];
        }
        return categoryTypes[1] + atonTypes[ts];
    }
}

