/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import au.gov.amsa.util.nmea.NmeaMessage;
import au.gov.amsa.util.nmea.NmeaMessageParseException;
import au.gov.amsa.util.nmea.NmeaUtil;
import com.google.common.base.Optional;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class AisNmeaBuffer {
    private static final int AIS_MESSAGE_COL_NO = 5;
    private static final int MIN_NUM_COLS_FOR_LINE_TO_BE_AGGREGATED = 6;
    private static final int COLUMN_TO_AGGREGATE = 5;
    private final int maxBufferSize;
    private final LinkedHashMultimap<String, NmeaMessage> buffer;
    private final AtomicBoolean adding = new AtomicBoolean();

    public AisNmeaBuffer(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        this.buffer = LinkedHashMultimap.create();
    }

    public Optional<List<NmeaMessage>> add(NmeaMessage nmea) {
        while (!this.adding.compareAndSet(false, true)) {
        }
        Optional<List<NmeaMessage>> result = this.doAdd(nmea);
        this.adding.set(false);
        return result;
    }

    private Optional<List<NmeaMessage>> doAdd(NmeaMessage nmea) {
        List<String> items = nmea.getItems();
        if (items.size() < 6) {
            return Optional.of(Collections.singletonList(nmea));
        }
        if (nmea.isSingleSentence()) {
            return Optional.of(Collections.singletonList(nmea));
        }
        String groupId = nmea.getSentenceGroupId();
        this.buffer.put((Object)groupId, (Object)nmea);
        if (this.buffer.size() > this.maxBufferSize) {
            this.buffer.removeAll(this.buffer.keySet().iterator().next());
        }
        int numGroupMessages = nmea.getSentenceCount();
        int numGroupMessagesSoFar = this.buffer.get((Object)groupId).size();
        if (numGroupMessagesSoFar == numGroupMessages) {
            List<NmeaMessage> list = AisNmeaBuffer.orderMessages(this.buffer.get((Object)groupId));
            this.buffer.removeAll((Object)groupId);
            return Optional.of(list);
        }
        return Optional.absent();
    }

    public static Optional<NmeaMessage> concatenateMessages(List<NmeaMessage> list) {
        if (list.size() == 1) {
            return Optional.of((Object)list.get(0));
        }
        NmeaMessage first = list.get(0);
        ArrayList cols = Lists.newArrayList(first.getItems());
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>(first.getTags());
        StringBuilder s = new StringBuilder();
        for (NmeaMessage t : list) {
            s.append(t.getItems().get(5));
        }
        cols.set(5, s.toString());
        cols.set(1, "1");
        cols.set(2, "1");
        tags.put("g", "1-1-" + first.getSentenceGroupId());
        try {
            String checksum = NmeaUtil.getChecksum(NmeaUtil.createNmeaLine(tags, cols));
            NmeaMessage message = new NmeaMessage(tags, cols, checksum);
            return Optional.of((Object)message);
        }
        catch (NmeaMessageParseException e) {
            return Optional.absent();
        }
    }

    private static List<NmeaMessage> orderMessages(Collection<NmeaMessage> c) {
        ArrayList list = Lists.newArrayList(c);
        Collections.sort(list, new Comparator<NmeaMessage>(){

            @Override
            public int compare(NmeaMessage a, NmeaMessage b) {
                return a.getSentenceNumber().compareTo(b.getSentenceNumber());
            }
        });
        return list;
    }

    public int size() {
        return this.buffer.size();
    }
}

