/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.rx;

import java.util.HashMap;
import java.util.Map;
import rx.functions.Func1;

public class Cache<S, T> {
    private final Func1<S, T> factory;
    private final Map<S, T> map = new HashMap<S, T>();

    public Cache(Func1<S, T> factory) {
        this.factory = factory;
    }

    public synchronized Cache<S, T> put(S key, T value) {
        this.map.put(key, value);
        return this;
    }

    public synchronized T get(S key) {
        T value = this.map.get(key);
        if (value == null) {
            Object t = this.factory.call(key);
            this.map.put(key, t);
            return (T)t;
        }
        return value;
    }
}

