/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.AisParseException;
import au.gov.amsa.ais.Communications;
import au.gov.amsa.ais.HasCommunications;
import au.gov.amsa.ais.Util;
import au.gov.amsa.ais.message.AisPosition;

public class AisPositionB
implements AisPosition,
HasCommunications {
    private static final Integer TRUE_HEADING_NOT_AVAILABLE = 511;
    private static final Integer COG_NOT_AVAILABLE = 3600;
    private static final Integer SOG_NOT_AVAILABLE = 1023;
    private static final Integer LONGITUDE_NOT_AVAILABLE = 108600000;
    private static final Integer LATITUDE_NOT_AVAILABLE = 54600000;
    private final AisExtractor extractor;
    private final String source;
    private final int messageId;
    private final int mmsi;
    private final Double longitude;
    private final Double latitude;

    public AisPositionB(String message, String source, int padBits) {
        this(Util.getAisExtractorFactory(), message, source, padBits);
    }

    public AisPositionB(String message, int padBits) {
        this(Util.getAisExtractorFactory(), message, null, padBits);
    }

    public AisPositionB(AisExtractorFactory factory, String message, String source, int padBits) {
        this.source = source;
        this.extractor = factory.create(message, 133, padBits);
        this.messageId = this.extractor.getMessageId();
        Util.checkMessageId(this.getMessageId(), AisMessageType.POSITION_REPORT_CLASS_B);
        this.mmsi = this.extractor.getValue(8, 38);
        this.longitude = AisPositionB.extractLongitude(this.extractor);
        this.latitude = AisPositionB.extractLatitude(this.extractor);
    }

    static Integer extractTrueHeading(AisExtractor extractor) {
        try {
            int val = extractor.getValue(124, 133);
            if (val == TRUE_HEADING_NOT_AVAILABLE) {
                return null;
            }
            if (val > 359) {
                return null;
            }
            return val;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Double extractCourseOverGround(AisExtractor extractor) {
        try {
            int val = extractor.getValue(112, 124);
            if (val == COG_NOT_AVAILABLE || val >= 3600) {
                return null;
            }
            return (double)val / 10.0;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Double extractSpeedOverGround(AisExtractor extractor) {
        int val = extractor.getValue(46, 56);
        if (val == SOG_NOT_AVAILABLE) {
            return null;
        }
        return (double)val / 10.0;
    }

    static Double extractLongitude(AisExtractor extractor) {
        int val = extractor.getSignedValue(57, 85);
        if (val == LONGITUDE_NOT_AVAILABLE) {
            return null;
        }
        Util.checkLong((double)val / 600000.0);
        return (double)val / 600000.0;
    }

    static Double extractLatitude(AisExtractor extractor) {
        int val = extractor.getSignedValue(85, 112);
        if (val == LATITUDE_NOT_AVAILABLE) {
            return null;
        }
        Util.checkLat((double)val / 600000.0);
        return (double)val / 600000.0;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public int getRepeatIndicator() {
        return this.extractor.getValue(6, 8);
    }

    @Override
    public int getMmsi() {
        return this.mmsi;
    }

    public int getSpare() {
        return this.extractor.getValue(38, 46);
    }

    @Override
    public Double getSpeedOverGroundKnots() {
        return AisPositionB.extractSpeedOverGround(this.extractor);
    }

    @Override
    public boolean isHighAccuracyPosition() {
        return Util.areEqual(this.extractor.getValue(56, 57), 1);
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public Double getCourseOverGround() {
        return AisPositionB.extractCourseOverGround(this.extractor);
    }

    @Override
    public Integer getTrueHeading() {
        return AisPositionB.extractTrueHeading(this.extractor);
    }

    @Override
    public int getTimeSecondsOnly() {
        return this.extractor.getValue(133, 139);
    }

    public int getSpare2() {
        return this.extractor.getValue(139, 141);
    }

    public boolean isSotdmaUnit() {
        return Util.areEqual(this.extractor.getValue(141, 142), 0);
    }

    public boolean isEquippedWithIntegratedDisplayForMessages12And14() {
        return Util.areEqual(this.extractor.getValue(142, 143), 1);
    }

    public boolean isEquippedWithDscFunction() {
        return Util.areEqual(this.extractor.getValue(143, 144), 1);
    }

    public boolean canOperateOverWholeMarineBand() {
        return Util.areEqual(this.extractor.getValue(144, 145), 1);
    }

    public boolean canManageFrequenciesViaMessage22() {
        return Util.areEqual(this.extractor.getValue(145, 146), 1);
    }

    public boolean isStationOperatingInAssignedMode() {
        return Util.areEqual(this.extractor.getValue(146, 147), 1);
    }

    @Override
    public boolean isUsingRAIM() {
        return Util.areEqual(this.extractor.getValue(147, 148), 1);
    }

    public boolean isITDMACommunicationState() {
        return Util.areEqual(this.extractor.getValue(148, 149), 1);
    }

    @Override
    public Communications getCommunications() {
        return new Communications(this.extractor, 149);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AisPositionB [source=");
        builder.append(this.source);
        builder.append(", messageId=");
        builder.append(this.messageId);
        builder.append(", repeatIndicator=");
        builder.append(this.getRepeatIndicator());
        builder.append(", mmsi=");
        builder.append(this.mmsi);
        builder.append(", spare=");
        builder.append(this.getSpare());
        builder.append(", speedOverGroundKnots=");
        builder.append(this.getSpeedOverGroundKnots());
        builder.append(", isHighAccuracyPosition=");
        builder.append(this.isHighAccuracyPosition());
        builder.append(", longitude=");
        builder.append(this.longitude);
        builder.append(", latitude=");
        builder.append(this.latitude);
        builder.append(", courseOverGround=");
        builder.append(this.getCourseOverGround());
        builder.append(", trueHeading=");
        builder.append(this.getTrueHeading());
        builder.append(", timeSecondsOnly=");
        builder.append(this.getTimeSecondsOnly());
        builder.append(", spare2=");
        builder.append(this.getSpare2());
        builder.append(", isSotdmaUnit=");
        builder.append(this.isSotdmaUnit());
        builder.append(", isEquippedWithIntegratedDisplayForMessages12And14=");
        builder.append(this.isEquippedWithIntegratedDisplayForMessages12And14());
        builder.append(", isEquippedWithDscFunction=");
        builder.append(this.isEquippedWithDscFunction());
        builder.append(", canOperateOverWholeMarineBand=");
        builder.append(this.canOperateOverWholeMarineBand());
        builder.append(", canManageFrequenciesViaMessage22=");
        builder.append(this.canManageFrequenciesViaMessage22());
        builder.append(", isStationOperatingInAssignedMode=");
        builder.append(this.isStationOperatingInAssignedMode());
        builder.append(", isUsingRAIM=");
        builder.append(this.isUsingRAIM());
        builder.append(", isITDMACommunicationState=");
        builder.append(this.isITDMACommunicationState());
        builder.append(", communications=");
        builder.append(this.getCommunications());
        builder.append("]");
        return builder.toString();
    }
}

