/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.owlapi;

import au.csiro.ontology.Ontology;
import au.csiro.ontology.classification.IReasoner;
import au.csiro.ontology.importer.owl.OWLImporter;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.NamedConcept;
import au.csiro.ontology.util.IProgressMonitor;
import au.csiro.snorocket.core.SnorocketReasoner;
import au.csiro.snorocket.owlapi.ProgressMonitorWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnorocketOWLReasoner
implements OWLReasoner {
    private static final Logger log = LoggerFactory.getLogger(SnorocketOWLReasoner.class);
    static final String REASONER_NAME = "Snorocket";
    private Version REASONER_VERSION;
    private final OWLOntologyManager manager;
    private final OWLDataFactory owlFactory;
    private final OWLOntology owlOntology;
    private final OWLReasonerConfiguration config;
    private final IProgressMonitor monitor;
    private final boolean buffering;
    private final List<String> problems = new ArrayList<String>();
    private final List<OWLOntologyChange> rawChanges = new ArrayList<OWLOntologyChange>();
    private IReasoner reasoner = new SnorocketReasoner();
    private Ontology taxonomy = null;
    private OWLOntologyChangeListener ontologyChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
            SnorocketOWLReasoner.this.handleRawOntologyChanges(changes);
        }
    };

    public SnorocketOWLReasoner(OWLOntology ont, OWLReasonerConfiguration config, boolean buffering) {
        this.owlOntology = ont;
        this.manager = ont.getOWLOntologyManager();
        this.owlFactory = this.manager.getOWLDataFactory();
        this.manager.addOntologyChangeListener(this.ontologyChangeListener);
        this.config = config;
        this.monitor = config != null ? new ProgressMonitorWrapper(config.getProgressMonitor()) : new ProgressMonitorWrapper((ReasonerProgressMonitor)new NullReasonerProgressMonitor());
        this.buffering = buffering;
        this.reasoner.loadAxioms(this.getAxioms(ont));
    }

    private OWLClass getOWLClass(Object id) {
        if (NamedConcept.TOP.equals(id)) {
            return this.owlFactory.getOWLThing();
        }
        if (NamedConcept.BOTTOM.equals(id)) {
            return this.owlFactory.getOWLNothing();
        }
        String iri = (String)id;
        return this.owlFactory.getOWLClass(IRI.create((String)iri));
    }

    private Object getId(OWLClass oc) {
        if (oc.isAnonymous()) {
            return null;
        }
        String id = oc.toStringID();
        if (id.equals("<http://www.w3.org/2002/07/owl#Thing>") || id.equals("http://www.w3.org/2002/07/owl#Thing")) {
            return NamedConcept.TOP;
        }
        if (id.equals("<http://www.w3.org/2002/07/owl#Nothing>") || id.equals("http://www.w3.org/2002/07/owl#Nothing")) {
            return NamedConcept.BOTTOM;
        }
        return id;
    }

    private au.csiro.ontology.Node getNode(OWLClass oc) {
        au.csiro.ontology.Node n;
        Object id = this.getId(oc);
        if (id instanceof String) {
            n = this.getTaxonomy().getNode((String)id);
        } else if (NamedConcept.TOP.equals(id)) {
            n = this.getTaxonomy().getTopNode();
        } else if (NamedConcept.BOTTOM.equals(id)) {
            n = this.getTaxonomy().getBottomNode();
        } else {
            throw new RuntimeException("Unexpected id " + id);
        }
        return n;
    }

    private synchronized void handleRawOntologyChanges(List<? extends OWLOntologyChange> changes) {
        this.rawChanges.addAll(changes);
        if (!this.buffering) {
            this.flush();
        }
    }

    private Node<OWLClass> nodeToOwlClassNode(au.csiro.ontology.Node n) {
        if (n == null) {
            return new OWLClassNode();
        }
        HashSet<OWLClass> classes = new HashSet<OWLClass>();
        for (Object eq : n.getEquivalentConcepts()) {
            classes.add(this.getOWLClass(eq));
        }
        return new OWLClassNode(classes);
    }

    private NodeSet<OWLClass> nodesToOwlClassNodeSet(Set<au.csiro.ontology.Node> nodes) {
        HashSet<Node<OWLClass>> temp = new HashSet<Node<OWLClass>>();
        for (au.csiro.ontology.Node n : nodes) {
            temp.add(this.nodeToOwlClassNode(n));
        }
        return new OWLClassNodeSet(temp);
    }

    private Set<Axiom> getAxioms(OWLOntology ont) {
        HashSet<Axiom> canAxioms = new HashSet<Axiom>();
        ArrayList axioms = new ArrayList();
        for (OWLOntology o : ont.getImportsClosure()) {
            axioms.addAll(o.getAxioms());
        }
        OWLImporter oi = new OWLImporter(axioms);
        Iterator it = null;
        try {
            it = oi.getOntologyVersions(this.monitor);
            while (it.hasNext()) {
                Ontology o = (Ontology)it.next();
                canAxioms.addAll(o.getStatedAxioms());
            }
            List problems = oi.getProblems();
            if (!problems.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Some warnings were detected while importing the ontology: ");
                for (String problem : oi.getProblems()) {
                    sb.append("\n");
                    sb.append(problem);
                }
                log.warn(sb.toString());
            }
        }
        catch (RuntimeException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Could not import ontology. The following problems were identified:");
            for (String problem : oi.getProblems()) {
                sb.append("\n");
                sb.append(problem);
            }
            sb.append("\n");
            sb.append(e.getMessage());
            log.error(sb.toString());
            this.monitor.taskEnded();
            throw new ReasonerInternalException(sb.toString(), (Throwable)e);
        }
        return canAxioms;
    }

    private Set<Axiom> getAxioms(List<OWLAxiom> axioms) {
        HashSet<Axiom> canAxioms = new HashSet<Axiom>();
        OWLImporter oi = new OWLImporter(axioms);
        Iterator it = null;
        try {
            it = oi.getOntologyVersions(this.monitor);
        }
        catch (RuntimeException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Could not import ontology. The following problems were identified:");
            for (String problem : oi.getProblems()) {
                sb.append("\n");
                sb.append(problem);
            }
            log.error(sb.toString(), (Throwable)e);
            this.monitor.taskEnded();
            return null;
        }
        while (it.hasNext()) {
            Ontology o = (Ontology)it.next();
            canAxioms.addAll(o.getStatedAxioms());
        }
        return canAxioms;
    }

    private void classify() {
        this.monitor.taskStarted("Classifying");
        this.monitor.taskBusy();
        this.reasoner = this.reasoner.classify();
        this.monitor.taskEnded();
        this.monitor.taskStarted("Building taxonomy");
        this.monitor.taskBusy();
        this.taxonomy = this.reasoner.getClassifiedOntology();
        this.monitor.taskEnded();
    }

    private Ontology getTaxonomy() {
        if (this.taxonomy == null) {
            this.taxonomy = this.reasoner.getClassifiedOntology();
        }
        return this.taxonomy;
    }

    public String getReasonerName() {
        return REASONER_NAME;
    }

    public Version getReasonerVersion() {
        if (null == this.REASONER_VERSION) {
            Properties p = new Properties();
            try (InputStream is = this.getClass().getResourceAsStream("/plugin.properties");){
                p.load(is);
                String[] versions = p.getProperty("plugin.version").split("[-.]");
                int major = Integer.parseInt(versions[0]);
                int minor = Integer.parseInt(versions[1]);
                int patch = Integer.parseInt(versions[2]);
                int build = (int)(System.currentTimeMillis() / 1000L);
                this.REASONER_VERSION = new Version(major, minor, patch, build);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.REASONER_VERSION;
    }

    public BufferingMode getBufferingMode() {
        return this.buffering ? BufferingMode.BUFFERING : BufferingMode.NON_BUFFERING;
    }

    public void flush() {
        if (this.rawChanges.isEmpty() || !this.buffering) {
            return;
        }
        boolean hasRemoveAxiom = false;
        ArrayList<OWLAxiom> newAxioms = new ArrayList<OWLAxiom>();
        for (OWLOntologyChange change : this.rawChanges) {
            OWLAxiom axiom = change.getAxiom();
            if (axiom instanceof RemoveAxiom) {
                hasRemoveAxiom = true;
                break;
            }
            newAxioms.add(axiom);
        }
        if (hasRemoveAxiom) {
            this.rawChanges.clear();
            this.classify();
            return;
        }
        Set<Axiom> canAxioms = this.getAxioms(newAxioms);
        this.monitor.taskStarted("Classifying incrementally");
        this.monitor.taskBusy();
        this.reasoner.loadAxioms(canAxioms);
        this.reasoner = this.reasoner.classify();
        this.monitor.taskEnded();
        this.monitor.taskStarted("Calculating taxonomy incrementally");
        this.monitor.taskBusy();
        this.taxonomy = this.reasoner.getClassifiedOntology();
        this.monitor.taskEnded();
        this.rawChanges.clear();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this.rawChanges;
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
        for (OWLOntologyChange change : this.rawChanges) {
            if (!(change instanceof AddAxiom)) continue;
            added.add(change.getAxiom());
        }
        return added;
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
        for (OWLOntologyChange change : this.rawChanges) {
            if (!(change instanceof RemoveAxiom)) continue;
            removed.add(change.getAxiom());
        }
        return removed;
    }

    public OWLOntology getRootOntology() {
        return this.owlOntology;
    }

    public void interrupt() {
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        for (InferenceType inferenceType : inferenceTypes) {
            if (!inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) continue;
            this.classify();
        }
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        if (inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) {
            return this.reasoner.isClassified();
        }
        return false;
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return Collections.singleton(InferenceType.CLASS_HIERARCHY);
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        au.csiro.ontology.Node bottom = this.getTaxonomy().getBottomNode();
        return bottom.getEquivalentConcepts().isEmpty();
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        if (classExpression.isAnonymous()) {
            return false;
        }
        Object id = this.getId(classExpression.asOWLClass());
        au.csiro.ontology.Node bottom = this.getTaxonomy().getBottomNode();
        return !bottom.getEquivalentConcepts().contains(id);
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        return this.nodeToOwlClassNode(this.getTaxonomy().getBottomNode());
    }

    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        throw new UnsupportedEntailmentTypeException(axiom);
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        throw new UnsupportedEntailmentTypeException(axioms.iterator().next());
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return false;
    }

    public Node<OWLClass> getTopClassNode() {
        au.csiro.ontology.Node top = this.getTaxonomy().getTopNode();
        return this.nodeToOwlClassNode(top);
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.nodeToOwlClassNode(this.getTaxonomy().getBottomNode());
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        this.checkOntologyConsistent();
        this.checkNamedClass(ce);
        au.csiro.ontology.Node n = this.getNode(ce.asOWLClass());
        if (n == null) {
            return new OWLClassNodeSet();
        }
        Set children = n.getChildren();
        if (direct) {
            return this.nodesToOwlClassNodeSet(children);
        }
        HashSet<au.csiro.ontology.Node> res = new HashSet<au.csiro.ontology.Node>();
        LinkedList<Set> todo = new LinkedList<Set>();
        todo.add(children);
        while (!todo.isEmpty()) {
            Set items = (Set)todo.remove();
            res.addAll(items);
            for (au.csiro.ontology.Node item : items) {
                Set cn = item.getChildren();
                if (cn.isEmpty()) continue;
                todo.add(cn);
            }
        }
        return this.nodesToOwlClassNodeSet(res);
    }

    private void checkNamedClass(OWLClassExpression ce) throws ReasonerInternalException {
        if (ce.isAnonymous()) {
            throw new ReasonerInternalException("Expected a named class, got " + ce);
        }
    }

    private void checkOntologyConsistent() throws InconsistentOntologyException {
        if (!this.problems.isEmpty()) {
            throw new InconsistentOntologyException();
        }
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkOntologyConsistent();
        this.checkNamedClass(ce);
        au.csiro.ontology.Node n = this.getNode(ce.asOWLClass());
        if (n == null) {
            return new OWLClassNodeSet();
        }
        Set parents = n.getParents();
        if (direct) {
            return this.nodesToOwlClassNodeSet(parents);
        }
        HashSet<au.csiro.ontology.Node> res = new HashSet<au.csiro.ontology.Node>();
        LinkedList<Set> todo = new LinkedList<Set>();
        todo.add(parents);
        while (!todo.isEmpty()) {
            Set items = (Set)todo.remove();
            res.addAll(items);
            for (au.csiro.ontology.Node item : items) {
                Set cn = item.getParents();
                if (cn.isEmpty()) continue;
                todo.add(cn);
            }
        }
        return this.nodesToOwlClassNodeSet(res);
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkOntologyConsistent();
        this.checkNamedClass(ce);
        au.csiro.ontology.Node n = this.getNode(ce.asOWLClass());
        return this.nodeToOwlClassNode(n);
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        throw new ReasonerInternalException("getDisjointClasses not implemented");
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return new OWLObjectPropertyNode((OWLObjectPropertyExpression)this.owlFactory.getOWLTopObjectProperty());
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return new OWLObjectPropertyNode((OWLObjectPropertyExpression)this.owlFactory.getOWLBottomObjectProperty());
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getSubObjectProperties not implemented");
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getSuperObjectProperties not implemented");
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return new OWLObjectPropertyNode();
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getDisjointObjectProperties not implemented");
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getInverseObjectProperties not implemented");
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getObjectPropertyDomains not implemented");
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getObjectPropertyRanges not implemented");
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        throw new ReasonerInternalException("getTopDataPropertyNode not implemented");
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        throw new ReasonerInternalException("getBottomDataPropertyNode not implemented");
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getSubDataProperties not implemented");
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getSuperDataProperties not implemented");
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getEquivalentDataProperties not implemented");
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getDisjointDataProperties not implemented");
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getDataPropertyDomains not implemented");
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getTypes not implemented");
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return new OWLNamedIndividualNodeSet();
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getObjectPropertyValues not implemented");
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return Collections.emptySet();
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getSameIndividuals not implemented");
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        throw new ReasonerInternalException("getDifferentIndividuals not implemented");
    }

    public long getTimeOut() {
        return this.config != null ? this.config.getTimeOut() : 0L;
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.config != null ? this.config.getFreshEntityPolicy() : FreshEntityPolicy.DISALLOW;
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.config != null ? this.config.getIndividualNodeSetPolicy() : IndividualNodeSetPolicy.BY_NAME;
    }

    public void dispose() {
        this.owlOntology.getOWLOntologyManager().removeOntologyChangeListener(this.ontologyChangeListener);
        this.rawChanges.clear();
        this.reasoner = new SnorocketReasoner();
    }

    public static void main(String[] args) {
        String filename = args[0];
        File f = new File(filename);
        IRI iri = IRI.create((File)f.getAbsoluteFile());
        try {
            long start = System.currentTimeMillis();
            System.out.println("Loading OWL ontology");
            OWLOntologyManager mgr = OWLManager.createOWLOntologyManager();
            OWLOntology ont = mgr.loadOntologyFromOntologyDocument(iri);
            SnorocketOWLReasoner c = new SnorocketOWLReasoner(ont, null, false);
            System.out.println("Took " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            System.out.println("Classifying");
            c.precomputeInferences(InferenceType.CLASS_HIERARCHY);
            System.out.println("Took " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }
}

