/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.benchmark;

import au.csiro.ontology.Ontology;
import au.csiro.ontology.importer.rf1.RF1Importer;
import au.csiro.ontology.util.IProgressMonitor;
import au.csiro.ontology.util.NullProgressMonitor;
import au.csiro.snorocket.core.CoreFactory;
import au.csiro.snorocket.core.IFactory;
import au.csiro.snorocket.core.NormalisedOntology;
import au.csiro.snorocket.core.benchmark.Stats;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Benchmark {
    static final String OUT_DIR = "src/site/resources/";
    public static final String VERSION = "2.2.0";

    public Stats runBechmarkRF1() {
        Stats res = new Stats();
        String version = "20110731";
        System.out.println("Classifying ontology");
        long start = System.currentTimeMillis();
        CoreFactory factory = new CoreFactory();
        NormalisedOntology no = new NormalisedOntology((IFactory)factory);
        System.out.println("Importing axioms");
        RF1Importer imp = new RF1Importer(this.getClass().getResourceAsStream("/sct1_Concepts_Core_INT_20110731.txt"), this.getClass().getResourceAsStream("/res1_StatedRelationships_Core_INT_20110731.txt"), version);
        Iterator it = imp.getOntologyVersions((IProgressMonitor)new NullProgressMonitor());
        Ontology ont = null;
        while (it.hasNext()) {
            Ontology o = (Ontology)it.next();
            if (!o.getVersion().equals("snomed")) continue;
            ont = o;
            break;
        }
        if (ont == null) {
            throw new RuntimeException("Could not find version " + version + " in input files");
        }
        res.setAxiomTransformationTimeMs(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        System.out.println("Loading axioms");
        no.loadAxioms(new HashSet(ont.getStatedAxioms()));
        res.setAxiomLoadingTimeMs(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        System.out.println("Running classification");
        no.classify();
        res.setClassificationTimeMs(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        System.out.println("Computing taxonomy");
        no.buildTaxonomy();
        res.setTaxonomyBuildingTimeMs(System.currentTimeMillis() - start);
        System.out.println("Done");
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String type = args[0];
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
        if ("RF1".equals(type)) {
            int numRuns = Integer.parseInt(args[1]);
            String outputFile = "src/site/resources/benchmark_2.2.0_" + sdf.format(Calendar.getInstance().getTime()) + ".csv";
            StringBuilder sb = new StringBuilder();
            sb.append("Date,Threads,VM Parameters,Snomed Version,Snorocket Version,Axiom Transformation Time (ms),Axiom Loading Time (ms),Classification Time(ms),Taxonomy Construction Time(ms),Total Time(ms),Used Memory(bytes),Max Memory (bytes)\n");
            Benchmark b = new Benchmark();
            for (int j = 0; j < numRuns; ++j) {
                Stats stats = b.runBechmarkRF1();
                sb.append(sdf.format(Calendar.getInstance().getTime()));
                sb.append(",");
                sb.append(Runtime.getRuntime().availableProcessors());
                sb.append(",");
                RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
                List<String> arguments = RuntimemxBean.getInputArguments();
                for (int i = 0; i < arguments.size(); ++i) {
                    sb.append(arguments.get(i));
                    if (i >= arguments.size()) continue;
                    sb.append(" ");
                }
                sb.append(",");
                sb.append("SNOMED_20110731");
                sb.append(",");
                sb.append(VERSION);
                sb.append(",");
                sb.append(stats.getAxiomTransformationTimeMs());
                sb.append(",");
                sb.append(stats.getAxiomLoadingTimeMs());
                sb.append(",");
                sb.append(stats.getClassificationTimeMs());
                sb.append(",");
                sb.append(stats.getTaxonomyBuildingTimeMs());
                sb.append(",");
                sb.append(stats.getTotalTime());
                sb.append(",");
                sb.append(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
                sb.append(",");
                sb.append(Runtime.getRuntime().maxMemory());
                sb.append("\n");
                System.gc();
            }
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputFile).getAbsoluteFile()), StandardCharsets.UTF_8));
                bw.write(sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            System.out.println("Unknown input type " + type);
            System.exit(0);
        }
    }
}

