/**
 * Copyright (c) 2009 International Health Terminology Standards Development
 * Organisation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Copyright CSIRO Australian e-Health Research Centre (http://aehrc.com).
 * All rights reserved. Use is subject to license terms and conditions.
 */

package au.csiro.snorocket.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineReader {
    private int lineNumber = 0;
    private BufferedReader reader;

    public LineReader(Reader reader) {
        this(new BufferedReader(reader));
    }

    public LineReader(BufferedReader bufferedReader) {
        reader = bufferedReader;
    }

    public String readLine() throws IOException {
        final String line = reader.readLine();
        lineNumber++;
        return line;
    }

    public int getLineNumber() {
        return lineNumber;
    }
}
