/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import au.csiro.snorocket.core.util.SparseConceptSetIntIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class SparseConceptSet
implements IConceptSet {
    private static final long serialVersionUID = 1L;
    private int[] items;
    private int size;

    public SparseConceptSet(int capacity) {
        this.items = new int[capacity];
        this.size = 0;
        this.items[this.size] = -1;
    }

    public SparseConceptSet() {
        this(10);
    }

    @Override
    @SuppressFBWarnings(value={"IM_AVERAGE_COMPUTATION_COULD_OVERFLOW"})
    public synchronized void add(int concept) {
        int low = 0;
        int high = this.size;
        while (high - low > 16) {
            int probe = low + high >> 1;
            if (this.items[probe] > concept) {
                low = probe + 1;
                continue;
            }
            if (this.items[probe] < concept) {
                high = probe - 1;
                continue;
            }
            return;
        }
        while (concept < this.items[low]) {
            ++low;
        }
        if (concept > this.items[low]) {
            ++this.size;
            if (this.items.length == this.size) {
                int increment = 10;
                int[] newItems = new int[this.size + 10];
                System.arraycopy(this.items, 0, newItems, 0, low);
                System.arraycopy(this.items, low, newItems, low + 1, this.size - low);
                this.items = newItems;
            } else {
                System.arraycopy(this.items, low, this.items, low + 1, this.size - low);
            }
            this.items[low] = concept;
        } else if (concept != this.items[low]) {
            throw new AssertionError((Object)("Internal error detected, expecting items[i] == concept where i = " + low + ", items[i] = " + this.items[low] + ", and concept = " + concept));
        }
    }

    @Override
    public void addAll(IConceptSet set) {
        IntIterator itr = set.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @SuppressFBWarnings(value={"IM_AVERAGE_COMPUTATION_COULD_OVERFLOW"})
    public synchronized boolean contains(int concept) {
        int low = 0;
        int high = this.size;
        while (high - low > 16) {
            int probe = low + high >> 1;
            if (this.items[probe] > concept) {
                low = probe + 1;
                continue;
            }
            if (this.items[probe] < concept) {
                high = probe - 1;
                continue;
            }
            return true;
        }
        while (low < this.items.length && concept < this.items[low]) {
            ++low;
        }
        return low < this.items.length && concept == this.items[low];
    }

    @Override
    public boolean containsAll(IConceptSet concepts) {
        if (concepts.isEmpty()) {
            return true;
        }
        IConceptSet s = IConceptSet.FACTORY.createConceptSet(concepts);
        s.removeAll(this);
        return s.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public synchronized IntIterator iterator() {
        return new SparseConceptSetIntIterator(this.items, this.size);
    }

    @Override
    public void remove(int concept) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll(IConceptSet set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.items[i]);
            if (i + 1 >= this.size) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public synchronized void grow(int newSize) {
        assert (newSize >= this.size);
        int[] newItems = new int[newSize];
        System.arraycopy(this.items, 0, newItems, 0, this.size);
        this.items = newItems;
    }

    @Override
    public synchronized int[] toArray() {
        int[] res = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            res[i] = this.items[i];
        }
        return res;
    }
}

