/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.AbstractConceptMap;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import au.csiro.snorocket.core.util.SparseArray;

public final class SparseConceptMap<V>
extends AbstractConceptMap<V> {
    private static final long serialVersionUID = 1L;
    private final IConceptSet keySet;
    protected SparseArray<V> members;
    protected String lbl;

    @Override
    public int size() {
        return this.keySet.size();
    }

    public SparseConceptMap(int size) {
        this(size, null);
    }

    public SparseConceptMap(int size, String lbl) {
        this.lbl = lbl;
        this.keySet = IConceptSet.FACTORY.createConceptSet(size);
        this.members = new SparseArray(size);
    }

    @Override
    public boolean containsKey(int key) {
        return null != this.members.get(key);
    }

    @Override
    public V get(int key) {
        return this.members.get(key);
    }

    @Override
    public void put(int key, V value) {
        this.keySet.add(key);
        this.members.set(key, value);
    }

    @Override
    public void remove(int key) {
        this.keySet.remove(key);
        this.members.set(key, null);
    }

    @Override
    public IntIterator keyIterator() {
        return this.keySet.iterator();
    }

    @Override
    public void clear() {
        this.keySet.clear();
        this.members.clear();
    }

    @Override
    public void grow(int newSize) {
        this.keySet.grow(newSize);
        this.members.grow(newSize);
    }
}

