/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import java.io.Serializable;
import java.util.Arrays;

public class SparseArray<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int M = 16;
    private int _capacity = 0;
    int counter = 0;
    T[][] groups;

    SparseArray(int size) {
        this._capacity = size;
        this.groups = new Object[(this._capacity - 1) / 16 + 1][];
    }

    T get(int index) {
        if (index == -1) {
            return null;
        }
        if (index / 16 < this.groups.length) {
            T[] group = this.groups[index / 16];
            return null == group ? null : (T)group[index % 16];
        }
        return null;
    }

    void set(int index, T value) {
        Object[] group;
        if (index / 16 >= this.groups.length) {
            this.resize(index + 1);
        }
        if (null == (group = this.groups[index / 16])) {
            Object[] objectArray = new Object[16];
            this.groups[index / 16] = objectArray;
            group = objectArray;
        }
        if (null == group[index % 16]) {
            ++this.counter;
        }
        group[index % 16] = value;
    }

    public void clear() {
        Arrays.fill(this.groups, null);
    }

    private void resize(int newCapacity) {
        this._capacity = newCapacity;
        T[][] oldGroup = this.groups;
        int newSize = (this._capacity - 1) / 16 + 1;
        this.groups = new Object[newSize][];
        System.arraycopy(oldGroup, 0, this.groups, 0, oldGroup.length);
    }

    public void grow(int newSize) {
        this.resize(newSize);
    }
}

