/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.axioms;

import au.csiro.snorocket.core.IFactory;
import au.csiro.snorocket.core.axioms.Inclusion;
import au.csiro.snorocket.core.axioms.NF4;
import au.csiro.snorocket.core.axioms.NF5;
import au.csiro.snorocket.core.axioms.NF6;
import au.csiro.snorocket.core.axioms.NormalFormGCI;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;

public class RI
extends Inclusion {
    private static final long serialVersionUID = 1L;
    private static final int PRIME = 31;
    private final int[] lhs;
    private final int rhs;
    private final int hashCode;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public RI(int[] lhs, int rhs) {
        assert (null != lhs);
        assert (-1 < rhs);
        this.lhs = lhs;
        this.rhs = rhs;
        this.hashCode = 31 * (31 + Arrays.hashCode(this.lhs)) + this.rhs;
    }

    public RI(int lhs, int rhs) {
        this(new int[]{lhs}, rhs);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public int[] getLhs() {
        return this.lhs;
    }

    public int getRhs() {
        return this.rhs;
    }

    @Override
    public Inclusion[] normalise1(IFactory factory) {
        Inclusion[] result = new Inclusion[]{null, null};
        if (!this.rule1(factory, result)) {
            result = null;
        }
        return result;
    }

    @Override
    public Inclusion[] normalise2(IFactory factory) {
        return null;
    }

    boolean rule1(IFactory factory, Inclusion[] gcis) {
        boolean result = false;
        if (this.lhs.length > 2) {
            result = true;
            int k = this.lhs.length - 1;
            int[] newLhs1 = new int[k];
            System.arraycopy(this.lhs, 0, newLhs1, 0, newLhs1.length);
            int u = factory.getRole(newLhs1);
            int[] newLhs2 = new int[]{u, this.lhs[k]};
            gcis[0] = new RI(newLhs1, u);
            gcis[1] = new RI(newLhs2, this.rhs);
        }
        return result;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RI other = (RI)obj;
        if (!Arrays.equals(this.lhs, other.lhs)) {
            return false;
        }
        return this.rhs == other.rhs;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.lhs.length > 0) {
            sb.append(this.lhs[0]);
        }
        for (int i = 1; i < this.lhs.length; ++i) {
            sb.append(" ");
            sb.append(this.lhs[i]);
        }
        sb.append(" [ ");
        sb.append(this.rhs);
        return sb.toString();
    }

    @Override
    public NormalFormGCI getNormalForm() {
        switch (this.lhs.length) {
            case 1: {
                return new NF4(this.lhs[0], this.rhs);
            }
            case 2: {
                return new NF5(this.lhs[0], this.lhs[1], this.rhs);
            }
            case 0: {
                return new NF6(this.rhs);
            }
        }
        throw new IllegalStateException("RI is not in Normal Form");
    }
}

