/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core;

import au.csiro.snorocket.core.AR;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.ReadonlyConceptSet;
import au.csiro.snorocket.core.util.SparseConceptHashSet;
import au.csiro.snorocket.core.util.SparseConceptSet;
import java.util.Arrays;
import java.util.BitSet;

abstract class R1
extends AR {
    private final BitSet currentRoles;
    private final IConceptSet[] base;
    private IConceptSet[] data;

    R1(int concepts, int roles) {
        this(concepts, roles, null);
    }

    R1(int concepts, int roles, R1 initialState) {
        super(concepts, roles);
        this.data = new IConceptSet[this.CONCEPTS * this.ROLES << 1];
        this.currentRoles = new BitSet(this.ROLES);
        if (null != initialState) {
            this.base = initialState.data;
            this.currentRoles.or(initialState.currentRoles);
        } else {
            this.base = null;
        }
    }

    public void subtract(R1 relationships) {
        if (null == this.base) {
            throw new AssertionError((Object)"");
        }
        for (int i = 0; i < this.base.length; ++i) {
            if (null == this.base[i]) continue;
            this.data[i] = new SparseConceptHashSet();
            SparseConceptHashSet set = this.data[i];
            set.addAll(this.base[i]);
            if (null == relationships.data[i]) continue;
            set.removeAll(relationships.data[i]);
        }
    }

    public boolean containsRole(int role) {
        return this.currentRoles.get(role);
    }

    protected IConceptSet getB(int A, int r) {
        int index;
        if (A >= this.CONCEPTS) {
            this.resizeConcepts(A);
        }
        if (r >= this.ROLES) {
            this.resizeRoles(r);
        }
        if (null == this.data[index = this.indexOf(A, r)]) {
            this.data[index] = new SparseConceptSet();
            this.addRole(r);
            if (null != this.base && index < this.base.length && null != this.base[index]) {
                this.data[index].addAll(this.base[index]);
            }
        }
        return this.data[index];
    }

    public void addRole(int r) {
        this.currentRoles.set(r);
    }

    public IConceptSet lookupA(int B, int r) {
        if (B >= this.CONCEPTS || r >= this.ROLES) {
            return IConceptSet.EMPTY_SET;
        }
        int index = this.indexOf(B, r) + 1;
        if (null == this.data[index]) {
            if (null != this.base && index < this.base.length && null != this.base[index]) {
                this.data[index] = new SparseConceptSet();
                this.data[index].addAll(this.base[index]);
                return new ReadonlyConceptSet(this.data[index]);
            }
            return IConceptSet.EMPTY_SET;
        }
        return new ReadonlyConceptSet(this.data[index]);
    }

    public IConceptSet lookupB(int A, int r) {
        if (A >= this.CONCEPTS || r >= this.ROLES) {
            return IConceptSet.EMPTY_SET;
        }
        int index = this.indexOf(A, r);
        if (null == this.data[index]) {
            if (null != this.base && index < this.base.length && null != this.base[index]) {
                this.data[index] = new SparseConceptSet();
                this.data[index].addAll(this.base[index]);
                return new ReadonlyConceptSet(this.data[index]);
            }
            return IConceptSet.EMPTY_SET;
        }
        return new ReadonlyConceptSet(this.data[index]);
    }

    protected IConceptSet getA(int B, int r) {
        int index;
        if (B >= this.CONCEPTS) {
            this.resizeConcepts(B);
        }
        if (r >= this.ROLES) {
            this.resizeRoles(r);
        }
        if (null == this.data[index = this.indexOf(B, r) + 1]) {
            this.data[index] = new SparseConceptSet();
            this.addRole(r);
            if (null != this.base && index < this.base.length && null != this.base[index]) {
                this.data[index].addAll(this.base[index]);
            }
        }
        return this.data[index];
    }

    private int indexOf(int concept, int role) {
        if (role >= this.ROLES) {
            throw new IllegalArgumentException("role " + role + " must be smaller than " + this.ROLES);
        }
        return concept * this.ROLES + role << 1;
    }

    public void clear() {
        Arrays.fill(this.data, null);
        this.currentRoles.clear();
    }

    private void resizeConcepts(int maxConcept) {
        IConceptSet[] oldData = this.data;
        this.CONCEPTS = maxConcept + 1;
        this.data = new IConceptSet[this.CONCEPTS * this.ROLES << 1];
        System.arraycopy(oldData, 0, this.data, 0, oldData.length);
    }

    private void resizeRoles(int maxRole) {
        int OLD_ROLES = this.ROLES;
        IConceptSet[] oldData = this.data;
        this.ROLES = maxRole + 1;
        this.data = new IConceptSet[this.CONCEPTS * this.ROLES << 1];
        for (int c = 0; c < this.CONCEPTS; ++c) {
            for (int r = 0; r < OLD_ROLES; ++r) {
                int newI = c * this.ROLES + r << 1;
                int oldI = c * OLD_ROLES + r << 1;
                this.data[newI] = oldData[oldI];
                this.data[newI + 1] = oldData[oldI + 1];
            }
        }
    }

    public void grow(int newTotalConcepts) {
        this.resizeConcepts(newTotalConcepts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean separator = false;
        for (int index = 0; index < this.data.length; index += 2) {
            if (null == this.data[index]) continue;
            if (separator) {
                sb.append(", ");
            }
            int hash = index >> 1;
            int r = (int)Math.IEEEremainder(hash, this.ROLES);
            int A = (hash - r) / this.ROLES;
            sb.append(A).append(" [ ").append(r).append(".").append(this.data[index]);
            separator = true;
        }
        return sb.toString();
    }
}

