/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core;

import au.csiro.snorocket.core.IQueue;
import au.csiro.snorocket.core.util.MonotonicCollection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;

public final class QueueImpl<QueueEntry>
implements IQueue<QueueEntry>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_ALLOC_SIZE = 4;
    private static final Object[] EMPTY = new Object[0];
    protected int counter = 0;
    protected QueueEntry[] items = EMPTY;
    static int number = 0;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public QueueImpl(Class<QueueEntry> typeToken) {
        ++number;
    }

    @Override
    public void add(QueueEntry entry) {
        this.checkSize(1);
        this.items[this.counter++] = entry;
    }

    @Override
    public void addAll(MonotonicCollection<? extends QueueEntry> queue) {
        try {
            int numberOfNewElements = queue.size();
            this.checkSize(numberOfNewElements);
            System.arraycopy(queue.data, 0, this.items, this.counter, numberOfNewElements);
            this.counter += numberOfNewElements;
        }
        catch (OutOfMemoryError e) {
            System.err.println(number);
            throw e;
        }
    }

    @Override
    public int size() {
        return this.counter;
    }

    private void checkSize(int numberOfNewElements) {
        int size = this.counter + numberOfNewElements;
        int len = this.items.length;
        if (size >= len) {
            int newsize = size > 0 ? size + 4 : 4;
            Object[] newItems = new Object[newsize];
            System.arraycopy(this.items, 0, newItems, 0, this.counter);
            this.items = newItems;
        } else if (len > 2048 && size < len >> 2) {
            int newsize = len >> 1;
            Object[] newItems = new Object[newsize];
            System.arraycopy(this.items, 0, newItems, 0, this.counter);
            this.items = newItems;
        }
    }

    @Override
    public QueueEntry remove() {
        --this.counter;
        return this.items[this.counter];
    }

    @Override
    public boolean isEmpty() {
        if (0 == this.counter) {
            this.items = EMPTY;
            return true;
        }
        return false;
    }
}

