/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import java.util.ArrayList;
import java.util.Arrays;

public final class SparseConceptHashSet
implements IConceptSet {
    private static final long serialVersionUID = 1L;
    private static final int TOMBSTOMB = -2;
    private static final int EMPTY = -1;
    private int[] _items;
    private int _size;

    public SparseConceptHashSet() {
        this.clear();
    }

    public SparseConceptHashSet(int initialCapacity) {
        this.reallocate(initialCapacity);
    }

    private void reallocate(int initialCapacity) {
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this._items = new int[initialCapacity];
        Arrays.fill(this._items, -1);
        this._size = 0;
    }

    private int hash1(int concept) {
        return concept % this._items.length;
    }

    private int hash2(int concept, int base) {
        return (base + 1) % this._items.length;
    }

    @Override
    public void add(int concept) {
        if (this._size >= this._items.length) {
            this.resize(this._items.length * 2);
        }
        int h = this.hash1(concept);
        while (this._items[h] >= 0 && this._items[h] != concept) {
            h = this.hash2(concept, h);
        }
        if (this._items[h] < 0) {
            this._items[h] = concept;
            ++this._size;
        }
        assert (this._items[h] == concept);
    }

    @Override
    public void addAll(IConceptSet set) {
        IntIterator itr = set.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    @Override
    public void clear() {
        this.reallocate(1);
    }

    @Override
    public boolean contains(int concept) {
        int h = this.hash1(concept);
        int counter = this._items.length;
        while (this._items[h] != -1 && this._items[h] != concept && counter-- > 0) {
            h = this.hash2(concept, h);
        }
        return this._items[h] == concept;
    }

    @Override
    public boolean containsAll(IConceptSet concepts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int concept) {
        int h = this.hash1(concept);
        int counter = this._items.length;
        while (this._items[h] != -1 && counter-- > 0) {
            if (concept == this._items[h]) {
                this._items[h] = -2;
                --this._size;
            }
            h = this.hash2(concept, h);
        }
    }

    @Override
    public void removeAll(IConceptSet set) {
        if (this.size() < set.size()) {
            for (int i = 0; i < this._items.length; ++i) {
                int concept = this._items[i];
                if (concept < 0 || !set.contains(concept)) continue;
                this._items[i] = -2;
                --this._size;
            }
        } else {
            IntIterator itr = set.iterator();
            while (itr.hasNext()) {
                int concept = itr.next();
                this.remove(concept);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public IntIterator iterator() {
        if (this._items.length > 1000 && this._size < this._items.length >> 3) {
            this.resize(this._items.length >> 2);
        }
        return new IntIterator(){
            int next = 0;

            @Override
            public boolean hasNext() {
                while (this.next < SparseConceptHashSet.this._items.length && SparseConceptHashSet.this._items[this.next] < 0) {
                    ++this.next;
                }
                return this.next < SparseConceptHashSet.this._items.length;
            }

            @Override
            public int next() {
                return this.hasNext() ? SparseConceptHashSet.this._items[this.next++] : -1;
            }
        };
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            int c = itr.next();
            sb.append(c);
            if (!itr.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void grow(int newSize) {
        this.resize(newSize);
    }

    private void resize(int newSize) {
        int[] oldItems = this._items;
        this.reallocate(newSize);
        for (int i = 0; i < oldItems.length; ++i) {
            int concept = oldItems[i];
            if (concept < 0) continue;
            this.add(concept);
        }
    }

    @Override
    public int[] toArray() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        IntIterator i = this.iterator();
        while (i.hasNext()) {
            res.add(i.next());
        }
        int[] arr = new int[res.size()];
        for (int i2 = 0; i2 < res.size(); ++i2) {
            arr[i2] = (Integer)res.get(i2);
        }
        return arr;
    }
}

