/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.IMonotonicCollection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonotonicCollection<T>
implements IMonotonicCollection<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MonotonicCollection.class);
    public T[] data;
    int count = 0;

    public MonotonicCollection(int size) {
        this.data = new Object[size];
    }

    @Override
    public void add(T element) {
        this.checkSize();
        this.data[this.count++] = element;
    }

    private void checkSize() {
        if (this.count == this.data.length) {
            int newSize;
            int n = newSize = this.count < 0x8000000 ? this.count << 1 : this.count + 10000000;
            if (log.isTraceEnabled() && this.count > 1024) {
                log.trace(this.hashCode() + "\t" + this.getClass().getSimpleName() + " resize to: " + newSize);
            }
            Object[] newData = new Object[newSize];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < MonotonicCollection.this.count;
            }

            @Override
            public T next() {
                return this.hasNext() ? (Object)MonotonicCollection.this.data[this.next++] : null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<T> itr = this.iterator();
        while (itr.hasNext()) {
            T o = itr.next();
            sb.append(o);
            if (!itr.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void addAll(MonotonicCollection<T> collection) {
        for (T element : collection) {
            this.add(element);
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
    }
}

