/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.DenseConceptMap;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import au.csiro.snorocket.core.util.SparseConceptMap;
import java.io.Serializable;

public interface IConceptMap<V>
extends Serializable {
    public static final IConceptMapFactory FACTORY = new IConceptMapFactory(){

        @Override
        public IConceptMap<IConceptSet> createSparseConceptMap(int size) {
            return new SparseConceptMap<IConceptSet>(size);
        }

        @Override
        public IConceptMap<IConceptSet> createDenseConceptMap(int size) {
            return new DenseConceptMap<IConceptSet>(size);
        }
    };

    public boolean containsKey(int var1);

    public V get(int var1);

    public IntIterator keyIterator();

    public void put(int var1, V var2);

    public void remove(int var1);

    public void clear();

    public int size();

    public void grow(int var1);

    public static interface IConceptMapFactory {
        public IConceptMap<IConceptSet> createSparseConceptMap(int var1);

        public IConceptMap<IConceptSet> createDenseConceptMap(int var1);
    }
}

