/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.IConceptMap;
import au.csiro.snorocket.core.util.IntIterator;

public final class DuoConceptMap<V>
implements IConceptMap<V> {
    private static final long serialVersionUID = 1L;
    private final IConceptMap<V> base;
    private final IConceptMap<V> overlay;

    public DuoConceptMap(IConceptMap<V> base, IConceptMap<V> overlay) {
        this.base = base;
        this.overlay = overlay;
    }

    public IConceptMap<V> getOverlay() {
        return this.overlay;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(int key) {
        return this.overlay.containsKey(key) || this.base.containsKey(key);
    }

    @Override
    public V get(int key) {
        return this.base.containsKey(key) ? this.base.get(key) : this.overlay.get(key);
    }

    @Override
    public void grow(int newSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterator keyIterator() {
        return new IntIterator(){
            final IntIterator baseItr;
            final IntIterator overlayItr;
            {
                this.baseItr = DuoConceptMap.this.base.keyIterator();
                this.overlayItr = DuoConceptMap.this.overlay.keyIterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseItr.hasNext() || this.overlayItr.hasNext();
            }

            @Override
            public int next() {
                return this.baseItr.hasNext() ? this.baseItr.next() : this.overlayItr.next();
            }
        };
    }

    @Override
    public void put(int key, V value) {
        if (this.base.containsKey(key)) {
            throw new UnsupportedOperationException();
        }
        this.overlay.put(key, value);
    }

    @Override
    public void remove(int key) {
        if (this.base.containsKey(key)) {
            throw new UnsupportedOperationException();
        }
        this.overlay.remove(key);
    }

    @Override
    public int size() {
        return this.base.size() + this.overlay.size();
    }

    public String toString() {
        return this.overlay + " ==> " + this.base;
    }
}

