/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.model;

import au.csiro.snorocket.core.model.AbstractConcept;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;

public class Conjunction
extends AbstractConcept {
    private static final long serialVersionUID = 1L;
    private final AbstractConcept[] concepts;
    private final int hashCode;

    public Conjunction(AbstractConcept[] concepts) {
        TreeSet<AbstractConcept> sorted = new TreeSet<AbstractConcept>();
        for (AbstractConcept concept : concepts) {
            sorted.add(concept);
        }
        this.concepts = sorted.toArray(new AbstractConcept[sorted.size()]);
        this.hashCode = ((Object)sorted).hashCode();
    }

    public Conjunction(Collection<? extends AbstractConcept> concepts) {
        TreeSet<? extends AbstractConcept> sorted = new TreeSet<AbstractConcept>(concepts);
        this.concepts = sorted.toArray(new AbstractConcept[sorted.size()]);
        this.hashCode = ((Object)sorted).hashCode();
    }

    public AbstractConcept[] getConcepts() {
        return this.concepts;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (this.concepts != null && this.concepts.length > 0) {
            sb.append(this.concepts[0]);
            for (int i = 1; i < this.concepts.length; ++i) {
                sb.append(" + ");
                sb.append(this.concepts[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Conjunction other = (Conjunction)obj;
        return this.hashCode == other.hashCode && Arrays.equals(this.concepts, other.concepts);
    }

    @Override
    int compareToWhenHashCodesEqual(AbstractConcept other) {
        assert (this.hashCode() == other.hashCode());
        assert (other instanceof Conjunction);
        Conjunction otherConjunction = (Conjunction)other;
        int result = this.concepts.length - otherConjunction.concepts.length;
        for (int i = 0; 0 == result && i < this.concepts.length; ++i) {
            result = this.concepts[i].compareTo(otherConjunction.concepts[i]);
        }
        return result;
    }
}

