/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.concurrent;

import au.csiro.ontology.Node;
import au.csiro.ontology.model.NamedConcept;
import au.csiro.snorocket.core.IFactory;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class TaxonomyWorker2
implements Runnable {
    private final IFactory factory;
    private final Map<String, Node> conceptNodeIndex;
    private final ConcurrentMap<Integer, IConceptSet> direc;
    private final Queue<Node> todo;
    private final Set<Node> nodeSet;

    public TaxonomyWorker2(IFactory factory, Map<String, Node> conceptNodeIndex, ConcurrentMap<Integer, IConceptSet> direc, Queue<Node> todo, Set<Node> nodeSet) {
        this.factory = factory;
        this.conceptNodeIndex = conceptNodeIndex;
        this.direc = direc;
        this.todo = todo;
        this.nodeSet = nodeSet;
    }

    @Override
    public void run() {
        Node node;
        while ((node = this.todo.poll()) != null) {
            if (node.getEquivalentConcepts().contains(NamedConcept.BOTTOM)) continue;
            for (String c : node.getEquivalentConcepts()) {
                IConceptSet dc = (IConceptSet)this.direc.get(this.factory.getConcept(c));
                if (dc == null) continue;
                IntIterator it = dc.iterator();
                while (it.hasNext()) {
                    int d = it.next();
                    Node parent = this.conceptNodeIndex.get(this.factory.lookupConceptId(d));
                    if (parent == null) continue;
                    node.getParents().add(parent);
                    parent.getChildren().add(node);
                    this.nodeSet.remove(parent);
                }
            }
        }
    }
}

