/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.concurrent;

import au.csiro.ontology.model.Operator;
import au.csiro.snorocket.core.IFactory;
import au.csiro.snorocket.core.IQueue;
import au.csiro.snorocket.core.NormalisedOntology;
import au.csiro.snorocket.core.QueueImpl;
import au.csiro.snorocket.core.axioms.IConjunctionQueueEntry;
import au.csiro.snorocket.core.axioms.IFeatureQueueEntry;
import au.csiro.snorocket.core.axioms.IRoleQueueEntry;
import au.csiro.snorocket.core.axioms.NF2;
import au.csiro.snorocket.core.axioms.NF4;
import au.csiro.snorocket.core.axioms.NF5;
import au.csiro.snorocket.core.axioms.NF7;
import au.csiro.snorocket.core.axioms.NF8;
import au.csiro.snorocket.core.concurrent.CR;
import au.csiro.snorocket.core.model.AbstractLiteral;
import au.csiro.snorocket.core.model.Datatype;
import au.csiro.snorocket.core.util.FeatureMap;
import au.csiro.snorocket.core.util.IConceptMap;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IMonotonicCollection;
import au.csiro.snorocket.core.util.IntIterator;
import au.csiro.snorocket.core.util.MonotonicCollection;
import au.csiro.snorocket.core.util.RoleSet;
import au.csiro.snorocket.core.util.SparseConceptSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class Context
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int concept;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final Queue<IConjunctionQueueEntry> conceptQueue = new ConcurrentLinkedQueue<IConjunctionQueueEntry>();
    private final IQueue<IRoleQueueEntry> roleQueue = new QueueImpl<IRoleQueueEntry>(IRoleQueueEntry.class);
    private final IQueue<IFeatureQueueEntry> featureQueue = new QueueImpl<IFeatureQueueEntry>(IFeatureQueueEntry.class);
    private final Queue<IRoleQueueEntry> externalQueue = new ConcurrentLinkedQueue<IRoleQueueEntry>();
    private final IConceptSet s;
    private final CR pred;
    private final CR succ;
    private AtomicBoolean track = new AtomicBoolean(false);
    private boolean changed = false;
    private Queue<Context> parentTodo;
    private IConceptMap<Context> contextIndex;
    private Map<Integer, RoleSet> roleClosureCache;
    private IFactory factory;
    private IConceptMap<MonotonicCollection<IConjunctionQueueEntry>> ontologyNF1;
    private IConceptMap<MonotonicCollection<NF2>> ontologyNF2;
    private IConceptMap<ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>>> ontologyNF3;
    private IMonotonicCollection<NF4> ontologyNF4;
    private IMonotonicCollection<NF5> ontologyNF5;
    private IConceptSet reflexiveRoles = new SparseConceptSet();
    private IConceptMap<MonotonicCollection<NF7>> ontologyNF7;
    private FeatureMap<MonotonicCollection<NF8>> ontologyNF8;
    private Set<Context> affectedContexts;

    private void init(NormalisedOntology ont) {
        this.parentTodo = ont.getTodo();
        this.contextIndex = ont.getContextIndex();
        this.ontologyNF1 = ont.getOntologyNF1();
        this.ontologyNF2 = ont.getOntologyNF2();
        this.ontologyNF3 = ont.getOntologyNF3();
        this.ontologyNF4 = ont.getOntologyNF4();
        this.ontologyNF5 = ont.getOntologyNF5();
        this.reflexiveRoles = ont.getReflexiveRoles();
        this.ontologyNF7 = ont.getOntologyNF7();
        this.ontologyNF8 = ont.getOntologyNF8();
        this.roleClosureCache = ont.getRoleClosureCache();
        this.factory = ont.getFactory();
        this.affectedContexts = ont.getAffectedContexts();
    }

    public Context(int concept, NormalisedOntology ont) {
        this.init(ont);
        this.concept = concept;
        this.s = new SparseConceptSet();
        this.s.add(concept);
        this.s.add(0);
        this.pred = new CR(this.factory.getTotalRoles());
        this.succ = new CR(this.factory.getTotalRoles());
        this.primeQueue();
    }

    public int getConcept() {
        return this.concept;
    }

    private void addToConceptQueue(MonotonicCollection<IConjunctionQueueEntry> entries) {
        Iterator<IConjunctionQueueEntry> it = entries.iterator();
        while (it.hasNext()) {
            this.conceptQueue.add(it.next());
        }
    }

    private void primeQueue() {
        MonotonicCollection<NF7> nf7e;
        MonotonicCollection<NF2> nf2e;
        MonotonicCollection<IConjunctionQueueEntry> nf1e = this.ontologyNF1.get(this.concept);
        if (nf1e != null) {
            this.addToConceptQueue(nf1e);
        }
        if ((nf2e = this.ontologyNF2.get(this.concept)) != null) {
            this.roleQueue.addAll(nf2e);
        }
        if ((nf7e = this.ontologyNF7.get(this.concept)) != null) {
            this.featureQueue.addAll(nf7e);
        }
    }

    public void primeQueuesIncremental(MonotonicCollection<IConjunctionQueueEntry> conceptEntries, MonotonicCollection<IRoleQueueEntry> roleEntries, MonotonicCollection<IFeatureQueueEntry> featureEntries) {
        if (conceptEntries != null) {
            this.addToConceptQueue(conceptEntries);
        }
        if (roleEntries != null) {
            this.roleQueue.addAll(roleEntries);
        }
        if (featureEntries != null) {
            this.featureQueue.addAll(featureEntries);
        }
    }

    public IConceptSet getS() {
        return this.s;
    }

    public CR getPred() {
        return this.pred;
    }

    public CR getSucc() {
        return this.succ;
    }

    public boolean activate() {
        return this.active.compareAndSet(false, true);
    }

    public void deactivate() {
        this.active.set(false);
        if (!(this.conceptQueue.isEmpty() && this.roleQueue.isEmpty() && this.featureQueue.isEmpty() || !this.activate())) {
            this.parentTodo.add(this);
        }
    }

    public void addConceptQueueEntry(IConjunctionQueueEntry entry) {
        this.conceptQueue.add(entry);
    }

    public void addConceptQueueEntries(Collection<IConjunctionQueueEntry> entries) {
        this.conceptQueue.addAll(entries);
    }

    public void addRoleQueueEntry(IRoleQueueEntry entry) {
        this.roleQueue.add(entry);
    }

    public void addFeatureQueueEntry(IFeatureQueueEntry entry) {
        this.featureQueue.add(entry);
    }

    public void processExternalEdge(final int role, final int src) {
        this.externalQueue.add(new IRoleQueueEntry(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getR() {
                return role;
            }

            @Override
            public int getB() {
                return src;
            }
        });
    }

    public void processOntology() {
        if (this.track.get()) {
            this.processOntologyTracking();
        } else {
            this.processOntologyInternal();
        }
        this.deactivate();
    }

    private void processOntologyInternal() {
        boolean done;
        do {
            Serializable entry;
            done = true;
            if (!this.conceptQueue.isEmpty()) {
                do {
                    int bi;
                    done = false;
                    entry = this.conceptQueue.remove();
                    int b = entry.getB();
                    if (this.s.contains(b) || !this.s.contains(bi = entry.getBi())) continue;
                    this.s.add(b);
                    this.processNewSubsumption(b);
                } while (!this.conceptQueue.isEmpty());
            }
            if (!this.featureQueue.isEmpty()) {
                do {
                    done = false;
                    entry = this.featureQueue.remove();
                    Datatype d = entry.getD();
                    MonotonicCollection<NF8> entries = this.ontologyNF8.get(d.getFeature());
                    if (entries == null) continue;
                    MonotonicCollection<IConjunctionQueueEntry> res = new MonotonicCollection<IConjunctionQueueEntry>(2);
                    for (final NF8 e : entries) {
                        Datatype d2 = e.lhsD;
                        if (!this.datatypeMatches(d, d2)) continue;
                        res.add(new IConjunctionQueueEntry(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public int getBi() {
                                return 0;
                            }

                            @Override
                            public int getB() {
                                return e.rhsB;
                            }
                        });
                    }
                    this.addToConceptQueue(res);
                } while (!this.featureQueue.isEmpty());
            }
            if (!this.roleQueue.isEmpty()) {
                done = false;
                entry = this.roleQueue.remove();
                if (!this.succ.lookupConcept(entry.getR()).contains(entry.getB())) {
                    this.processNewEdge(entry.getR(), entry.getB());
                }
            }
            if (this.externalQueue.isEmpty()) continue;
            done = false;
            entry = this.externalQueue.remove();
            this.processNewEdge(entry.getR(), entry.getB());
        } while (!done);
    }

    private void processNewSubsumption(int b) {
        MonotonicCollection<NF7> nf7Entries;
        ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>> map;
        MonotonicCollection<NF2> bRoleEntries;
        MonotonicCollection<IConjunctionQueueEntry> bConceptEntries = this.ontologyNF1.get(b);
        if (null != bConceptEntries && bConceptEntries.size() > 0) {
            this.addToConceptQueue(bConceptEntries);
        }
        if (null != (bRoleEntries = this.ontologyNF2.get(b))) {
            this.roleQueue.addAll(bRoleEntries);
        }
        if (null != (map = this.ontologyNF3.get(b))) {
            Set keySet = map.keySet();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                int r = (Integer)iterator.next();
                Collection entries = (Collection)map.get(r);
                if (null == entries) continue;
                IConceptSet aPrimes = this.pred.lookupConcept(r);
                IntIterator itr = aPrimes.iterator();
                while (itr.hasNext()) {
                    int aa = itr.next();
                    if (this.concept == aa) {
                        this.conceptQueue.addAll(entries);
                        continue;
                    }
                    Context oc = this.contextIndex.get(aa);
                    oc.addConceptQueueEntries(entries);
                    if (!oc.activate()) continue;
                    this.parentTodo.add(oc);
                }
            }
        }
        if (null != (nf7Entries = this.ontologyNF7.get(b)) && nf7Entries.size() > 0) {
            this.featureQueue.addAll(nf7Entries);
        }
    }

    private boolean datatypeMatches(Datatype d1, Datatype d2) {
        assert (d1.getFeature() == d2.getFeature());
        AbstractLiteral lhsLit = d1.getLiteral();
        AbstractLiteral rhsLit = d2.getLiteral();
        Operator lhsOp = d1.getOperator();
        Operator rhsOp = d2.getOperator();
        if (rhsOp == Operator.EQUALS) {
            if (lhsOp != Operator.EQUALS) {
                return false;
            }
            return d1.getLiteral().equals(d2.getLiteral());
        }
        if (rhsOp == Operator.GREATER_THAN) {
            if (lhsOp == Operator.LESS_THAN || lhsOp == Operator.LESS_THAN_EQUALS) {
                return false;
            }
            if (lhsOp == Operator.EQUALS) {
                return this.compareLiterals(lhsLit, rhsLit) > 0;
            }
            if (lhsOp == Operator.GREATER_THAN) {
                return this.compareLiterals(lhsLit, rhsLit) >= 0;
            }
            if (lhsOp == Operator.GREATER_THAN_EQUALS) {
                return this.compareLiterals(lhsLit, rhsLit) > 0;
            }
        } else if (rhsOp == Operator.GREATER_THAN_EQUALS) {
            if (lhsOp == Operator.LESS_THAN || lhsOp == Operator.LESS_THAN_EQUALS) {
                return false;
            }
            if (lhsOp == Operator.EQUALS) {
                return this.compareLiterals(lhsLit, rhsLit) >= 0;
            }
            if (lhsOp == Operator.GREATER_THAN) {
                return this.compareLiterals(lhsLit, rhsLit) >= -1;
            }
            if (lhsOp == Operator.GREATER_THAN_EQUALS) {
                return this.compareLiterals(lhsLit, rhsLit) >= 0;
            }
        } else if (rhsOp == Operator.LESS_THAN) {
            if (lhsOp == Operator.GREATER_THAN || lhsOp == Operator.GREATER_THAN_EQUALS) {
                return false;
            }
            if (lhsOp == Operator.EQUALS) {
                return this.compareLiterals(lhsLit, rhsLit) < 0;
            }
            if (lhsOp == Operator.LESS_THAN) {
                return this.compareLiterals(lhsLit, rhsLit) <= 0;
            }
            if (lhsOp == Operator.LESS_THAN_EQUALS) {
                return this.compareLiterals(lhsLit, rhsLit) < 0;
            }
        } else if (rhsOp == Operator.LESS_THAN_EQUALS) {
            if (lhsOp == Operator.GREATER_THAN || lhsOp == Operator.GREATER_THAN_EQUALS) {
                return false;
            }
            if (lhsOp == Operator.EQUALS) {
                return this.compareLiterals(lhsLit, rhsLit) <= 0;
            }
            if (lhsOp == Operator.LESS_THAN) {
                return this.compareLiterals(lhsLit, rhsLit) <= 1;
            }
            if (lhsOp == Operator.LESS_THAN_EQUALS) {
                return this.compareLiterals(lhsLit, rhsLit) <= 0;
            }
        }
        return d1.getLiteral().equals(d2.getLiteral());
    }

    private int compareLiterals(AbstractLiteral l1, AbstractLiteral l2) {
        return l1.compareTo(l2);
    }

    private void processNewEdge(int role, int b) {
        RoleSet roleClosure = this.getRoleClosure(role);
        this.processRole(role, b);
        int s = roleClosure.first();
        while (s >= 0) {
            if (s != role) {
                this.processRole(s, b);
            }
            s = roleClosure.next(s + 1);
        }
    }

    private void processRole(int s, int b) {
        IntIterator itr;
        int u;
        this.succ.store(s, b);
        Context bContext = this.contextIndex.get(b);
        bContext.getPred().store(s, this.concept);
        IConceptSet sb = this.contextIndex.get(b).getS();
        IntIterator itr2 = sb.iterator();
        while (itr2.hasNext()) {
            Collection entries;
            int bb = itr2.next();
            ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>> map = this.ontologyNF3.get(bb);
            if (null == map || null == (entries = (Collection)map.get(s))) continue;
            this.conceptQueue.addAll(entries);
        }
        if (this.reflexiveRoles.contains(s)) {
            Context tc;
            if (!this.pred.lookupConcept(s).contains(this.concept)) {
                this.processNewEdge(s, this.concept);
            }
            if (!(tc = this.contextIndex.get(b)).getPred().lookupConcept(s).contains(b)) {
                tc.processExternalEdge(s, b);
                if (tc.activate()) {
                    this.parentTodo.add(tc);
                }
            }
        }
        ArrayList<int[]> work = new ArrayList<int[]>();
        for (NF5 nf5 : this.ontologyNF5) {
            if (s != nf5.getS()) continue;
            int t = nf5.getR();
            u = nf5.getT();
            IConceptSet aTPrimes = this.pred.lookupConcept(t);
            IConceptSet bUPrimes = this.contextIndex.get(b).getPred().lookupConcept(u);
            itr = aTPrimes.iterator();
            while (itr.hasNext()) {
                int aa = itr.next();
                if (bUPrimes.contains(aa)) continue;
                work.add(new int[]{aa, u});
            }
        }
        for (int[] pair : work) {
            if (pair[0] == this.concept) {
                this.processNewEdge(pair[1], b);
                continue;
            }
            Context tc = this.contextIndex.get(pair[0]);
            tc.processExternalEdge(pair[1], b);
            if (!tc.activate()) continue;
            this.parentTodo.add(tc);
        }
        work.clear();
        for (NF5 nf5 : this.ontologyNF5) {
            if (s != nf5.getR()) continue;
            int t = nf5.getS();
            u = nf5.getT();
            IConceptSet bTPrimes = this.contextIndex.get(b).getSucc().lookupConcept(t);
            IConceptSet aUPrimes = this.succ.lookupConcept(u);
            itr = bTPrimes.iterator();
            while (itr.hasNext()) {
                int bb = itr.next();
                if (aUPrimes.contains(bb)) continue;
                work.add(new int[]{u, bb});
            }
        }
        for (int[] pair : work) {
            this.processNewEdge(pair[0], pair[1]);
        }
    }

    private RoleSet getRoleClosure(int r) {
        RoleSet result = this.roleClosureCache.get(r);
        if (null == result) {
            result = new RoleSet();
            result.add(r);
            for (NF4 nf4 : this.ontologyNF4) {
                if (r != nf4.getR()) continue;
                result.addAll(this.getRoleClosure(nf4.getS()));
            }
            this.roleClosureCache.put(r, result);
        }
        return result;
    }

    public void startTracking() {
        if (this.track.compareAndSet(false, true)) {
            this.changed = false;
        }
    }

    public void endTracking() {
        this.track.set(false);
    }

    public boolean hasNewSubsumptions() {
        return this.changed;
    }

    private void processOntologyTracking() {
        boolean done;
        do {
            Serializable entry;
            done = true;
            if (!this.conceptQueue.isEmpty()) {
                do {
                    int bi;
                    done = false;
                    entry = this.conceptQueue.remove();
                    int b = entry.getB();
                    if (this.s.contains(b) || !this.s.contains(bi = entry.getBi())) continue;
                    this.s.add(b);
                    this.changed = true;
                    this.processNewSubsumptionTracking(b);
                } while (!this.conceptQueue.isEmpty());
            }
            if (!this.featureQueue.isEmpty()) {
                do {
                    done = false;
                    entry = this.featureQueue.remove();
                    Datatype d = entry.getD();
                    MonotonicCollection<NF8> entries = this.ontologyNF8.get(d.getFeature());
                    if (entries == null) continue;
                    MonotonicCollection<IConjunctionQueueEntry> res = new MonotonicCollection<IConjunctionQueueEntry>(2);
                    for (final NF8 e : entries) {
                        Datatype d2 = e.lhsD;
                        if (!this.datatypeMatches(d, d2)) continue;
                        res.add(new IConjunctionQueueEntry(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public int getBi() {
                                return 0;
                            }

                            @Override
                            public int getB() {
                                return e.rhsB;
                            }
                        });
                    }
                    this.addToConceptQueue(res);
                } while (!this.featureQueue.isEmpty());
            }
            if (!this.roleQueue.isEmpty()) {
                done = false;
                entry = this.roleQueue.remove();
                if (!this.succ.lookupConcept(entry.getR()).contains(entry.getB())) {
                    this.processNewEdgeTracking(entry.getR(), entry.getB());
                }
            }
            if (this.externalQueue.isEmpty()) continue;
            done = false;
            entry = this.externalQueue.remove();
            this.processNewEdgeTracking(entry.getR(), entry.getB());
        } while (!done);
    }

    private void processNewSubsumptionTracking(int b) {
        MonotonicCollection<NF7> nf7Entries;
        ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>> map;
        MonotonicCollection<NF2> bRoleEntries;
        MonotonicCollection<IConjunctionQueueEntry> bConceptEntries = this.ontologyNF1.get(b);
        if (null != bConceptEntries && bConceptEntries.size() > 0) {
            this.addToConceptQueue(bConceptEntries);
        }
        if (null != (bRoleEntries = this.ontologyNF2.get(b))) {
            this.roleQueue.addAll(bRoleEntries);
        }
        if (null != (map = this.ontologyNF3.get(b))) {
            Set keySet = map.keySet();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                int r = (Integer)iterator.next();
                Collection entries = (Collection)map.get(r);
                if (null == entries) continue;
                IConceptSet aPrimes = this.pred.lookupConcept(r);
                IntIterator itr = aPrimes.iterator();
                while (itr.hasNext()) {
                    int aa = itr.next();
                    if (this.concept == aa) {
                        this.conceptQueue.addAll(entries);
                        continue;
                    }
                    Context oc = this.contextIndex.get(aa);
                    oc.addConceptQueueEntries(entries);
                    this.affectedContexts.add(oc);
                    oc.startTracking();
                    if (!oc.activate()) continue;
                    this.parentTodo.add(oc);
                }
            }
        }
        if (null != (nf7Entries = this.ontologyNF7.get(b)) && nf7Entries.size() > 0) {
            this.featureQueue.addAll(nf7Entries);
        }
    }

    private void processNewEdgeTracking(int role, int b) {
        RoleSet roleClosure = this.getRoleClosure(role);
        this.processRoleTracking(role, b);
        int s = roleClosure.first();
        while (s >= 0) {
            if (s != role) {
                this.processRoleTracking(s, b);
            }
            s = roleClosure.next(s + 1);
        }
    }

    private void processRoleTracking(int s, int b) {
        IntIterator itr;
        int u;
        this.succ.store(s, b);
        Context bContext = this.contextIndex.get(b);
        bContext.getPred().store(s, this.concept);
        IConceptSet sb = this.contextIndex.get(b).getS();
        IntIterator itr2 = sb.iterator();
        while (itr2.hasNext()) {
            Collection entries;
            int bb = itr2.next();
            ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>> map = this.ontologyNF3.get(bb);
            if (null == map || null == (entries = (Collection)map.get(s))) continue;
            this.conceptQueue.addAll(entries);
        }
        if (this.reflexiveRoles.contains(s)) {
            Context tc;
            if (!this.pred.lookupConcept(s).contains(this.concept)) {
                this.processNewEdgeTracking(s, this.concept);
            }
            if (!(tc = this.contextIndex.get(b)).getPred().lookupConcept(s).contains(b)) {
                tc.processExternalEdge(s, b);
                this.affectedContexts.add(tc);
                tc.startTracking();
                if (tc.activate()) {
                    this.parentTodo.add(tc);
                }
            }
        }
        ArrayList<int[]> work = new ArrayList<int[]>();
        for (NF5 nf5 : this.ontologyNF5) {
            if (s != nf5.getS()) continue;
            int t = nf5.getR();
            u = nf5.getT();
            IConceptSet aTPrimes = this.pred.lookupConcept(t);
            IConceptSet bUPrimes = this.contextIndex.get(b).getPred().lookupConcept(u);
            itr = aTPrimes.iterator();
            while (itr.hasNext()) {
                int aa = itr.next();
                if (bUPrimes.contains(aa)) continue;
                work.add(new int[]{aa, u});
            }
        }
        for (int[] pair : work) {
            if (pair[0] == this.concept) {
                this.processNewEdgeTracking(pair[1], b);
                continue;
            }
            Context tc = this.contextIndex.get(pair[0]);
            tc.processExternalEdge(pair[1], b);
            this.affectedContexts.add(tc);
            tc.startTracking();
            if (!tc.activate()) continue;
            this.parentTodo.add(tc);
        }
        work.clear();
        for (NF5 nf5 : this.ontologyNF5) {
            if (s != nf5.getR()) continue;
            int t = nf5.getS();
            u = nf5.getT();
            IConceptSet bTPrimes = this.contextIndex.get(b).getSucc().lookupConcept(t);
            IConceptSet aUPrimes = this.succ.lookupConcept(u);
            itr = bTPrimes.iterator();
            while (itr.hasNext()) {
                int bb = itr.next();
                if (aUPrimes.contains(bb)) continue;
                work.add(new int[]{u, bb});
            }
        }
        for (int[] pair : work) {
            this.processNewEdgeTracking(pair[0], pair[1]);
        }
    }
}

