/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.axioms;

import au.csiro.snorocket.core.IFactory;
import au.csiro.snorocket.core.axioms.Inclusion;
import au.csiro.snorocket.core.axioms.NF1a;
import au.csiro.snorocket.core.axioms.NF1b;
import au.csiro.snorocket.core.axioms.NF2;
import au.csiro.snorocket.core.axioms.NF3;
import au.csiro.snorocket.core.axioms.NF7;
import au.csiro.snorocket.core.axioms.NF8;
import au.csiro.snorocket.core.axioms.NormalFormGCI;
import au.csiro.snorocket.core.model.AbstractConcept;
import au.csiro.snorocket.core.model.Concept;
import au.csiro.snorocket.core.model.Conjunction;
import au.csiro.snorocket.core.model.Datatype;
import au.csiro.snorocket.core.model.Existential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCI
extends Inclusion {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(GCI.class);
    private static final int PRIME = 31;
    private final AbstractConcept lhs;
    private final AbstractConcept rhs;
    private final int hashCode;

    public GCI(AbstractConcept lhs, AbstractConcept rhs) {
        if (null == lhs) {
            throw new IllegalArgumentException("LHS cannot be null (RHS = " + rhs + ")");
        }
        this.lhs = lhs;
        this.rhs = null == rhs ? new Concept(0) : rhs;
        this.hashCode = 31 * (31 + this.lhs.hashCode()) + this.rhs.hashCode();
    }

    public GCI(int lhs, AbstractConcept rhs) {
        this((AbstractConcept)new Concept(lhs), rhs);
    }

    public GCI(AbstractConcept lhs, int rhs) {
        this(lhs, (AbstractConcept)new Concept(rhs));
    }

    public GCI(int lhs, int rhs) {
        this((AbstractConcept)new Concept(lhs), (AbstractConcept)new Concept(rhs));
    }

    public AbstractConcept lhs() {
        return this.lhs;
    }

    public AbstractConcept rhs() {
        return this.rhs;
    }

    @Override
    public Inclusion[] normalise1(IFactory factory) {
        Inclusion[] result = new Inclusion[]{null, null};
        if (this.rule2(factory, result) || this.rule3(factory, result) || this.rule4(result)) {
            return result;
        }
        return null;
    }

    @Override
    public Inclusion[] normalise2(IFactory factory) {
        Inclusion[] result = new Inclusion[]{null, null, null, null, null, null, null, null};
        if (this.isRule7Applicable()) {
            return this.rule7(result);
        }
        if (this.rule6(factory, result) || this.rule5(factory, result)) {
            return result;
        }
        return null;
    }

    boolean rule2(IFactory factory, Inclusion[] gcis) {
        boolean result = false;
        if (this.lhs instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)this.lhs;
            AbstractConcept[] concepts = conjunction.getConcepts();
            if (concepts.length == 1) {
                gcis[0] = new GCI(concepts[0], this.rhs);
                result = true;
            } else if (concepts.length == 0) {
                log.warn("Empty conjunct detected in: " + this);
                gcis[0] = new GCI(0, this.rhs);
                result = true;
            } else {
                for (int i = 0; !result && i < concepts.length; ++i) {
                    if (concepts[i] instanceof Concept) continue;
                    Concept a = this.getA(factory, concepts[i]);
                    gcis[0] = new GCI(concepts[i], (AbstractConcept)a);
                    AbstractConcept[] newConcepts = new AbstractConcept[concepts.length];
                    System.arraycopy(concepts, 0, newConcepts, 0, concepts.length);
                    newConcepts[i] = a;
                    gcis[1] = new GCI((AbstractConcept)new Conjunction(newConcepts), this.rhs);
                    result = true;
                }
                if (!result) {
                    if (concepts.length > 2) {
                        result = true;
                        AbstractConcept[] newConcepts = new AbstractConcept[concepts.length - 1];
                        System.arraycopy(concepts, 1, newConcepts, 0, concepts.length - 1);
                        Conjunction d = new Conjunction(newConcepts);
                        Concept a = this.getA(factory, d);
                        Conjunction cAndA = new Conjunction(new AbstractConcept[]{concepts[0], a});
                        gcis[0] = new GCI((AbstractConcept)cAndA, this.rhs);
                        gcis[1] = new GCI((AbstractConcept)d, (AbstractConcept)a);
                    } else if (concepts.length < 2) {
                        throw new AssertionError((Object)("Conjunctions of fewer than two elements should not exist at this point: " + this));
                    }
                }
            }
        }
        return result;
    }

    boolean rule3(IFactory factory, Inclusion[] gcis) {
        Existential existential;
        AbstractConcept cHat;
        boolean result = false;
        if (this.lhs instanceof Existential && !((cHat = (existential = (Existential)this.lhs).getConcept()) instanceof Concept)) {
            result = true;
            Concept a = this.getA(factory, cHat);
            gcis[0] = new GCI(cHat, (AbstractConcept)a);
            gcis[1] = new GCI((AbstractConcept)new Existential(existential.getRole(), a), this.rhs);
        }
        return result;
    }

    boolean rule4(Inclusion[] gcis) {
        boolean result = false;
        return result;
    }

    boolean rule5(IFactory factory, Inclusion[] gcis) {
        boolean result = false;
        if (!(this.lhs instanceof Concept) && !(this.rhs instanceof Concept)) {
            result = true;
            Concept a = this.getA(factory, this.lhs);
            gcis[0] = new GCI(this.lhs, (AbstractConcept)a);
            gcis[1] = new GCI((AbstractConcept)a, this.rhs);
        }
        return result;
    }

    boolean rule6(IFactory factory, Inclusion[] gcis) {
        Existential existential;
        AbstractConcept cHat;
        boolean result = false;
        if (this.rhs instanceof Existential && !((cHat = (existential = (Existential)this.rhs).getConcept()) instanceof Concept)) {
            result = true;
            Concept a = this.getA(factory, cHat);
            gcis[0] = new GCI(this.lhs, (AbstractConcept)new Existential(existential.getRole(), a));
            gcis[1] = new GCI((AbstractConcept)a, cHat);
        }
        return result;
    }

    private Concept getA(IFactory factory, AbstractConcept cHat) {
        boolean alreadyExists = factory.conceptExists(cHat);
        int a = factory.getConcept(cHat);
        if (!alreadyExists) {
            factory.setVirtualConcept(a, true);
        }
        return new Concept(a);
    }

    boolean isRule7Applicable() {
        return this.rhs instanceof Conjunction;
    }

    Inclusion[] rule7(Inclusion[] gcis) {
        assert (this.isRule7Applicable());
        Conjunction conjunction = (Conjunction)this.rhs;
        AbstractConcept[] concepts = conjunction.getConcepts();
        if (concepts.length > gcis.length) {
            gcis = new Inclusion[concepts.length];
        }
        for (int i = 0; i < concepts.length; ++i) {
            gcis[i] = new GCI(this.lhs, concepts[i]);
        }
        return gcis;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GCI other = (GCI)obj;
        if (!this.lhs.equals(other.lhs)) {
            return false;
        }
        return this.rhs.equals(other.rhs);
    }

    @Override
    public String toString() {
        return this.lhs.toString() + " [ " + this.rhs.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NormalFormGCI getNormalForm() {
        void var1_15;
        if (this.lhs instanceof Concept) {
            if (this.rhs instanceof Concept) {
                int newLhs = this.lhs.hashCode();
                NF1a nF1a = NF1a.getInstance(newLhs, this.rhs.hashCode());
                return var1_15;
            } else if (this.rhs instanceof Existential) {
                Existential existential = (Existential)this.rhs;
                NF2 nF2 = NF2.getInstance(this.lhs.hashCode(), existential.getRole(), existential.getConcept().hashCode());
                return var1_15;
            } else {
                if (!(this.rhs instanceof Datatype)) throw new IllegalStateException("GCI is not in Normal Form: lhs is Concept but rhs is neither Concept, Existential nor Datatype; it is " + this.rhs);
                Datatype datatype = (Datatype)this.rhs;
                NF7 nF7 = NF7.getInstance(this.lhs.hashCode(), datatype);
            }
            return var1_15;
        } else if (this.lhs instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)this.lhs;
            AbstractConcept[] concepts = conjunction.getConcepts();
            if (concepts.length == 1) {
                NF1a nF1a = NF1a.getInstance(concepts[0].hashCode(), this.rhs.hashCode());
                return var1_15;
            } else {
                if (concepts.length != 2) throw new IllegalStateException("Conjunction should have exactly one or two concepts not " + concepts.length + ": " + conjunction);
                NF1b nF1b = NF1b.getInstance(concepts[0].hashCode(), concepts[1].hashCode(), this.rhs.hashCode());
            }
            return var1_15;
        } else if (this.lhs instanceof Existential) {
            Existential existential = (Existential)this.lhs;
            NF3 nF3 = NF3.getInstance(existential.getRole(), existential.getConcept().hashCode(), this.rhs.hashCode());
            return var1_15;
        } else {
            if (!(this.lhs instanceof Datatype)) throw new IllegalStateException("GCI is not in Normal Form: " + this.lhs + ", " + this.rhs);
            Datatype datatype = (Datatype)this.lhs;
            NF8 nF8 = NF8.getInstance(datatype, this.rhs.hashCode());
        }
        return var1_15;
    }
}

