/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core;

import au.csiro.snorocket.core.util.DenseConceptMap;
import au.csiro.snorocket.core.util.IConceptMap;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import au.csiro.snorocket.core.util.SparseConceptSet;

final class S {
    private IConceptMap<IConceptSet> set;
    private int size = 0;

    S(int capacity) {
        this.set = new DenseConceptMap<IConceptSet>(capacity);
        for (int i = 0; i < capacity; ++i) {
            SparseConceptSet subsumes = new SparseConceptSet();
            subsumes.add(i);
            subsumes.add(0);
            this.set.put(i, subsumes);
        }
        this.size = capacity;
    }

    IConceptMap<IConceptSet> getSet() {
        return this.set;
    }

    IConceptSet get(int concept) {
        IConceptSet subsumes = this.set.get(concept);
        if (null == subsumes) {
            subsumes = new SparseConceptSet();
            subsumes.add(concept);
            subsumes.add(0);
            this.set.put(concept, subsumes);
            ++this.size;
        }
        return subsumes;
    }

    boolean containsKey(int concept) {
        return this.set.containsKey(concept);
    }

    IntIterator keyIterator() {
        return new IntIterator(){
            final IntIterator setitr;
            {
                this.setitr = S.this.set.keyIterator();
            }

            @Override
            public boolean hasNext() {
                return this.setitr.hasNext();
            }

            @Override
            public int next() {
                return this.setitr.next();
            }
        };
    }

    int keyCount() {
        return this.size;
    }

    void put(int child, int parent) {
        IConceptSet subsumes = this.set.get(child);
        if (null == subsumes) {
            subsumes = new SparseConceptSet();
            this.set.put(child, subsumes);
            ++this.size;
            subsumes.add(child);
            subsumes.add(0);
        }
        subsumes.add(parent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        IntIterator itr = this.keyIterator();
        while (itr.hasNext()) {
            int key = itr.next();
            sb.append(key);
            sb.append(": ");
            sb.append(this.get(key));
            if (!itr.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    void grow(int newSize) {
        this.set.grow(newSize);
    }
}

