/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core;

import au.csiro.ontology.Node;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.ConceptInclusion;
import au.csiro.ontology.model.Feature;
import au.csiro.ontology.model.FloatLiteral;
import au.csiro.ontology.model.Literal;
import au.csiro.ontology.model.NamedConcept;
import au.csiro.ontology.model.NamedFeature;
import au.csiro.ontology.model.NamedRole;
import au.csiro.ontology.model.Role;
import au.csiro.ontology.model.RoleInclusion;
import au.csiro.ontology.util.Statistics;
import au.csiro.snorocket.core.IFactory;
import au.csiro.snorocket.core.R;
import au.csiro.snorocket.core.axioms.GCI;
import au.csiro.snorocket.core.axioms.IConjunctionQueueEntry;
import au.csiro.snorocket.core.axioms.IRoleQueueEntry;
import au.csiro.snorocket.core.axioms.Inclusion;
import au.csiro.snorocket.core.axioms.NF1a;
import au.csiro.snorocket.core.axioms.NF1b;
import au.csiro.snorocket.core.axioms.NF2;
import au.csiro.snorocket.core.axioms.NF3;
import au.csiro.snorocket.core.axioms.NF4;
import au.csiro.snorocket.core.axioms.NF5;
import au.csiro.snorocket.core.axioms.NF6;
import au.csiro.snorocket.core.axioms.NF7;
import au.csiro.snorocket.core.axioms.NF8;
import au.csiro.snorocket.core.axioms.NormalFormGCI;
import au.csiro.snorocket.core.axioms.RI;
import au.csiro.snorocket.core.concurrent.CR;
import au.csiro.snorocket.core.concurrent.Context;
import au.csiro.snorocket.core.concurrent.TaxonomyWorker1;
import au.csiro.snorocket.core.concurrent.TaxonomyWorker2;
import au.csiro.snorocket.core.concurrent.Worker;
import au.csiro.snorocket.core.model.AbstractConcept;
import au.csiro.snorocket.core.model.AbstractLiteral;
import au.csiro.snorocket.core.model.Concept;
import au.csiro.snorocket.core.model.Conjunction;
import au.csiro.snorocket.core.model.Datatype;
import au.csiro.snorocket.core.model.DateLiteral;
import au.csiro.snorocket.core.model.DecimalLiteral;
import au.csiro.snorocket.core.model.Existential;
import au.csiro.snorocket.core.model.IntegerLiteral;
import au.csiro.snorocket.core.model.StringLiteral;
import au.csiro.snorocket.core.util.AxiomSet;
import au.csiro.snorocket.core.util.DenseConceptMap;
import au.csiro.snorocket.core.util.FastConceptHashSet;
import au.csiro.snorocket.core.util.FastConceptMap;
import au.csiro.snorocket.core.util.FeatureMap;
import au.csiro.snorocket.core.util.FeatureSet;
import au.csiro.snorocket.core.util.IConceptMap;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IMonotonicCollection;
import au.csiro.snorocket.core.util.IntIterator;
import au.csiro.snorocket.core.util.MonotonicCollection;
import au.csiro.snorocket.core.util.RoleSet;
import au.csiro.snorocket.core.util.SparseConceptHashSet;
import au.csiro.snorocket.core.util.SparseConceptMap;
import au.csiro.snorocket.core.util.SparseConceptSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalisedOntology
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(NormalisedOntology.class);
    protected final IFactory factory;
    protected final IConceptMap<MonotonicCollection<IConjunctionQueueEntry>> ontologyNF1;
    protected final IConceptMap<MonotonicCollection<NF2>> ontologyNF2;
    protected final IConceptMap<ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>>> ontologyNF3;
    protected final IMonotonicCollection<NF4> ontologyNF4;
    protected final IMonotonicCollection<NF5> ontologyNF5;
    protected final IConceptSet reflexiveRoles = new SparseConceptSet();
    protected final IConceptMap<MonotonicCollection<NF7>> ontologyNF7;
    protected final FeatureMap<MonotonicCollection<NF8>> ontologyNF8;
    private final Queue<Context> todo = new ConcurrentLinkedQueue<Context>();
    private final IConceptMap<Context> contextIndex;
    private final Map<Integer, RoleSet> roleClosureCache;
    private final Set<Context> newContexts = new HashSet<Context>();
    private int numThreads = Runtime.getRuntime().availableProcessors();
    private boolean hasBeenIncrementallyClassified = false;
    private transient Map<String, Node> conceptNodeIndex;
    private final Set<Context> affectedContexts = new ConcurrentSkipListSet<Context>(new ContextComparator());
    private AxiomSet as = new AxiomSet();
    static final int CONCEPT_COUNT_ESTIMATE = 500000;

    public IConceptMap<MonotonicCollection<IConjunctionQueueEntry>> getOntologyNF1() {
        return this.ontologyNF1;
    }

    public IConceptMap<MonotonicCollection<NF2>> getOntologyNF2() {
        return this.ontologyNF2;
    }

    public IConceptMap<ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>>> getOntologyNF3() {
        return this.ontologyNF3;
    }

    public IMonotonicCollection<NF4> getOntologyNF4() {
        return this.ontologyNF4;
    }

    public IMonotonicCollection<NF5> getOntologyNF5() {
        return this.ontologyNF5;
    }

    public IConceptSet getReflexiveRoles() {
        return this.reflexiveRoles;
    }

    public IConceptMap<MonotonicCollection<NF7>> getOntologyNF7() {
        return this.ontologyNF7;
    }

    public FeatureMap<MonotonicCollection<NF8>> getOntologyNF8() {
        return this.ontologyNF8;
    }

    public Queue<Context> getTodo() {
        return this.todo;
    }

    public IConceptMap<Context> getContextIndex() {
        return this.contextIndex;
    }

    public Map<Integer, RoleSet> getRoleClosureCache() {
        return this.roleClosureCache;
    }

    public Set<Context> getAffectedContexts() {
        return this.affectedContexts;
    }

    public NormalisedOntology(IFactory factory, Set<? extends Axiom> inclusions) {
        this(factory);
        this.loadAxioms(inclusions);
        if (log.isTraceEnabled()) {
            this.printNormalisedAxioms();
        }
    }

    public NormalisedOntology(IFactory factory) {
        this(factory, new DenseConceptMap<MonotonicCollection<IConjunctionQueueEntry>>(500000), new SparseConceptMap<MonotonicCollection<NF2>>(500000, "ontologyNF2"), new SparseConceptMap<ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>>>(500000, "ontologyNF3"), new MonotonicCollection<NF4>(15), new MonotonicCollection<NF5>(1), new SparseConceptMap<MonotonicCollection<NF7>>(10, "ontologyNF7"), new FeatureMap<MonotonicCollection<NF8>>(10));
    }

    protected NormalisedOntology(IFactory factory, IConceptMap<MonotonicCollection<IConjunctionQueueEntry>> nf1q, IConceptMap<MonotonicCollection<NF2>> nf2q, IConceptMap<ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>>> nf3q, IMonotonicCollection<NF4> nf4q, IMonotonicCollection<NF5> nf5q, IConceptMap<MonotonicCollection<NF7>> nf7q, FeatureMap<MonotonicCollection<NF8>> nf8q) {
        this.factory = factory;
        this.contextIndex = new FastConceptMap<Context>(factory.getTotalConcepts(), "");
        this.roleClosureCache = new ConcurrentHashMap<Integer, RoleSet>(factory.getTotalRoles());
        this.ontologyNF1 = nf1q;
        this.ontologyNF2 = nf2q;
        this.ontologyNF3 = nf3q;
        this.ontologyNF4 = nf4q;
        this.ontologyNF5 = nf5q;
        this.ontologyNF7 = nf7q;
        this.ontologyNF8 = nf8q;
    }

    public void loadAxioms(Set<? extends Axiom> inclusions) {
        long start = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("Loading " + inclusions.size() + " axioms");
        }
        Set<Inclusion> normInclusions = this.normalise(inclusions);
        if (log.isInfoEnabled()) {
            log.info("Processing " + normInclusions.size() + " normalised axioms");
        }
        Statistics.INSTANCE.setTime("normalisation", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        for (Inclusion i : normInclusions) {
            this.addTerm(i.getNormalForm());
        }
        Statistics.INSTANCE.setTime("indexing", System.currentTimeMillis() - start);
    }

    public void prapareForInferred() {
        log.info("Adding additional axioms to calculate inferred axioms");
        int key = 0;
        int numNf3 = 0;
        int numNf8 = 0;
        Object itr = this.ontologyNF2.keyIterator();
        while (itr.hasNext()) {
            MonotonicCollection<NF2> nf2s = this.ontologyNF2.get(itr.next());
            for (NF2 nf2 : nf2s) {
                if (this.factory.lookupConceptId(nf2.lhsA).equals("287402001")) {
                    System.err.println(nf2);
                    key = nf2.rhsB;
                }
                if (this.containsExistentialInNF3s(nf2.rhsR, nf2.rhsB, nf2.lhsA)) continue;
                NF3 nnf = NF3.getInstance(nf2.rhsR, nf2.rhsB, this.factory.getConcept(new Existential(nf2.rhsR, new Concept(nf2.rhsB))));
                this.addTerm(nnf);
                ++numNf3;
                if (!this.factory.lookupConceptId(nf2.lhsA).equals("287402001")) continue;
                System.err.println("Added " + nnf);
            }
        }
        System.out.println(key);
        for (NF2 nn : this.ontologyNF2.get(key)) {
            System.err.println(nn);
        }
        itr = this.ontologyNF7.keyIterator();
        while (itr.hasNext()) {
            MonotonicCollection<NF7> nf7s = this.ontologyNF7.get(itr.next());
            for (NF7 nf7 : nf7s) {
                Datatype rhs = nf7.getD();
                if (this.containsDatatypeInNF8s(rhs)) continue;
                NF8 nnf = NF8.getInstance(rhs, this.factory.getConcept(rhs));
                this.addTerm(nnf);
                ++numNf8;
            }
        }
        log.info("Added " + numNf3 + " NF3 axioms and " + numNf8 + " NF8 axioms.");
    }

    public Collection<NF1b> getNF1bs() {
        HashSet<NF1b> res = new HashSet<NF1b>();
        IntIterator it = this.ontologyNF1.keyIterator();
        while (it.hasNext()) {
            int a = it.next();
            MonotonicCollection<IConjunctionQueueEntry> mc = this.ontologyNF1.get(a);
            for (IConjunctionQueueEntry entry : mc) {
                if (!(entry instanceof NF1b)) continue;
                res.add((NF1b)entry);
            }
        }
        return res;
    }

    private boolean containsExistentialInNF3s(int r, int a, int b) {
        ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>> nf3Map = this.ontologyNF3.get(a);
        if (nf3Map == null) {
            return false;
        }
        Collection nf3s = (Collection)nf3Map.get(r);
        if (nf3s == null) {
            return false;
        }
        for (IConjunctionQueueEntry nf3 : nf3s) {
            if (b != nf3.getB()) continue;
            return true;
        }
        return false;
    }

    private boolean containsDatatypeInNF8s(Datatype d) {
        MonotonicCollection<NF8> nf8s = this.ontologyNF8.get(d.getFeature());
        Iterator<NF8> itr = nf8s.iterator();
        while (itr.hasNext()) {
            if (!itr.next().lhsD.equals(d)) continue;
            return true;
        }
        return false;
    }

    private Set<Inclusion> transformAxiom(Set<? extends Axiom> axioms) {
        HashSet<Inclusion> res = new HashSet<Inclusion>();
        for (Axiom axiom : axioms) {
            if (axiom instanceof ConceptInclusion) {
                ConceptInclusion ci = (ConceptInclusion)axiom;
                au.csiro.ontology.model.Concept lhs = ci.getLhs();
                au.csiro.ontology.model.Concept rhs = ci.getRhs();
                res.add(new GCI(this.transformConcept(lhs), this.transformConcept(rhs)));
                continue;
            }
            if (!(axiom instanceof RoleInclusion)) continue;
            RoleInclusion ri = (RoleInclusion)axiom;
            Role[] lh = ri.getLhs();
            NamedRole[] lhs = new NamedRole[lh.length];
            for (int i = 0; i < lh.length; ++i) {
                lhs[i] = (NamedRole)lh[i];
            }
            NamedRole rhs = (NamedRole)ri.getRhs();
            int[] lhsInt = new int[lhs.length];
            for (int i = 0; i < lhsInt.length; ++i) {
                lhsInt[i] = this.factory.getRole(lhs[i].getId());
            }
            res.add(new RI(lhsInt, this.factory.getRole(rhs.getId())));
        }
        return res;
    }

    private AbstractConcept transformConcept(au.csiro.ontology.model.Concept c) {
        if (c.equals((Object)NamedConcept.TOP_CONCEPT)) {
            return new Concept(0);
        }
        if (c.equals((Object)NamedConcept.BOTTOM_CONCEPT)) {
            return new Concept(1);
        }
        if (c instanceof NamedConcept) {
            return new Concept(this.factory.getConcept(((NamedConcept)c).getId()));
        }
        if (c instanceof au.csiro.ontology.model.Conjunction) {
            au.csiro.ontology.model.Concept[] modelCons = ((au.csiro.ontology.model.Conjunction)c).getConcepts();
            AbstractConcept[] cons = new AbstractConcept[modelCons.length];
            for (int i = 0; i < modelCons.length; ++i) {
                cons[i] = this.transformConcept(modelCons[i]);
            }
            return new Conjunction(cons);
        }
        if (c instanceof au.csiro.ontology.model.Datatype) {
            au.csiro.ontology.model.Datatype dt = (au.csiro.ontology.model.Datatype)c;
            return new Datatype(this.factory.getFeature(((NamedFeature)dt.getFeature()).getId()), dt.getOperator(), this.transformLiteral(dt.getLiteral()));
        }
        if (c instanceof au.csiro.ontology.model.Existential) {
            au.csiro.ontology.model.Existential e = (au.csiro.ontology.model.Existential)c;
            return new Existential(this.factory.getRole(((NamedRole)e.getRole()).getId()), this.transformConcept(e.getConcept()));
        }
        throw new RuntimeException("Unexpected AbstractConcept " + c.getClass().getName());
    }

    private AbstractLiteral transformLiteral(Literal l) {
        if (l instanceof au.csiro.ontology.model.DateLiteral) {
            return new DateLiteral(((au.csiro.ontology.model.DateLiteral)l).getValue());
        }
        if (l instanceof au.csiro.ontology.model.DecimalLiteral) {
            return new DecimalLiteral(((au.csiro.ontology.model.DecimalLiteral)l).getValue());
        }
        if (l instanceof au.csiro.ontology.model.IntegerLiteral) {
            return new IntegerLiteral(((au.csiro.ontology.model.IntegerLiteral)l).getValue());
        }
        if (l instanceof au.csiro.ontology.model.StringLiteral) {
            return new StringLiteral(((au.csiro.ontology.model.StringLiteral)l).getValue());
        }
        if (l instanceof FloatLiteral) {
            return new DecimalLiteral(new BigDecimal(((FloatLiteral)l).getValue()));
        }
        throw new RuntimeException("Unexpected AbstractLiteral " + l.getClass().getName());
    }

    public Set<Inclusion> normalise(Set<? extends Axiom> inclusions) {
        int j;
        Inclusion[] s;
        Set<Inclusion> tmp;
        Set<Inclusion> newIs = this.transformAxiom(inclusions);
        Set<Inclusion> oldIs = new HashSet<Inclusion>(newIs.size());
        HashSet<Inclusion> done = new HashSet<Inclusion>(newIs.size());
        do {
            tmp = oldIs;
            oldIs = newIs;
            newIs = tmp;
            newIs.clear();
            for (Inclusion i : oldIs) {
                s = i.normalise1(this.factory);
                if (null != s) {
                    for (j = 0; j < s.length; ++j) {
                        if (null == s[j]) continue;
                        newIs.add(s[j]);
                    }
                    continue;
                }
                done.add(i);
            }
        } while (!newIs.isEmpty());
        newIs.addAll(done);
        done.clear();
        do {
            tmp = oldIs;
            oldIs = newIs;
            newIs = tmp;
            newIs.clear();
            for (Inclusion i : oldIs) {
                s = i.normalise2(this.factory);
                if (null != s) {
                    for (j = 0; j < s.length; ++j) {
                        if (null == s[j]) continue;
                        newIs.add(s[j]);
                    }
                    continue;
                }
                done.add(i);
            }
        } while (!newIs.isEmpty());
        if (log.isTraceEnabled()) {
            log.trace("Normalised axioms:");
            for (Inclusion inc : done) {
                StringBuilder sb = new StringBuilder();
                if (inc instanceof GCI) {
                    GCI gci = (GCI)inc;
                    sb.append(this.printInternalObject(gci.lhs()));
                    sb.append(" [ ");
                    sb.append(this.printInternalObject(gci.rhs()));
                } else if (inc instanceof RI) {
                    RI ri = (RI)inc;
                    int[] lhs = ri.getLhs();
                    sb.append(this.factory.lookupRoleId(lhs[0]));
                    for (int i = 1; i < lhs.length; ++i) {
                        sb.append(" * ");
                        sb.append(this.factory.lookupRoleId(lhs[i]));
                    }
                    sb.append(" [ ");
                    sb.append(this.factory.lookupRoleId(ri.getRhs()));
                }
                log.trace(sb.toString());
            }
        }
        return done;
    }

    private String printInternalObject(Object o) {
        if (o instanceof Conjunction) {
            Conjunction con = (Conjunction)o;
            StringBuilder sb = new StringBuilder();
            AbstractConcept[] cons = con.getConcepts();
            if (cons != null && cons.length > 0) {
                sb.append(this.printInternalObject(cons[0]));
                for (int i = 1; i < cons.length; ++i) {
                    sb.append(" + ");
                    sb.append(this.printInternalObject(cons[i]));
                }
            }
            return sb.toString();
        }
        if (o instanceof Existential) {
            Existential e = (Existential)o;
            AbstractConcept c = e.getConcept();
            int role = e.getRole();
            return this.factory.lookupRoleId(role) + "." + this.printInternalObject(c);
        }
        if (o instanceof Datatype) {
            StringBuilder sb = new StringBuilder();
            Datatype d = (Datatype)o;
            String feature = this.factory.lookupFeatureId(d.getFeature());
            sb.append(feature.toString());
            sb.append(".(");
            AbstractLiteral literal = d.getLiteral();
            sb.append(literal);
            sb.append(")");
            return sb.toString();
        }
        if (o instanceof au.csiro.ontology.model.Concept) {
            Object obj = this.factory.lookupConceptId(((au.csiro.ontology.model.Concept)o).hashCode());
            if (obj == NamedConcept.TOP) {
                return "TOP";
            }
            if (obj == NamedConcept.BOTTOM) {
                return "BOTTOM";
            }
            if (obj instanceof AbstractConcept) {
                return "<" + this.printInternalObject(obj) + ">";
            }
            return obj.toString();
        }
        if (o instanceof Comparable) {
            return o.toString();
        }
        throw new RuntimeException("Unexpected object with class " + o.getClass().getName());
    }

    protected void addTerm(NormalFormGCI term) {
        if (term instanceof NF1a) {
            NF1a nf1 = (NF1a)term;
            int a = nf1.lhsA();
            this.addTerms(this.ontologyNF1, a, nf1.getQueueEntry());
        } else if (term instanceof NF1b) {
            NF1b nf1 = (NF1b)term;
            int a1 = nf1.lhsA1();
            int a2 = nf1.lhsA2();
            this.addTerms(this.ontologyNF1, a1, nf1.getQueueEntry1());
            this.addTerms(this.ontologyNF1, a2, nf1.getQueueEntry2());
        } else if (term instanceof NF2) {
            NF2 nf2 = (NF2)term;
            this.addTerms(this.ontologyNF2, nf2);
        } else if (term instanceof NF3) {
            NF3 nf3 = (NF3)term;
            this.addTerms(this.ontologyNF3, nf3);
        } else if (term instanceof NF4) {
            this.ontologyNF4.add((NF4)term);
        } else if (term instanceof NF5) {
            this.ontologyNF5.add((NF5)term);
        } else if (term instanceof NF6) {
            this.reflexiveRoles.add(((NF6)term).getR());
        } else if (term instanceof NF7) {
            NF7 nf7 = (NF7)term;
            this.addTerms(this.ontologyNF7, nf7);
        } else if (term instanceof NF8) {
            NF8 nf8 = (NF8)term;
            this.addTerms(this.ontologyNF8, nf8);
        } else {
            throw new IllegalArgumentException("Type of " + term + " must be one of NF1 through NF8");
        }
    }

    protected void addTerms(IConceptMap<MonotonicCollection<IConjunctionQueueEntry>> entries, int a, IConjunctionQueueEntry queueEntry) {
        MonotonicCollection<IConjunctionQueueEntry> queueA = entries.get(a);
        if (null == queueA) {
            queueA = new MonotonicCollection(2);
            entries.put(a, queueA);
        }
        queueA.add(queueEntry);
    }

    protected void addTerms(IConceptMap<MonotonicCollection<NF2>> entries, NF2 nf2) {
        MonotonicCollection<NF2> set = entries.get(nf2.lhsA);
        if (null == set) {
            set = new MonotonicCollection(2);
            entries.put(nf2.lhsA, set);
        }
        set.add(nf2);
    }

    protected void addTerms(IConceptMap<ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>>> queue, NF3 nf3) {
        HashSet<IConjunctionQueueEntry> entry;
        ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>> map = queue.get(nf3.lhsA);
        if (null == map) {
            map = new ConcurrentHashMap<Integer, Collection<IConjunctionQueueEntry>>(this.factory.getTotalRoles());
            queue.put(nf3.lhsA, map);
            entry = null;
        } else {
            entry = (HashSet<IConjunctionQueueEntry>)map.get(nf3.lhsR);
        }
        if (null == entry) {
            entry = new HashSet<IConjunctionQueueEntry>();
            entry.add(nf3.getQueueEntry());
            map.put(nf3.lhsR, entry);
        } else {
            entry.add(nf3.getQueueEntry());
        }
    }

    protected void addTerms(IConceptMap<MonotonicCollection<NF7>> entries, NF7 nf7) {
        MonotonicCollection<NF7> set = entries.get(nf7.lhsA);
        if (null == set) {
            set = new MonotonicCollection(2);
            entries.put(nf7.lhsA, set);
        }
        set.add(nf7);
    }

    protected void addTerms(FeatureMap<MonotonicCollection<NF8>> entries, NF8 nf8) {
        MonotonicCollection<NF8> set = entries.get(nf8.lhsD.getFeature());
        if (null == set) {
            set = new MonotonicCollection(2);
            entries.put(nf8.lhsD.getFeature(), set);
        }
        set.add(nf8);
    }

    public void loadIncremental(Set<Axiom> incAxioms) {
        Set<Inclusion> norm = this.normalise(incAxioms);
        for (Inclusion inc : norm) {
            NormalFormGCI nf = inc.getNormalForm();
            this.as.addAxiom(nf);
            this.addTerm(nf);
        }
    }

    public void classifyIncremental() {
        if (this.as.isEmpty()) {
            return;
        }
        this.newContexts.clear();
        this.affectedContexts.clear();
        int numNewConcepts = 0;
        for (NF1a nF1a : this.as.getNf1aAxioms()) {
            numNewConcepts = this.processInclusion(numNewConcepts, nF1a);
        }
        for (NF1b nF1b : this.as.getNf1bAxioms()) {
            numNewConcepts = this.processInclusion(numNewConcepts, nF1b);
        }
        for (NF2 nF2 : this.as.getNf2Axioms()) {
            numNewConcepts = this.processInclusion(numNewConcepts, nF2);
        }
        for (NF3 nF3 : this.as.getNf3Axioms()) {
            numNewConcepts = this.processInclusion(numNewConcepts, nF3);
        }
        for (NF4 nF4 : this.as.getNf4Axioms()) {
            numNewConcepts = this.processInclusion(numNewConcepts, nF4);
        }
        for (NF5 nF5 : this.as.getNf5Axioms()) {
            numNewConcepts = this.processInclusion(numNewConcepts, nF5);
        }
        for (NF6 nF6 : this.as.getNf6Axioms()) {
            numNewConcepts = this.processInclusion(numNewConcepts, nF6);
        }
        for (NF7 nF7 : this.as.getNf7Axioms()) {
            numNewConcepts = this.processInclusion(numNewConcepts, nF7);
        }
        for (NF8 nF8 : this.as.getNf8Axioms()) {
            numNewConcepts = this.processInclusion(numNewConcepts, nF8);
        }
        if (log.isInfoEnabled()) {
            log.info("Added " + numNewConcepts + " new concepts to the ontology");
        }
        IConceptMap<IConceptSet> subsumptions = this.getSubsumptions();
        this.rePrimeNF1(this.as, subsumptions);
        this.rePrimeNF2(this.as, subsumptions);
        this.rePrimeNF3(this.as, subsumptions);
        this.rePrimeNF4(this.as, subsumptions);
        this.rePrimeNF5(this.as, subsumptions);
        this.rePrimeNF6(this.as, subsumptions);
        this.rePrimeNF7(this.as, subsumptions);
        this.rePrimeNF8(this.as, subsumptions);
        if (log.isInfoEnabled()) {
            log.info("Classifying incrementally with " + this.numThreads + " threads");
        }
        if (log.isInfoEnabled()) {
            log.info("Running saturation");
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.numThreads);
        for (int j = 0; j < this.numThreads; ++j) {
            Worker worker = new Worker(this.todo);
            executorService.execute(worker);
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        assert (this.todo.isEmpty());
        for (Context ctx : this.affectedContexts) {
            ctx.endTracking();
        }
        this.affectedContexts.removeAll(this.newContexts);
        this.hasBeenIncrementallyClassified = true;
        this.as.clear();
        if (log.isTraceEnabled()) {
            log.trace("Processed " + this.contextIndex.size() + " contexts");
        }
    }

    protected int processInclusion(int numNewConcepts, NormalFormGCI nf) {
        int[] cids = nf.getConceptsInAxiom();
        for (int j = 0; j < cids.length; ++j) {
            int cid = cids[j];
            if (this.contextIndex.containsKey(cid)) continue;
            Context c = new Context(cid, this);
            this.contextIndex.put(cid, c);
            if (c.activate()) {
                this.todo.add(c);
            }
            if (log.isTraceEnabled()) {
                log.trace("Added context " + cid);
            }
            this.newContexts.add(c);
            ++numNewConcepts;
        }
        return numNewConcepts;
    }

    private void rePrimeNF1(AxiomSet as, IConceptMap<IConceptSet> subsumptions) {
        int size = as.getNf1aAxioms().size() + as.getNf1bAxioms().size();
        if (size == 0) {
            return;
        }
        SparseConceptMap<MonotonicCollection<IConjunctionQueueEntry>> deltaNF1 = new SparseConceptMap<MonotonicCollection<IConjunctionQueueEntry>>(size);
        for (NF1a nf1a : as.getNf1aAxioms()) {
            IConjunctionQueueEntry qe = nf1a.getQueueEntry();
            this.addTerms(deltaNF1, nf1a.lhsA(), qe);
        }
        for (NF1b nf1b : as.getNf1bAxioms()) {
            int a1 = nf1b.lhsA1();
            int a2 = nf1b.lhsA2();
            this.addTerms(deltaNF1, a1, nf1b.getQueueEntry1());
            this.addTerms(deltaNF1, a2, nf1b.getQueueEntry2());
        }
        IntIterator aItr = subsumptions.keyIterator();
        while (aItr.hasNext()) {
            int a = aItr.next();
            IConceptSet Sa = subsumptions.get(a);
            IntIterator xItr = Sa.iterator();
            while (xItr.hasNext()) {
                int x = xItr.next();
                if (!deltaNF1.containsKey(x)) continue;
                IMonotonicCollection set = (IMonotonicCollection)deltaNF1.get(x);
                for (IConjunctionQueueEntry entry : set) {
                    Context ctx = this.contextIndex.get(a);
                    ctx.addConceptQueueEntry(entry);
                    this.affectedContexts.add(ctx);
                    ctx.startTracking();
                    if (!ctx.activate()) continue;
                    this.todo.add(ctx);
                }
            }
        }
    }

    private void rePrimeNF2(AxiomSet as, IConceptMap<IConceptSet> subsumptions) {
        int size = as.getNf2Axioms().size();
        if (size == 0) {
            return;
        }
        SparseConceptMap<MonotonicCollection<NF2>> deltaNF2 = new SparseConceptMap<MonotonicCollection<NF2>>(size);
        for (NF2 nf2 : as.getNf2Axioms()) {
            this.addTerms(deltaNF2, nf2);
        }
        IntIterator aItr = subsumptions.keyIterator();
        while (aItr.hasNext()) {
            int a = aItr.next();
            Context ctx = this.contextIndex.get(a);
            IConceptSet Sa = subsumptions.get(a);
            IntIterator xItr = Sa.iterator();
            while (xItr.hasNext()) {
                int x = xItr.next();
                if (!deltaNF2.containsKey(x)) continue;
                IMonotonicCollection set = (IMonotonicCollection)deltaNF2.get(x);
                for (NF2 entry : set) {
                    ctx.addRoleQueueEntry(entry);
                    this.affectedContexts.add(ctx);
                    ctx.startTracking();
                    if (!ctx.activate()) continue;
                    this.todo.add(ctx);
                }
            }
        }
    }

    private void rePrimeNF3(AxiomSet as, IConceptMap<IConceptSet> subsumptions) {
        int size = as.getNf3Axioms().size();
        if (size == 0) {
            return;
        }
        SparseConceptMap<ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>>> deltaNF3 = new SparseConceptMap<ConcurrentMap<Integer, Collection<IConjunctionQueueEntry>>>(size);
        for (NF3 nf3 : as.getNf3Axioms()) {
            this.addTerms(deltaNF3, nf3);
        }
        IntIterator xItr = deltaNF3.keyIterator();
        while (xItr.hasNext()) {
            int x = xItr.next();
            ConcurrentMap entries = (ConcurrentMap)deltaNF3.get(x);
            Set keySet = entries.keySet();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                int r = (Integer)iterator.next();
                for (IConjunctionQueueEntry entry : (Collection)entries.get(r)) {
                    IntIterator aItr = subsumptions.keyIterator();
                    while (aItr.hasNext()) {
                        int a = aItr.next();
                        boolean addIt = false;
                        Context aCtx = this.contextIndex.get(a);
                        IConceptSet cs = aCtx.getSucc().lookupConcept(r);
                        IntIterator bItr = cs.iterator();
                        while (bItr.hasNext()) {
                            int b = bItr.next();
                            if (!subsumptions.get(b).contains(x)) continue;
                            addIt = true;
                            break;
                        }
                        if (!addIt) continue;
                        aCtx.addConceptQueueEntry(entry);
                        this.affectedContexts.add(aCtx);
                        aCtx.startTracking();
                        if (!aCtx.activate()) continue;
                        this.todo.add(aCtx);
                    }
                }
            }
        }
    }

    private void rePrimeNF4(AxiomSet as, IConceptMap<IConceptSet> subsumptions) {
        int size = as.getNf4Axioms().size();
        if (size == 0) {
            return;
        }
        MonotonicCollection<NF4> deltaNF4 = new MonotonicCollection<NF4>(size);
        for (final NF4 nf4 : as.getNf4Axioms()) {
            deltaNF4.add(nf4);
        }
        for (final NF4 nf4 : deltaNF4) {
            IntIterator aItr = subsumptions.keyIterator();
            while (aItr.hasNext()) {
                int a = aItr.next();
                Context aCtx = this.contextIndex.get(a);
                IConceptSet cs = aCtx.getSucc().lookupConcept(nf4.getR());
                IntIterator bItr = cs.iterator();
                while (bItr.hasNext()) {
                    final int b = bItr.next();
                    IRoleQueueEntry entry = new IRoleQueueEntry(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public int getR() {
                            return nf4.getS();
                        }

                        @Override
                        public int getB() {
                            return b;
                        }
                    };
                    aCtx.addRoleQueueEntry(entry);
                    this.affectedContexts.add(aCtx);
                    aCtx.startTracking();
                    if (!aCtx.activate()) continue;
                    this.todo.add(aCtx);
                }
            }
        }
    }

    private void rePrimeNF5(AxiomSet as, IConceptMap<IConceptSet> subsumptions) {
        int size = as.getNf5Axioms().size();
        if (size == 0) {
            return;
        }
        MonotonicCollection<NF5> deltaNF5 = new MonotonicCollection<NF5>(size);
        for (NF5 nf5 : as.getNf5Axioms()) {
            deltaNF5.add(nf5);
        }
        for (NF5 nf5 : deltaNF5) {
            final int t = nf5.getT();
            IntIterator aItr = subsumptions.keyIterator();
            while (aItr.hasNext()) {
                int a = aItr.next();
                Context aCtx = this.contextIndex.get(a);
                IntIterator bItr = aCtx.getSucc().lookupConcept(nf5.getR()).iterator();
                while (bItr.hasNext()) {
                    int b = bItr.next();
                    Context bCtx = this.contextIndex.get(b);
                    IntIterator cItr = bCtx.getSucc().lookupConcept(nf5.getS()).iterator();
                    while (cItr.hasNext()) {
                        final int c = cItr.next();
                        if (aCtx.getSucc().lookupConcept(t).contains(c)) continue;
                        IRoleQueueEntry entry = new IRoleQueueEntry(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public int getR() {
                                return t;
                            }

                            @Override
                            public int getB() {
                                return c;
                            }
                        };
                        aCtx.addRoleQueueEntry(entry);
                        this.affectedContexts.add(aCtx);
                        aCtx.startTracking();
                        if (!aCtx.activate()) continue;
                        this.todo.add(aCtx);
                    }
                }
            }
        }
    }

    private void rePrimeNF6(AxiomSet as, IConceptMap<IConceptSet> subsumptions) {
        int size = as.getNf6Axioms().size();
        if (size == 0) {
            return;
        }
        SparseConceptSet deltaNF6 = new SparseConceptSet(size);
        for (NF6 nf6 : as.getNf6Axioms()) {
            deltaNF6.add(nf6.getR());
        }
        IntIterator it = deltaNF6.iterator();
        while (it.hasNext()) {
            int role = it.next();
            IntIterator it2 = this.contextIndex.keyIterator();
            while (it2.hasNext()) {
                int concept = it2.next();
                Context ctx = this.contextIndex.get(concept);
                if (!ctx.getSucc().containsRole(role) || ctx.getSucc().lookupConcept(role).contains(concept)) continue;
                ctx.processExternalEdge(role, concept);
                this.affectedContexts.add(ctx);
                ctx.startTracking();
                if (!ctx.activate()) continue;
                this.todo.add(ctx);
            }
        }
    }

    private void rePrimeNF7(AxiomSet as, IConceptMap<IConceptSet> subsumptions) {
        int size = as.getNf7Axioms().size();
        if (size == 0) {
            return;
        }
        SparseConceptMap<MonotonicCollection<NF7>> deltaNF7 = new SparseConceptMap<MonotonicCollection<NF7>>(size);
        for (NF7 nf7 : as.getNf7Axioms()) {
            int a = nf7.lhsA;
            MonotonicCollection<NF7> list = (MonotonicCollection<NF7>)deltaNF7.get(a);
            if (list == null) {
                list = new MonotonicCollection<NF7>(2);
                deltaNF7.put(a, list);
            }
            list.add(nf7);
        }
        IntIterator aItr = subsumptions.keyIterator();
        while (aItr.hasNext()) {
            int a = aItr.next();
            IConceptSet Sa = subsumptions.get(a);
            IntIterator xItr = Sa.iterator();
            while (xItr.hasNext()) {
                int x = xItr.next();
                if (!deltaNF7.containsKey(x)) continue;
                IMonotonicCollection set = (IMonotonicCollection)deltaNF7.get(x);
                for (NF7 entry : set) {
                    Context ctx = this.contextIndex.get(a);
                    ctx.addFeatureQueueEntry(entry);
                    this.affectedContexts.add(ctx);
                    ctx.startTracking();
                    if (!ctx.activate()) continue;
                    this.todo.add(ctx);
                }
            }
        }
    }

    private void rePrimeNF8(AxiomSet as, IConceptMap<IConceptSet> subsumptions) {
        int size = as.getNf8Axioms().size();
        if (size == 0) {
            return;
        }
        FeatureMap<MonotonicCollection<NF8>> deltaNF8 = new FeatureMap<MonotonicCollection<NF8>>(size);
        for (NF8 nf8 : as.getNf8Axioms()) {
            this.addTerms(deltaNF8, nf8);
        }
        FeatureSet fs = deltaNF8.keySet();
        int fid = fs.nextSetBit(0);
        while (fid >= 0) {
            IntIterator it = this.ontologyNF7.keyIterator();
            while (it.hasNext()) {
                int a = it.next();
                Context aCtx = this.contextIndex.get(a);
                for (NF7 nf7 : this.ontologyNF7.get(a)) {
                    if (nf7.rhsD.getFeature() != fid) continue;
                    aCtx.addFeatureQueueEntry(nf7);
                    this.affectedContexts.add(aCtx);
                    aCtx.startTracking();
                    if (!aCtx.activate()) continue;
                    this.todo.add(aCtx);
                }
            }
            fid = fs.nextSetBit(fid + 1);
        }
    }

    public void classify() {
        long start = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("Classifying with " + this.numThreads + " threads");
        }
        int numConcepts = this.factory.getTotalConcepts();
        for (int i = 0; i < numConcepts; ++i) {
            Context c = new Context(i, this);
            this.contextIndex.put(i, c);
            if (c.activate()) {
                this.todo.add(c);
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("Added context " + i);
        }
        if (log.isInfoEnabled()) {
            log.info("Running saturation");
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        for (int j = 0; j < this.numThreads; ++j) {
            Worker worker = new Worker(this.todo);
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        assert (this.todo.isEmpty());
        if (log.isTraceEnabled()) {
            log.trace("Processed " + this.contextIndex.size() + " contexts");
        }
        this.hasBeenIncrementallyClassified = false;
        Statistics.INSTANCE.setTime("classification", System.currentTimeMillis() - start);
    }

    public IConceptMap<IConceptSet> getSubsumptions() {
        DenseConceptMap<IConceptSet> res = new DenseConceptMap<IConceptSet>(this.factory.getTotalConcepts());
        IntIterator it = this.contextIndex.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Context ctx = this.contextIndex.get(key);
            res.put(key, ctx.getS());
        }
        return res;
    }

    public IConceptMap<IConceptSet> getNewSubsumptions() {
        DenseConceptMap<IConceptSet> res = new DenseConceptMap<IConceptSet>(this.newContexts.size());
        for (Context ctx : this.newContexts) {
            res.put(ctx.getConcept(), ctx.getS());
        }
        return res;
    }

    public IConceptMap<IConceptSet> getAffectedSubsumptions() {
        int size = 0;
        for (Context ctx : this.affectedContexts) {
            if (!ctx.hasNewSubsumptions()) continue;
            ++size;
        }
        DenseConceptMap<IConceptSet> res = new DenseConceptMap<IConceptSet>(size);
        IntIterator it = this.contextIndex.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Context ctx = this.contextIndex.get(key);
            if (!ctx.hasNewSubsumptions()) continue;
            res.put(key, ctx.getS());
        }
        return res;
    }

    public R getRelationships() {
        R r = new R(this.factory.getTotalConcepts(), this.factory.getTotalRoles());
        IntIterator it = this.contextIndex.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Context ctx = this.contextIndex.get(key);
            int concept = ctx.getConcept();
            CR pred = ctx.getPred();
            CR succ = ctx.getSucc();
            int[] predRoles = pred.getRoles();
            for (int i = 0; i < predRoles.length; ++i) {
                IConceptSet cs = pred.lookupConcept(predRoles[i]);
                IntIterator it2 = cs.iterator();
                while (it2.hasNext()) {
                    int predC = it2.next();
                    r.store(predC, predRoles[i], concept);
                }
            }
            int[] succRoles = succ.getRoles();
            for (int i = 0; i < succRoles.length; ++i) {
                IConceptSet cs = succ.lookupConcept(succRoles[i]);
                IntIterator it2 = cs.iterator();
                while (it2.hasNext()) {
                    int succC = it2.next();
                    r.store(concept, succRoles[i], succC);
                }
            }
        }
        return r;
    }

    public void printStats() {
        System.err.println("stats");
        int count1 = this.countKeys(this.ontologyNF1);
        System.err.println("ontologyNF1QueueEntries: #keys=" + count1 + ", #Concepts=" + this.factory.getTotalConcepts() + " ratio=" + (double)count1 / (double)this.factory.getTotalConcepts());
        int count2 = this.countKeys(this.ontologyNF2);
        System.err.println("ontologyNF2: #keys=" + count2 + ", #Concepts=" + this.factory.getTotalConcepts() + " ratio=" + (double)count2 / (double)this.factory.getTotalConcepts());
        int count3 = this.countKeys(this.ontologyNF3);
        System.err.println("ontologyNF3QueueEntries: #keys=" + count3 + ", #Concepts=" + this.factory.getTotalConcepts() + " ratio=" + (double)count3 / (double)this.factory.getTotalConcepts());
    }

    private int countKeys(IConceptMap<?> map) {
        int count = 0;
        IntIterator itr = map.keyIterator();
        while (itr.hasNext()) {
            itr.next();
            ++count;
        }
        return count;
    }

    public IFactory getFactory() {
        return this.factory;
    }

    public Set<Axiom> getStatedAxioms() {
        Object nf2;
        Iterator<Serializable> it2;
        Object mc;
        int a;
        HashSet<Axiom> res = new HashSet<Axiom>();
        Object it = this.ontologyNF1.keyIterator();
        while (it.hasNext()) {
            a = it.next();
            mc = this.ontologyNF1.get(a);
            it2 = ((MonotonicCollection)mc).iterator();
            while (it2.hasNext()) {
                IConjunctionQueueEntry nf1 = it2.next();
                int bi = nf1.getBi();
                int b = nf1.getB();
                Object oa = this.factory.lookupConceptId(a);
                Object ob = this.factory.lookupConceptId(b);
                if (bi == 0) {
                    res.add((Axiom)new ConceptInclusion(this.transform(oa), this.transform(ob)));
                    continue;
                }
                Object obi = this.factory.lookupConceptId(bi);
                res.add((Axiom)new ConceptInclusion((au.csiro.ontology.model.Concept)new au.csiro.ontology.model.Conjunction(new au.csiro.ontology.model.Concept[]{this.transform(oa), this.transform(obi)}), this.transform(ob)));
            }
        }
        it = this.ontologyNF2.keyIterator();
        while (it.hasNext()) {
            a = it.next();
            mc = this.ontologyNF2.get(a);
            it2 = ((MonotonicCollection)mc).iterator();
            while (it2.hasNext()) {
                nf2 = (NF2)it2.next();
                Object oa = this.factory.lookupConceptId(((NF2)nf2).lhsA);
                String r = this.factory.lookupRoleId(((NF2)nf2).rhsR).toString();
                Object ob = this.factory.lookupConceptId(((NF2)nf2).rhsB);
                res.add((Axiom)new ConceptInclusion(this.transform(oa), (au.csiro.ontology.model.Concept)new au.csiro.ontology.model.Existential((Role)new NamedRole(r), this.transform(ob))));
            }
        }
        it = this.ontologyNF3.keyIterator();
        while (it.hasNext()) {
            a = it.next();
            mc = this.ontologyNF3.get(a);
            Set keys = mc.keySet();
            nf2 = keys.iterator();
            while (nf2.hasNext()) {
                int i = (Integer)nf2.next();
                Collection cc = (Collection)mc.get(i);
                for (IConjunctionQueueEntry nf3 : cc) {
                    Object oa = this.factory.lookupConceptId(a);
                    String r = this.factory.lookupRoleId(i).toString();
                    Object ob = this.factory.lookupConceptId(nf3.getB());
                    res.add((Axiom)new ConceptInclusion((au.csiro.ontology.model.Concept)new au.csiro.ontology.model.Existential((Role)new NamedRole(r), this.transform(ob)), this.transform(oa)));
                }
            }
        }
        for (NF4 nf4 : this.ontologyNF4) {
            int r = nf4.getR();
            int s = nf4.getS();
            res.add((Axiom)new RoleInclusion((Role)new NamedRole(this.factory.lookupRoleId(r).toString()), (Role)new NamedRole(this.factory.lookupRoleId(s).toString())));
        }
        for (NF5 nf5 : this.ontologyNF5) {
            int r = nf5.getR();
            int s = nf5.getS();
            int t = nf5.getT();
            res.add((Axiom)new RoleInclusion(new Role[]{new NamedRole(this.factory.lookupRoleId(r).toString()), new NamedRole(this.factory.lookupRoleId(s).toString())}, (Role)new NamedRole(this.factory.lookupRoleId(t).toString())));
        }
        it = this.reflexiveRoles.iterator();
        while (it.hasNext()) {
            int r = it.next();
            res.add((Axiom)new RoleInclusion(new Role[0], (Role)new NamedRole(this.factory.lookupRoleId(r).toString())));
        }
        it = this.ontologyNF7.keyIterator();
        while (it.hasNext()) {
            int a2 = it.next();
            MonotonicCollection<NF7> mc2 = this.ontologyNF7.get(a2);
            for (NF7 nf7 : mc2) {
                res.add((Axiom)new ConceptInclusion(this.transform(this.factory.lookupConceptId(a2)), this.transform(nf7.rhsD)));
            }
        }
        FeatureSet keys = this.ontologyNF8.keySet();
        int i = keys.nextSetBit(0);
        while (i >= 0) {
            MonotonicCollection<NF8> mc3 = this.ontologyNF8.get(i);
            for (NF8 nf8 : mc3) {
                res.add((Axiom)new ConceptInclusion(this.transform(nf8.lhsD), this.transform(this.factory.lookupConceptId(nf8.rhsB))));
            }
            i = keys.nextSetBit(i + 1);
        }
        return res;
    }

    public au.csiro.ontology.model.Concept transform(Object o) {
        if (o instanceof Conjunction) {
            Conjunction con = (Conjunction)o;
            ArrayList<au.csiro.ontology.model.Concept> concepts = new ArrayList<au.csiro.ontology.model.Concept>();
            for (AbstractConcept ac : con.getConcepts()) {
                concepts.add(this.transform(ac));
            }
            return new au.csiro.ontology.model.Conjunction(concepts);
        }
        if (o instanceof Existential) {
            Existential e = (Existential)o;
            AbstractConcept c = e.getConcept();
            au.csiro.ontology.model.Concept iconcept = this.transform(c);
            int role = e.getRole();
            NamedRole irole = new NamedRole(this.factory.lookupRoleId(role).toString());
            return new au.csiro.ontology.model.Existential((Role)irole, iconcept);
        }
        if (o instanceof Datatype) {
            Datatype d = (Datatype)o;
            String feature = this.factory.lookupFeatureId(d.getFeature());
            AbstractLiteral literal = d.getLiteral();
            if (literal instanceof DateLiteral) {
                return new au.csiro.ontology.model.Datatype((Feature)new NamedFeature(feature), d.getOperator(), (Literal)new au.csiro.ontology.model.DateLiteral(((DateLiteral)literal).getValue()));
            }
            if (literal instanceof DecimalLiteral) {
                return new au.csiro.ontology.model.Datatype((Feature)new NamedFeature(feature), d.getOperator(), (Literal)new au.csiro.ontology.model.DecimalLiteral(((DecimalLiteral)literal).getValue()));
            }
            if (literal instanceof IntegerLiteral) {
                return new au.csiro.ontology.model.Datatype((Feature)new NamedFeature(feature), d.getOperator(), (Literal)new au.csiro.ontology.model.IntegerLiteral(((IntegerLiteral)literal).getValue()));
            }
            if (literal instanceof StringLiteral) {
                return new au.csiro.ontology.model.Datatype((Feature)new NamedFeature(feature), d.getOperator(), (Literal)new au.csiro.ontology.model.StringLiteral(((StringLiteral)literal).getValue()));
            }
            throw new RuntimeException("Unexpected literal " + literal.getClass().getName());
        }
        if (o instanceof au.csiro.ontology.model.Concept) {
            Object obj = this.factory.lookupConceptId(((au.csiro.ontology.model.Concept)o).hashCode());
            return this.transform(obj);
        }
        if (o instanceof String) {
            return new NamedConcept((String)o);
        }
        throw new RuntimeException("Unexpected object with class " + o.getClass().getName());
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    protected void buildTaxonomyConcurrent() {
        int topConcept;
        long start = System.currentTimeMillis();
        ConcurrentLinkedQueue<Integer> todo = new ConcurrentLinkedQueue<Integer>();
        IntIterator itr = this.contextIndex.keyIterator();
        while (itr.hasNext()) {
            todo.add(itr.next());
        }
        ConcurrentHashMap<Integer, IConceptSet> equiv = new ConcurrentHashMap<Integer, IConceptSet>();
        ConcurrentHashMap<Integer, IConceptSet> direc = new ConcurrentHashMap<Integer, IConceptSet>();
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        for (int j = 0; j < this.numThreads; ++j) {
            TaxonomyWorker1 worker = new TaxonomyWorker1(this.contextIndex, equiv, direc, this.factory, todo);
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        assert (todo.isEmpty());
        int bottomConcept = 1;
        if (!equiv.containsKey(bottomConcept)) {
            TaxonomyWorker1.addToSet(equiv, bottomConcept, bottomConcept);
        }
        if (!equiv.containsKey(topConcept = 0)) {
            TaxonomyWorker1.addToSet(equiv, topConcept, topConcept);
        }
        Statistics.INSTANCE.setTime("taxonomy 1", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        this.conceptNodeIndex = new ConcurrentHashMap<String, Node>();
        Node top = null;
        Node bottom = null;
        FastConceptHashSet processed = new FastConceptHashSet();
        HashSet<Node> nodeSet = new HashSet<Node>();
        Iterator iterator = equiv.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            if (processed.contains(key)) continue;
            IConceptSet equivs = (IConceptSet)equiv.get(key);
            processed.addAll(equivs);
            Node n = new Node();
            IntIterator it = equivs.iterator();
            while (it.hasNext()) {
                int val = it.next();
                String tval = this.factory.lookupConceptId(val).toString();
                n.getEquivalentConcepts().add(tval);
                this.conceptNodeIndex.put(tval, n);
                if (val == 0) {
                    top = n;
                }
                if (val != 1) continue;
                bottom = n;
            }
            nodeSet.add(n);
        }
        if (top == null) {
            top = new Node();
            top.getEquivalentConcepts().add(NamedConcept.TOP);
        }
        if (bottom == null) {
            bottom = new Node();
            bottom.getEquivalentConcepts().add(NamedConcept.BOTTOM);
        }
        Statistics.INSTANCE.setTime("taxonomy 2", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        ConcurrentLinkedQueue<Node> todo2 = new ConcurrentLinkedQueue<Node>(nodeSet);
        executor = Executors.newFixedThreadPool(this.numThreads);
        for (int j = 0; j < this.numThreads; ++j) {
            TaxonomyWorker2 worker = new TaxonomyWorker2(this.factory, this.conceptNodeIndex, direc, todo2, nodeSet);
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        assert (todo2.isEmpty());
        Statistics.INSTANCE.setTime("taxonomy 3", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        nodeSet.remove(bottom);
        bottom.getParents().addAll(nodeSet);
        for (Node n : nodeSet) {
            n.getChildren().add(bottom);
        }
        Statistics.INSTANCE.setTime("taxonomy connect bottom", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        for (String key : this.conceptNodeIndex.keySet()) {
            Node node;
            if (key.equals(NamedConcept.TOP) || key.equals(NamedConcept.BOTTOM) || !(node = this.conceptNodeIndex.get(key)).getParents().isEmpty()) continue;
            node.getParents().add(top);
            top.getChildren().add(node);
        }
        Statistics.INSTANCE.setTime("taxonomy connect top", System.currentTimeMillis() - start);
    }

    private void addToSet(IConceptMap<IConceptSet> map, int key, int val) {
        IConceptSet set = map.get(key);
        if (set == null) {
            set = new SparseConceptHashSet();
            map.put(key, set);
        }
        set.add(val);
    }

    public void getFullTaxonomy(IConceptMap<IConceptSet> equiv, IConceptMap<IConceptSet> direc) {
        IConceptMap<IConceptSet> subsumptions = this.getSubsumptions();
        SparseConceptMap<SparseConceptHashSet> cis = new SparseConceptMap<SparseConceptHashSet>(this.factory.getTotalConcepts());
        IntIterator itr = subsumptions.keyIterator();
        while (itr.hasNext()) {
            int X = itr.next();
            SparseConceptHashSet set = new SparseConceptHashSet();
            cis.put(X, set);
            IntIterator it = subsumptions.get(X).iterator();
            while (it.hasNext()) {
                int next = it.next();
                set.add(next);
            }
        }
        itr = cis.keyIterator();
        while (itr.hasNext()) {
            int a = itr.next();
            IntIterator itr2 = ((IConceptSet)cis.get(a)).iterator();
            while (itr2.hasNext()) {
                int c = itr2.next();
                IConceptSet cs = (IConceptSet)cis.get(c);
                if (c == 1) {
                    this.addToSet(equiv, a, c);
                    continue;
                }
                if (cs != null && cs.contains(a)) {
                    this.addToSet(equiv, a, c);
                    continue;
                }
                boolean isDirect = true;
                IConceptSet d = direc.get(a);
                if (d != null) {
                    SparseConceptHashSet toRemove = new SparseConceptHashSet();
                    IntIterator itr3 = d.iterator();
                    while (itr3.hasNext()) {
                        int b = itr3.next();
                        IConceptSet bs = (IConceptSet)cis.get(b);
                        if (bs != null && bs.contains(c)) {
                            isDirect = false;
                            break;
                        }
                        if (cs == null || !cs.contains(b)) continue;
                        toRemove.add(b);
                    }
                    d.removeAll(toRemove);
                }
                if (!isDirect) continue;
                this.addToSet(direc, a, c);
            }
        }
    }

    public void buildTaxonomy() {
        if (!this.hasBeenIncrementallyClassified) {
            this.buildTaxonomyConcurrent();
        } else {
            Node cn;
            Object key;
            int next;
            IntIterator it;
            SparseConceptHashSet set;
            int x;
            IConceptMap<IConceptSet> newConceptSubs = this.getNewSubsumptions();
            IConceptMap<IConceptSet> affectedConceptSubs = this.getAffectedSubsumptions();
            SparseConceptMap<SparseConceptHashSet> allNew = new SparseConceptMap<SparseConceptHashSet>(newConceptSubs.size());
            SparseConceptMap<SparseConceptHashSet> allAffected = new SparseConceptMap<SparseConceptHashSet>(newConceptSubs.size());
            IntIterator itr = newConceptSubs.keyIterator();
            while (itr.hasNext()) {
                x = itr.next();
                if (this.factory.isVirtualConcept(x)) continue;
                set = new SparseConceptHashSet();
                allNew.put(x, set);
                it = newConceptSubs.get(x).iterator();
                while (it.hasNext()) {
                    next = it.next();
                    if (this.factory.isVirtualConcept(next)) continue;
                    set.add(next);
                }
            }
            itr = affectedConceptSubs.keyIterator();
            while (itr.hasNext()) {
                x = itr.next();
                if (this.factory.isVirtualConcept(x)) continue;
                set = new SparseConceptHashSet();
                allAffected.put(x, set);
                it = affectedConceptSubs.get(x).iterator();
                while (it.hasNext()) {
                    next = it.next();
                    if (this.factory.isVirtualConcept(next)) continue;
                    set.add(next);
                }
            }
            itr = allNew.keyIterator();
            while (itr.hasNext()) {
                String key2 = this.factory.lookupConceptId(itr.next()).toString();
                Node cn4 = new Node();
                cn4.getEquivalentConcepts().add(key2);
                this.conceptNodeIndex.put(key2, cn4);
            }
            Node bottomNode = this.conceptNodeIndex.get(NamedConcept.BOTTOM);
            IntIterator itr2 = allNew.keyIterator();
            while (itr2.hasNext()) {
                int id = itr2.next();
                String key3 = this.factory.lookupConceptId(id).toString();
                Node cn5 = this.conceptNodeIndex.get(key3);
                IConceptSet parents = (IConceptSet)allNew.get(id);
                IntIterator itr22 = parents.iterator();
                while (itr22.hasNext()) {
                    int parentId = itr22.next();
                    if (parentId == id) continue;
                    Node node = this.conceptNodeIndex.get(this.factory.lookupConceptId(parentId));
                    cn5.getParents().add(node);
                    node.getChildren().add(cn5);
                    if (!node.getChildren().contains(bottomNode)) continue;
                    node.getChildren().remove(bottomNode);
                    bottomNode.getParents().remove(node);
                }
            }
            HashSet<Integer> toRemoveFromAffected = new HashSet<Integer>();
            IntIterator itr3 = allAffected.keyIterator();
            while (itr3.hasNext()) {
                int id = itr3.next();
                String key4 = this.factory.lookupConceptId(id).toString();
                Node cn3 = this.conceptNodeIndex.get(key4);
                IConceptSet parents = (IConceptSet)allAffected.get(id);
                if (parents.contains(1)) {
                    bottomNode.getEquivalentConcepts().addAll(cn3.getEquivalentConcepts());
                    Set tempParents = cn3.getParents();
                    Set set2 = cn3.getChildren();
                    for (Node parent : tempParents) {
                        parent.getChildren().remove(cn3);
                        parent.getChildren().addAll(set2);
                    }
                    for (Node child : set2) {
                        child.getParents().remove(cn3);
                        child.getParents().addAll(tempParents);
                    }
                    for (String k : cn3.getEquivalentConcepts()) {
                        this.conceptNodeIndex.remove(k);
                        this.conceptNodeIndex.put(key4, bottomNode);
                    }
                    toRemoveFromAffected.add(id);
                    continue;
                }
                IntIterator itr23 = parents.iterator();
                while (itr23.hasNext()) {
                    int n = itr23.next();
                    if (n == id) continue;
                    Node parent = this.conceptNodeIndex.get(this.factory.lookupConceptId(n));
                    cn3.getParents().add(parent);
                    parent.getChildren().add(cn3);
                    if (!parent.getChildren().contains(bottomNode)) continue;
                    parent.getChildren().remove(bottomNode);
                    bottomNode.getParents().remove(parent);
                }
            }
            for (Integer i : toRemoveFromAffected) {
                allAffected.remove(i);
                allNew.remove(i);
            }
            Node topNode = this.conceptNodeIndex.get(NamedConcept.TOP);
            IntIterator itr4 = allNew.keyIterator();
            while (itr4.hasNext()) {
                String key5 = this.factory.lookupConceptId(itr4.next()).toString();
                Node cn2 = this.conceptNodeIndex.get(key5);
                if (!cn2.getParents().isEmpty()) continue;
                cn2.getParents().add(topNode);
                topNode.getChildren().add(cn2);
            }
            HashSet<Pair> pairsToMerge = new HashSet<Pair>();
            IntIterator itr5 = allNew.keyIterator();
            while (itr5.hasNext()) {
                key = this.factory.lookupConceptId(itr5.next()).toString();
                Node cn2 = this.conceptNodeIndex.get(key);
                for (Node node : cn2.getParents()) {
                    if (!node.getParents().contains(cn2)) continue;
                    pairsToMerge.add(new Pair(cn2, node));
                }
            }
            IntIterator itr6 = allAffected.keyIterator();
            while (itr6.hasNext()) {
                key = this.factory.lookupConceptId(itr6.next()).toString();
                Node cn3 = this.conceptNodeIndex.get(key);
                for (Node node : cn3.getParents()) {
                    if (!node.getParents().contains(cn3)) continue;
                    pairsToMerge.add(new Pair(cn3, node));
                }
            }
            HashSet affectedByMerge = new HashSet();
            for (Pair p : pairsToMerge) {
                Node cn1 = p.getA();
                Node node = p.getB();
                affectedByMerge.addAll(cn1.getChildren());
                affectedByMerge.addAll(node.getChildren());
                for (String n : node.getEquivalentConcepts()) {
                    this.conceptNodeIndex.put(n, cn1);
                }
                cn1.getEquivalentConcepts().addAll(node.getEquivalentConcepts());
                cn1.getParents().remove(node);
                node.getChildren().remove(cn1);
                node.getParents().remove(cn1);
                cn1.getChildren().remove(node);
                cn1.getParents().addAll(node.getParents());
                for (Node parent : node.getParents()) {
                    parent.getChildren().remove(node);
                    parent.getChildren().add(cn1);
                }
                cn1.getChildren().addAll(node.getChildren());
                for (Node child : node.getChildren()) {
                    child.getParents().remove(node);
                    child.getParents().add(cn1);
                }
                Object var13_36 = null;
            }
            HashSet<Object> all = new HashSet<Object>();
            IntIterator it2 = allNew.keyIterator();
            while (it2.hasNext()) {
                all.add(this.conceptNodeIndex.get(this.factory.lookupConceptId(it2.next())));
            }
            IntIterator it3 = allAffected.keyIterator();
            while (it3.hasNext()) {
                all.add(this.conceptNodeIndex.get(this.factory.lookupConceptId(it3.next())));
            }
            for (Node cn6 : affectedByMerge) {
                all.add(cn6);
            }
            HashSet<Node> childrenToAdd = new HashSet<Node>();
            for (Node node : all) {
                for (Node ccn : node.getChildren()) {
                    if (ccn.equals(bottomNode)) continue;
                    childrenToAdd.add(ccn);
                }
            }
            all.addAll(childrenToAdd);
            for (Node node : all) {
                Set ps = node.getParents();
                Object[] parents = ps.toArray(new Object[ps.size()]);
                HashSet<Node> toRemove = new HashSet<Node>();
                for (int i = 0; i < parents.length; ++i) {
                    for (int j = i + 1; j < parents.length; ++j) {
                        if (this.isChild((Node)parents[j], (Node)parents[i])) {
                            toRemove.add((Node)parents[i]);
                            continue;
                        }
                        if (!this.isChild((Node)parents[i], (Node)parents[j])) continue;
                        toRemove.add((Node)parents[j]);
                    }
                }
                for (Node tr : toRemove) {
                    node.getParents().remove(tr);
                    tr.getChildren().remove(node);
                }
            }
            IntIterator itr62 = allNew.keyIterator();
            while (itr62.hasNext()) {
                int n = itr62.next();
                cn = this.conceptNodeIndex.get(this.factory.lookupConceptId(n));
                if (!cn.getChildren().isEmpty()) continue;
                cn.getChildren().add(bottomNode);
                bottomNode.getParents().add(cn);
            }
            IntIterator itr7 = allAffected.keyIterator();
            while (itr7.hasNext()) {
                int n = itr7.next();
                cn = this.conceptNodeIndex.get(this.factory.lookupConceptId(n));
                if (!cn.getChildren().isEmpty()) continue;
                cn.getChildren().add(bottomNode);
                bottomNode.getParents().add(cn);
            }
            itr7 = allNew.keyIterator();
            while (itr7.hasNext()) {
                int n = itr7.next();
                cn = this.conceptNodeIndex.get(this.factory.lookupConceptId(n));
                if (!cn.getParents().isEmpty()) continue;
                cn.getParents().add(topNode);
                topNode.getChildren().add(cn);
            }
            itr7 = allAffected.keyIterator();
            while (itr7.hasNext()) {
                int n = itr7.next();
                cn = this.conceptNodeIndex.get(this.factory.lookupConceptId(n));
                if (!cn.getParents().isEmpty()) continue;
                cn.getParents().add(topNode);
                topNode.getChildren().add(cn);
            }
        }
    }

    public Map<String, Node> getTaxonomy() {
        return this.conceptNodeIndex;
    }

    public Set<Node> getAffectedNodes() {
        Node n;
        String key;
        HashSet<Node> res = new HashSet<Node>();
        IntIterator it = this.getNewSubsumptions().keyIterator();
        while (it.hasNext()) {
            key = this.factory.lookupConceptId(it.next()).toString();
            n = this.conceptNodeIndex.get(key);
            if (n != null) {
                res.add(n);
                continue;
            }
            log.debug("Could not find node for key " + key);
        }
        it = this.getAffectedSubsumptions().keyIterator();
        while (it.hasNext()) {
            key = this.factory.lookupConceptId(it.next()).toString();
            n = this.conceptNodeIndex.get(key);
            if (n != null) {
                res.add(n);
                continue;
            }
            log.debug("Could not find node for key " + key);
        }
        return res;
    }

    private boolean isChild(Node cn, Node cn2) {
        if (cn == cn2) {
            return false;
        }
        LinkedList toProcess = new LinkedList();
        toProcess.addAll(cn.getParents());
        while (!toProcess.isEmpty()) {
            Node tcn = (Node)toProcess.poll();
            if (tcn.equals(cn2)) {
                return true;
            }
            Set parents = tcn.getParents();
            if (parents == null || parents.isEmpty()) continue;
            toProcess.addAll(parents);
        }
        return false;
    }

    public boolean isTaxonomyComputed() {
        return this.conceptNodeIndex != null;
    }

    public Node getBottomNode() {
        return this.conceptNodeIndex.get(NamedConcept.BOTTOM);
    }

    public Node getTopNode() {
        return this.conceptNodeIndex.get(NamedConcept.TOP);
    }

    public Node getEquivalents(String cid) {
        return this.conceptNodeIndex.get(cid);
    }

    private void printNormalisedAxioms() {
        String f;
        String ss;
        String rs;
        Object r;
        String bs;
        Object b;
        String as;
        Object a;
        MonotonicCollection<NF7> entries;
        int key;
        Object it = this.ontologyNF1.keyIterator();
        while (it.hasNext()) {
            key = it.next();
            entries = this.ontologyNF1.get(key);
            for (IConjunctionQueueEntry iConjunctionQueueEntry : entries) {
                a = this.factory.lookupConceptId(key);
                as = a instanceof String ? (String)a : "[" + a.toString() + "]";
                Object bi = this.factory.lookupConceptId(iConjunctionQueueEntry.getBi());
                String bis = bi instanceof String ? (String)bi : "[" + bi.toString() + "]";
                b = this.factory.lookupConceptId(iConjunctionQueueEntry.getB());
                bs = b instanceof String ? (String)b : "[" + b.toString() + "]";
                System.out.println("NF1: " + as + " + " + bis + " [ " + bs);
            }
        }
        it = this.ontologyNF2.keyIterator();
        while (it.hasNext()) {
            key = it.next();
            entries = this.ontologyNF2.get(key);
            for (NF2 nF2 : entries) {
                a = this.factory.lookupConceptId(nF2.lhsA);
                as = a instanceof String ? (String)a : "[" + a.toString() + "]";
                Object r2 = this.factory.lookupRoleId(nF2.rhsR);
                String rs2 = r2 instanceof String ? (String)r2 : "[" + r2.toString() + "]";
                b = this.factory.lookupConceptId(nF2.rhsB);
                bs = b instanceof String ? (String)b : "[" + b.toString() + "]";
                System.out.println("NF2: " + as + " [ " + rs2 + "." + bs);
            }
        }
        it = this.ontologyNF3.keyIterator();
        while (it.hasNext()) {
            int aId = it.next();
            entries = this.ontologyNF3.get(aId);
            for (Integer n : entries.keySet()) {
                for (IConjunctionQueueEntry entry : (Collection)entries.get(n)) {
                    int bId = entry.getB();
                    Object r3 = this.factory.lookupRoleId(n);
                    String rs3 = r3 instanceof String ? (String)r3 : "[" + r3.toString() + "]";
                    Object a2 = this.factory.lookupConceptId(aId);
                    String as2 = a2 instanceof String ? (String)a2 : "[" + a2.toString() + "]";
                    Object b2 = this.factory.lookupConceptId(bId);
                    String bs2 = b2 instanceof String ? (String)b2 : "[" + b2.toString() + "]";
                    System.out.println("NF3: " + rs3 + "." + as2 + " [ " + bs2);
                }
            }
        }
        for (NF4 nf4 : this.ontologyNF4) {
            r = this.factory.lookupRoleId(nf4.getR());
            rs = r instanceof String ? (String)r : "[" + r.toString() + "]";
            Object object = this.factory.lookupRoleId(nf4.getS());
            ss = object instanceof String ? (String)object : "[" + object.toString() + "]";
            System.out.println("NF4: " + rs + " [ " + ss);
        }
        for (NF5 nf5 : this.ontologyNF5) {
            r = this.factory.lookupRoleId(nf5.getR());
            rs = r instanceof String ? (String)r : "[" + r.toString() + "]";
            Object object = this.factory.lookupRoleId(nf5.getS());
            ss = object instanceof String ? (String)object : "[" + object.toString() + "]";
            Object t = this.factory.lookupRoleId(nf5.getT());
            String ts = t instanceof String ? (String)t : "[" + t.toString() + "]";
            System.out.println("NF5: " + rs + " o " + ss + " [ " + ts);
        }
        it = this.ontologyNF7.keyIterator();
        while (it.hasNext()) {
            int key2 = it.next();
            entries = this.ontologyNF7.get(key2);
            for (NF7 nF7 : entries) {
                int aId = nF7.lhsA;
                Datatype dt = nF7.rhsD;
                int fId = dt.getFeature();
                Object a3 = this.factory.lookupConceptId(aId);
                String as3 = a3 instanceof String ? (String)a3 : "[" + a3.toString() + "]";
                f = this.factory.lookupFeatureId(fId);
                System.out.println("NF7: " + as3 + " [ " + f + ".(" + dt.getLiteral() + ")");
            }
        }
        FeatureSet keys = this.ontologyNF8.keySet();
        int i = keys.nextSetBit(0);
        while (i >= 0) {
            MonotonicCollection<NF8> mc = this.ontologyNF8.get(i);
            for (NF8 nF8 : mc) {
                Datatype dt = nF8.lhsD;
                int bId = nF8.rhsB;
                int fId = dt.getFeature();
                Object b3 = this.factory.lookupConceptId(bId);
                String bs3 = b3 instanceof String ? (String)b3 : "[" + b3.toString() + "]";
                f = this.factory.lookupFeatureId(fId);
                System.out.println("NF8: " + f + ".(" + dt.getLiteral() + ") [ " + bs3);
            }
            i = keys.nextSetBit(i + 1);
        }
    }

    public class TopBottomNodes {
        private Node top;
        private Node bottom;

        public Node getTop() {
            return this.top;
        }

        public void setTop(Node top) {
            this.top = top;
        }

        public Node getBottom() {
            return this.bottom;
        }

        public void setBottom(Node bottom) {
            this.bottom = bottom;
        }
    }

    class Pair {
        private final Node a;
        private final Node b;

        public Pair(Node a, Node b) {
            String[] aa = new String[a.getEquivalentConcepts().size()];
            String[] bb = new String[b.getEquivalentConcepts().size()];
            if (aa.length < bb.length) {
                this.a = a;
                this.b = b;
            } else if (aa.length > bb.length) {
                this.a = b;
                this.b = a;
            } else {
                int i = 0;
                for (String c : a.getEquivalentConcepts()) {
                    aa[i++] = c;
                }
                i = 0;
                for (String c : b.getEquivalentConcepts()) {
                    bb[i++] = c;
                }
                int res = 0;
                for (i = 0; i < aa.length; ++i) {
                    if (aa[i].compareTo(bb[i]) < 0) {
                        res = 1;
                        break;
                    }
                    if (aa[i].compareTo(bb[i]) <= 0) continue;
                    res = 2;
                    break;
                }
                if (res == 1) {
                    this.a = a;
                    this.b = b;
                } else if (res == 2) {
                    this.a = b;
                    this.b = a;
                } else {
                    this.a = a;
                    this.b = b;
                }
            }
        }

        public Node getA() {
            return this.a;
        }

        public Node getB() {
            return this.b;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.a == null ? other.a != null : !this.a.equals(other.a)) {
                return false;
            }
            return !(this.b == null ? other.b != null : !this.b.equals(other.b));
        }

        private NormalisedOntology getOuterType() {
            return NormalisedOntology.this;
        }
    }

    private static class ContextComparator
    implements Comparator<Context>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ContextComparator() {
        }

        @Override
        public int compare(Context o1, Context o2) {
            return Integer.valueOf(o1.getConcept()).compareTo(o2.getConcept());
        }
    }
}

