/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.ConceptSetFactory;
import au.csiro.snorocket.core.util.EmptyConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import au.csiro.snorocket.core.util.SparseConceptHashSet;
import java.io.Serializable;

public interface IConceptSet
extends Serializable {
    public static final IConceptSet EMPTY_SET = new EmptyConceptSet();
    public static final ConceptSetFactory FACTORY = new ConceptSetFactory(){

        @Override
        public IConceptSet createConceptSet() {
            return new SparseConceptHashSet();
        }

        @Override
        public IConceptSet createConceptSet(int size) {
            return new SparseConceptHashSet(size);
        }

        @Override
        public IConceptSet createConceptSet(IConceptSet initial) {
            IConceptSet result;
            if (null == initial) {
                result = this.createConceptSet();
            } else {
                result = this.createConceptSet(initial.size());
                result.addAll(initial);
            }
            return result;
        }
    };

    public void add(int var1);

    public void addAll(IConceptSet var1);

    public boolean contains(int var1);

    public boolean containsAll(IConceptSet var1);

    public void remove(int var1);

    public void removeAll(IConceptSet var1);

    public boolean isEmpty();

    public int hashCode();

    public boolean equals(Object var1);

    public String toString();

    public IntIterator iterator();

    public void clear();

    public int size();

    public void grow(int var1);

    public int[] toArray();
}

