/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.IConceptMap;
import au.csiro.snorocket.core.util.IntIterator;
import java.util.Arrays;

public final class FastConceptMap<V>
implements IConceptMap<V> {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY = -1;
    private static final Object TOMBSTOMB = null;
    private static final int REPROBE_LIMIT = 10;
    private int[] _keys;
    private Object[] _values;
    private int _size;

    public FastConceptMap(int size, String label) {
        this();
    }

    public FastConceptMap() {
        this.clear();
    }

    @Override
    public void clear() {
        this.reallocate(2);
    }

    private void reallocate(int size) {
        this._keys = new int[size];
        Arrays.fill(this._keys, -1);
        this._values = new Object[size];
        Arrays.fill(this._values, TOMBSTOMB);
        this._size = 0;
    }

    @Override
    public boolean containsKey(int key) {
        return null != this.get(key);
    }

    @Override
    public V get(int key) {
        int len = this._keys.length;
        int mask = len - 1;
        int reprobe_count = 0;
        int idx = key & mask;
        while (true) {
            int K;
            if (-1 == (K = this._keys[idx])) {
                return null;
            }
            if (key == K) {
                Object val = this._values[idx];
                return (V)(TOMBSTOMB == val ? null : val);
            }
            if (++reprobe_count > 10 + (len >> 2)) break;
            idx = idx + 1 & mask;
        }
        this.resize();
        return this.get(key);
    }

    private void resize() {
        this.grow(this._keys.length * 2);
    }

    @Override
    public IntIterator keyIterator() {
        return new IntIterator(){
            int next = 0;

            @Override
            public boolean hasNext() {
                while (this.next < FastConceptMap.this._keys.length && (-1 == FastConceptMap.this._keys[this.next] || TOMBSTOMB == FastConceptMap.this._values[this.next])) {
                    ++this.next;
                }
                return this.next < FastConceptMap.this._keys.length;
            }

            @Override
            public int next() {
                return this.hasNext() ? FastConceptMap.this._keys[this.next++] : -1;
            }
        };
    }

    @Override
    public void put(int key, V value) {
        int len = this._keys.length;
        int mask = len - 1;
        int reprobe_count = 0;
        int idx = key & mask;
        while (true) {
            int K;
            if (-1 == (K = this._keys[idx])) {
                this._keys[idx] = key;
                this._values[idx] = value;
                ++this._size;
                return;
            }
            if (key == K) {
                if (TOMBSTOMB == this._values[idx]) {
                    ++this._size;
                }
                this._values[idx] = value;
                return;
            }
            if (++reprobe_count > 10 + (len >> 2)) break;
            idx = idx + 1 & mask;
        }
        this.resize();
        this.put(key, value);
    }

    @Override
    public void remove(int key) {
        int mask = this._keys.length - 1;
        int idx = key & mask;
        int K;
        while (-1 != (K = this._keys[idx])) {
            if (key == K) {
                if (TOMBSTOMB != this._values[idx]) {
                    --this._size;
                    this._values[idx] = TOMBSTOMB;
                }
                return;
            }
            idx = idx + 1 & mask;
        }
        return;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void grow(int newSize) {
        int[] oldKeys = this._keys;
        Object[] oldValues = this._values;
        this.reallocate(newSize);
        for (int i = 0; i < oldKeys.length; ++i) {
            int key = oldKeys[i];
            Object val = oldValues[i];
            if (-1 == key || TOMBSTOMB == val) continue;
            this.put(key, val);
        }
    }
}

