/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.IMonotonicCollection;
import java.util.Iterator;

public final class DuoMonotonicCollection<T>
implements IMonotonicCollection<T> {
    private static final long serialVersionUID = 1L;
    private final IMonotonicCollection<T> base;
    private final IMonotonicCollection<T> overlay;

    public DuoMonotonicCollection(IMonotonicCollection<T> base, IMonotonicCollection<T> overlay) {
        this.base = base;
        this.overlay = overlay;
    }

    public IMonotonicCollection<T> getOverlay() {
        return this.overlay;
    }

    @Override
    public void add(T element) {
        this.overlay.add(element);
    }

    @Override
    public int size() {
        return this.base.size() + this.overlay.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<T> baseItr;
            final Iterator<T> overlayItr;
            {
                this.baseItr = DuoMonotonicCollection.this.base.iterator();
                this.overlayItr = DuoMonotonicCollection.this.overlay.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseItr.hasNext() || this.overlayItr.hasNext();
            }

            @Override
            public T next() {
                return this.baseItr.hasNext() ? this.baseItr.next() : this.overlayItr.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

