/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.model;

import au.csiro.snorocket.core.model.AbstractLiteral;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class DateLiteral
extends AbstractLiteral {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private final Calendar value;

    public DateLiteral(Calendar value) {
        this.value = value;
    }

    public Calendar getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateLiteral other = (DateLiteral)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.sdf.format(this.value.getTime());
    }

    @Override
    public int compareTo(AbstractLiteral o) {
        DateLiteral dl = (DateLiteral)o;
        Calendar otherValue = dl.value;
        return this.value.compareTo(otherValue);
    }
}

