/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.concurrent;

import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.ReadonlyConceptSet;
import au.csiro.snorocket.core.util.SparseConceptSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public final class CR
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IConceptSet[] data;

    public CR(int roles) {
        this.data = new IConceptSet[roles];
    }

    public boolean containsRole(int role) {
        return this.data[role] != null;
    }

    protected IConceptSet getConcept(int r) {
        if (r >= this.data.length) {
            this.resizeRoles(r + 1);
        }
        if (null == this.data[r]) {
            this.data[r] = new SparseConceptSet();
        }
        return this.data[r];
    }

    public IConceptSet lookupConcept(int r) {
        if (r >= this.data.length) {
            return IConceptSet.EMPTY_SET;
        }
        if (null == this.data[r]) {
            return IConceptSet.EMPTY_SET;
        }
        return new ReadonlyConceptSet(this.data[r]);
    }

    public void clear() {
        Arrays.fill(this.data, null);
    }

    private void resizeRoles(int maxRole) {
        IConceptSet[] oldData = this.data;
        this.data = new IConceptSet[maxRole];
        System.arraycopy(oldData, 0, this.data, 0, oldData.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < this.data.length; ++index) {
            IConceptSet cs = this.data[index];
            if (null == cs) continue;
            sb.append(index + "." + cs.toString());
        }
        return sb.toString();
    }

    synchronized void store(int r, int B) {
        this.getConcept(r).add(B);
    }

    public int[] getRoles() {
        ArrayList<Integer> roles = new ArrayList<Integer>();
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            roles.add(i);
        }
        int[] res = new int[roles.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Integer)roles.get(i);
        }
        return res;
    }
}

