/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core;

import au.csiro.ontology.model.NamedConcept;
import au.csiro.snorocket.core.IFactory;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.RoleSet;
import au.csiro.snorocket.core.util.SparseConceptSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class CoreFactory
implements IFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CoreFactory.class);
    private static final int SIZE_ESTIMATE = 3000;
    private final int conceptBase;
    private final int roleBase;
    private final int featureBase;
    private Object[] concepts = new Object[3000];
    private final Map<Object, Integer> conceptMap = new HashMap<Object, Integer>();
    private final IConceptSet virtualConcepts = new SparseConceptSet(3000);
    private Object[] roles = new Object[128];
    private final Map<Object, Integer> roleMap = new HashMap<Object, Integer>();
    private final RoleSet virtualRoles = new RoleSet();
    private String[] features = new String[128];
    private final Map<String, Integer> featureNameMap = new HashMap<String, Integer>();
    private int conceptIdCounter = 0;
    private int roleIdCounter = 0;
    private int featureIdCounter = 0;

    public CoreFactory() {
        this(0, 0, 0);
        int topId = this.getConcept(NamedConcept.TOP);
        int bottomId = this.getConcept(NamedConcept.BOTTOM);
        assert (0 == topId);
        assert (1 == bottomId);
    }

    CoreFactory(int conceptBase, int roleBase, int featureBase) {
        this.conceptBase = conceptBase;
        this.roleBase = roleBase;
        this.featureBase = featureBase;
    }

    @Override
    public int getTotalConcepts() {
        return this.conceptIdCounter;
    }

    @Override
    public int getTotalRoles() {
        return this.roleIdCounter;
    }

    @Override
    public int getTotalFeatures() {
        return this.featureIdCounter;
    }

    @Override
    public String lookupFeatureId(int id) {
        assert (id >= this.featureBase && id <= this.featureIdCounter + this.featureBase);
        return this.features[id - this.featureBase];
    }

    @Override
    public Object lookupConceptId(int id) {
        assert (id >= this.conceptBase && id <= this.conceptIdCounter + this.conceptBase);
        return this.concepts[id - this.conceptBase];
    }

    @Override
    public Object lookupRoleId(int id) {
        assert (id >= this.roleBase && id <= this.roleIdCounter + this.roleBase);
        return this.roles[id - this.roleBase];
    }

    @Override
    public boolean isVirtualConcept(int id) {
        return this.virtualConcepts.contains(id - this.conceptBase);
    }

    @Override
    public boolean isVirtualRole(int id) {
        return this.virtualRoles.contains(id - this.roleBase);
    }

    @Override
    public boolean conceptExists(Object key) {
        return this.conceptMap.containsKey(key);
    }

    @Override
    public boolean roleExists(Object key) {
        return this.roleMap.containsKey(key);
    }

    @Override
    public boolean featureExists(String key) {
        return this.featureNameMap.containsKey(key);
    }

    @Override
    public int getConcept(Object key) {
        if (null == key) {
            throw new IllegalArgumentException("Concept key must not be null");
        }
        Integer result = this.conceptMap.get(key);
        if (null == result) {
            if (this.conceptIdCounter == this.concepts.length) {
                Object[] newConcepts = new Object[this.conceptIdCounter * 2];
                System.arraycopy(this.concepts, 0, newConcepts, 0, this.conceptIdCounter);
                this.concepts = newConcepts;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Resizing concepts array to: " + this.concepts.length));
                }
            }
            this.concepts[this.conceptIdCounter] = key;
            result = this.conceptIdCounter++;
            this.conceptMap.put(key, result);
        }
        return result + this.conceptBase;
    }

    @Override
    public int getRole(Object key) {
        Integer result = this.roleMap.get(key);
        if (null == result) {
            if (this.roleIdCounter == this.roles.length) {
                Object[] newRoles = new Object[this.roleIdCounter * 2];
                System.arraycopy(this.roles, 0, newRoles, 0, this.roleIdCounter);
                this.roles = newRoles;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("role resize to: " + this.roles.length));
                }
            }
            this.roles[this.roleIdCounter] = key;
            result = this.roleIdCounter++;
            this.roleMap.put(key, result);
        }
        return result + this.roleBase;
    }

    @Override
    public int getFeature(String key) {
        Integer result = this.featureNameMap.get(key);
        if (null == result) {
            if (this.featureIdCounter == this.features.length) {
                String[] newFeatures = new String[this.featureIdCounter * 2];
                System.arraycopy(this.features, 0, newFeatures, 0, this.featureIdCounter);
                this.features = newFeatures;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("feature resize to: " + this.features.length));
                }
            }
            this.features[this.featureIdCounter] = key;
            result = this.featureIdCounter++;
            this.featureNameMap.put(key, result);
        }
        return result + this.featureBase;
    }

    @Override
    public void setVirtualConcept(int id, boolean isVirtual) {
        if (isVirtual) {
            this.virtualConcepts.add(id - this.conceptBase);
        } else {
            this.virtualConcepts.remove(id - this.conceptBase);
        }
    }
}

