/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.FeatureSet;
import java.io.Serializable;
import java.util.Arrays;

public class FeatureMap<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FeatureSet keySet = new FeatureSet();
    private V[] members;

    public FeatureMap(int size) {
        this.members = new Object[size];
    }

    public boolean containsKey(int key) {
        return this.keySet.contains(key);
    }

    public V get(int key) {
        if (key >= this.members.length) {
            return null;
        }
        return this.members[key];
    }

    public FeatureSet keySet() {
        return this.keySet;
    }

    public void put(int key, V value) {
        this.keySet.add(key);
        int len = this.members.length;
        if (key >= len) {
            Object[] newMembers = new Object[key + 1];
            System.arraycopy(this.members, 0, newMembers, 0, len);
            this.members = newMembers;
        }
        this.members[key] = value;
    }

    public void clear() {
        this.keySet.clear();
        Arrays.fill(this.members, null);
    }
}

