/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import java.util.Arrays;

public final class FastConceptHashSet
implements IConceptSet {
    private static final long serialVersionUID = 1L;
    private static final int TOMBSTOMB = -2;
    private static final int EMPTY = -1;
    private static final int REPROBE_LIMIT = 10;
    private int[] _keys;
    private int _size;

    public FastConceptHashSet() {
        this.clear();
    }

    private void reallocate(int size) {
        this._keys = new int[size];
        Arrays.fill(this._keys, -1);
        this._size = 0;
    }

    @Override
    public void add(int concept) {
        int len = this._keys.length;
        int mask = len - 1;
        int reprobe_count = 0;
        int idx = concept & mask;
        while (true) {
            int K;
            if ((K = this._keys[idx]) < 0) {
                this._keys[idx] = concept;
                ++this._size;
                return;
            }
            if (concept == K) {
                return;
            }
            if (++reprobe_count > this.reprobeLimit(len)) break;
            idx = idx + 1 & mask;
        }
        this.resize();
        this.add(concept);
    }

    private void resize() {
        this.grow(this._keys.length * 2);
    }

    @Override
    public void addAll(IConceptSet set) {
        IntIterator itr = set.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    @Override
    public void clear() {
        this.reallocate(1);
    }

    @Override
    public boolean contains(int concept) {
        int len = this._keys.length;
        int mask = len - 1;
        int reprobe_count = 0;
        int idx = concept & mask;
        while (true) {
            int K;
            if ((K = this._keys[idx]) == -1) {
                return false;
            }
            if (concept == K) {
                return true;
            }
            if (++reprobe_count > this.reprobeLimit(len)) break;
            idx = idx + 1 & mask;
        }
        return false;
    }

    private int reprobeLimit(int len) {
        return 10 + (len >> 2);
    }

    @Override
    public boolean containsAll(IConceptSet concepts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public IntIterator iterator() {
        if (this._size < this._keys.length >> 1) {
            int[] oldItems = this._keys;
            this.reallocate(this._keys.length >> 1);
            for (int i = 0; i < oldItems.length; ++i) {
                int concept = oldItems[i];
                if (concept < 0) continue;
                this.add(concept);
            }
        }
        return new IntIterator(){
            int next = 0;

            @Override
            public boolean hasNext() {
                while (this.next < FastConceptHashSet.this._keys.length && FastConceptHashSet.this._keys[this.next] < 0) {
                    ++this.next;
                }
                return this.next < FastConceptHashSet.this._keys.length;
            }

            @Override
            public int next() {
                return this.hasNext() ? FastConceptHashSet.this._keys[this.next++] : -1;
            }
        };
    }

    @Override
    public void remove(int concept) {
        int len = this._keys.length;
        int mask = this._keys.length - 1;
        int reprobe_count = 0;
        int idx = concept & mask;
        while (true) {
            int K;
            if (-1 == (K = this._keys[idx])) {
                return;
            }
            if (concept == K) {
                --this._size;
                this._keys[idx] = -2;
            }
            if (++reprobe_count > this.reprobeLimit(len)) break;
            idx = idx + 1 & mask;
        }
    }

    @Override
    public void removeAll(IConceptSet set) {
        if (this.size() < set.size()) {
            for (int i = 0; i < this._keys.length; ++i) {
                int concept = this._keys[i];
                if (concept < 0 || !set.contains(concept)) continue;
                this._keys[i] = -2;
                --this._size;
            }
        } else {
            IntIterator itr = set.iterator();
            while (itr.hasNext()) {
                int concept = itr.next();
                this.remove(concept);
            }
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            int c = itr.next();
            sb.append(c);
            if (!itr.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void grow(int newSize) {
        int[] oldItems = this._keys;
        this.reallocate(newSize);
        for (int i = 0; i < oldItems.length; ++i) {
            int concept = oldItems[i];
            if (concept < 0) continue;
            this.add(concept);
        }
    }

    @Override
    public int[] toArray() {
        throw new UnsupportedOperationException();
    }
}

