/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.util;

import au.csiro.snorocket.core.util.AbstractConceptMap;
import au.csiro.snorocket.core.util.IntIterator;
import java.util.Arrays;

public final class DenseConceptMap<V>
extends AbstractConceptMap<V> {
    private static final long serialVersionUID = 1L;
    private V[] members;

    public DenseConceptMap(int capacity) {
        this.members = new Object[capacity];
    }

    @Override
    public boolean containsKey(int key) {
        return key < this.members.length && null != this.members[key];
    }

    @Override
    public V get(int key) {
        return key < this.members.length ? (V)this.members[key] : null;
    }

    @Override
    public void put(int key, V value) {
        int len = this.members.length;
        if (key >= len) {
            Object[] newMembers = new Object[key + 1];
            System.arraycopy(this.members, 0, newMembers, 0, len);
            this.members = newMembers;
        }
        this.members[key] = value;
    }

    @Override
    public void remove(int key) {
        if (key < this.members.length) {
            this.members[key] = null;
        }
    }

    @Override
    public IntIterator keyIterator() {
        return new IntIterator(){
            int next = 0;

            @Override
            public boolean hasNext() {
                while (this.next < DenseConceptMap.this.members.length && null == DenseConceptMap.this.members[this.next]) {
                    ++this.next;
                }
                return this.next < DenseConceptMap.this.members.length;
            }

            @Override
            public int next() {
                int n;
                if (this.hasNext()) {
                    int n2 = this.next;
                    n = n2;
                    this.next = n2 + 1;
                } else {
                    n = -1;
                }
                return n;
            }
        };
    }

    @Override
    public void clear() {
        Arrays.fill(this.members, null);
    }

    @Override
    public int size() {
        return this.members.length;
    }

    @Override
    public void grow(int newSize) {
        Object[] newMembers = new Object[newSize];
        System.arraycopy(this.members, 0, newMembers, 0, this.members.length);
        this.members = newMembers;
    }

    public String toString() {
        boolean separator = false;
        StringBuilder sb = new StringBuilder();
        IntIterator itr = this.keyIterator();
        while (itr.hasNext()) {
            if (separator) {
                sb.append(", ");
            }
            int key = itr.next();
            sb.append(key);
            sb.append(" [ ");
            sb.append(this.get(key));
            separator = true;
        }
        return sb.toString();
    }
}

