/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.model;

import au.csiro.snorocket.core.model.AbstractLiteral;

public class FloatLiteral
extends AbstractLiteral {
    private final float value;

    public FloatLiteral(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatLiteral other = (FloatLiteral)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(AbstractLiteral o) {
        return Float.compare(this.value, ((FloatLiteral)o).value);
    }
}

