/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.model;

import au.csiro.ontology.model.Operator;
import au.csiro.snorocket.core.model.AbstractConcept;
import au.csiro.snorocket.core.model.AbstractLiteral;

public class Datatype
extends AbstractConcept {
    private static final long serialVersionUID = 1L;
    private int feature;
    private Operator operator;
    private AbstractLiteral literal;

    public Datatype(int feature, Operator operator, AbstractLiteral literal) {
        this.feature = feature;
        this.operator = operator;
        this.literal = literal;
    }

    public int getFeature() {
        return this.feature;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public AbstractLiteral getLiteral() {
        return this.literal;
    }

    @Override
    public String toString() {
        return this.feature + ".(" + this.operator + "," + this.literal + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.feature;
        result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Datatype other = (Datatype)obj;
        if (this.feature != other.feature) {
            return false;
        }
        if (this.literal == null ? other.literal != null : !this.literal.equals(other.literal)) {
            return false;
        }
        return this.operator == other.operator;
    }

    @Override
    int compareToWhenHashCodesEqual(AbstractConcept other) {
        assert (this.hashCode() == other.hashCode());
        assert (other instanceof Datatype);
        Datatype otherDatatype = (Datatype)other;
        int featureCompare = this.feature - otherDatatype.feature;
        if (featureCompare == 0) {
            int operatorCompare = this.operator.compareTo((Enum)otherDatatype.operator);
            if (operatorCompare == 0) {
                return this.literal.toString().compareTo(otherDatatype.literal.toString());
            }
            return operatorCompare;
        }
        return featureCompare;
    }
}

