/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.concurrent;

import au.csiro.snorocket.core.IFactory;
import au.csiro.snorocket.core.concurrent.Context;
import au.csiro.snorocket.core.util.FastConceptHashSet;
import au.csiro.snorocket.core.util.IConceptMap;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;

public class TaxonomyWorker1
implements Runnable {
    private final IConceptMap<Context> contextIndex;
    private final ConcurrentMap<Integer, IConceptSet> equiv;
    private final ConcurrentMap<Integer, IConceptSet> direc;
    private final IFactory factory;
    private final Queue<Integer> todo;

    public TaxonomyWorker1(IConceptMap<Context> contextIndex, ConcurrentMap<Integer, IConceptSet> equiv, ConcurrentMap<Integer, IConceptSet> direc, IFactory factory, Queue<Integer> todo) {
        this.contextIndex = contextIndex;
        this.equiv = equiv;
        this.direc = direc;
        this.factory = factory;
        this.todo = todo;
    }

    @Override
    public void run() {
        Integer aInt;
        while ((aInt = this.todo.poll()) != null) {
            int a = aInt;
            Context ctx = this.contextIndex.get(a);
            if (this.factory.isVirtualConcept(a)) continue;
            IntIterator it = ctx.getS().iterator();
            while (it.hasNext()) {
                int c = it.next();
                if (this.factory.isVirtualConcept(c)) continue;
                if (c == 1) {
                    TaxonomyWorker1.addToSet(this.equiv, a, c);
                    TaxonomyWorker1.addToSet(this.equiv, c, a);
                    continue;
                }
                if (a == 1 && c == 0) continue;
                IConceptSet cs = this.contextIndex.get(c).getS();
                if (cs != null && cs.contains(a)) {
                    TaxonomyWorker1.addToSet(this.equiv, a, c);
                    continue;
                }
                boolean isDirect = true;
                IConceptSet d = (IConceptSet)this.direc.get(a);
                if (d != null) {
                    IConceptSet toRemove = IConceptSet.FACTORY.createConceptSet();
                    IntIterator it2 = d.iterator();
                    while (it2.hasNext()) {
                        int b = it2.next();
                        IConceptSet bs = this.contextIndex.get(b).getS();
                        if (bs != null && bs.contains(c)) {
                            isDirect = false;
                            break;
                        }
                        if (cs == null || !cs.contains(b)) continue;
                        toRemove.add(b);
                    }
                    d.removeAll(toRemove);
                }
                if (!isDirect) continue;
                TaxonomyWorker1.addToSet(this.direc, a, c);
            }
        }
    }

    public static void addToSet(ConcurrentMap<Integer, IConceptSet> set, int key, int val) {
        IConceptSet valSet = (IConceptSet)set.get(key);
        if (valSet == null) {
            FastConceptHashSet temp = new FastConceptHashSet();
            valSet = set.putIfAbsent(key, temp);
            if (valSet == null) {
                temp.add(val);
            } else {
                valSet.add(val);
            }
        } else {
            valSet.add(val);
        }
    }
}

