/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core;

import au.csiro.ontology.Node;
import au.csiro.ontology.Ontology;
import au.csiro.ontology.classification.IReasoner;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.ConceptInclusion;
import au.csiro.ontology.model.Feature;
import au.csiro.ontology.model.Literal;
import au.csiro.ontology.model.NamedConcept;
import au.csiro.ontology.model.NamedFeature;
import au.csiro.ontology.model.NamedRole;
import au.csiro.ontology.model.Operator;
import au.csiro.ontology.model.Role;
import au.csiro.snorocket.core.CoreFactory;
import au.csiro.snorocket.core.IFactory;
import au.csiro.snorocket.core.NormalisedOntology;
import au.csiro.snorocket.core.concurrent.CR;
import au.csiro.snorocket.core.concurrent.Context;
import au.csiro.snorocket.core.model.AbstractConcept;
import au.csiro.snorocket.core.model.AbstractLiteral;
import au.csiro.snorocket.core.model.BigIntegerLiteral;
import au.csiro.snorocket.core.model.Concept;
import au.csiro.snorocket.core.model.Conjunction;
import au.csiro.snorocket.core.model.Datatype;
import au.csiro.snorocket.core.model.DateLiteral;
import au.csiro.snorocket.core.model.DecimalLiteral;
import au.csiro.snorocket.core.model.Existential;
import au.csiro.snorocket.core.model.FloatLiteral;
import au.csiro.snorocket.core.model.IntegerLiteral;
import au.csiro.snorocket.core.model.StringLiteral;
import au.csiro.snorocket.core.util.IConceptMap;
import au.csiro.snorocket.core.util.IConceptSet;
import au.csiro.snorocket.core.util.IntIterator;
import au.csiro.snorocket.core.util.RoleSet;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class SnorocketReasoner
implements IReasoner,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(SnorocketReasoner.class);
    public static final int BUFFER_SIZE = 10;
    private NormalisedOntology no = null;
    private IFactory factory = new CoreFactory();
    private boolean isClassified = false;

    public static SnorocketReasoner load(InputStream in) {
        SnorocketReasoner res;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(in);
            res = (SnorocketReasoner)ois.readObject();
        }
        catch (Exception e) {
            log.error((Object)("Problem loading reasoner." + e));
            throw new RuntimeException(e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {}
            }
        }
        res.no.buildTaxonomy();
        return res;
    }

    public SnorocketReasoner() {
        this.no = new NormalisedOntology(this.factory);
    }

    public void prune() {
        throw new UnsupportedOperationException();
    }

    public Ontology getClassifiedOntology() {
        if (!this.isClassified) {
            this.classify();
        }
        log.info((Object)"Building taxonomy");
        this.no.buildTaxonomy();
        Map<String, Node> taxonomy = this.no.getTaxonomy();
        Set<Node> affectedNodes = this.no.getAffectedNodes();
        return new Ontology(null, null, null, taxonomy, affectedNodes);
    }

    public Ontology getClassifiedOntology(Ontology ont) {
        if (!this.isClassified) {
            this.classify();
        }
        log.info((Object)"Building taxonomy");
        this.no.buildTaxonomy();
        Map<String, Node> nodeMap = this.no.getTaxonomy();
        Set<Node> affectedNodes = this.no.getAffectedNodes();
        ont.setNodeMap(nodeMap);
        ont.setAffectedNodes(affectedNodes);
        return ont;
    }

    protected au.csiro.ontology.model.Concept transformToModel(Object obj) {
        if (obj instanceof NamedConcept) {
            return (NamedConcept)obj;
        }
        if (obj instanceof String) {
            return new NamedConcept((String)obj);
        }
        if (obj instanceof Conjunction) {
            Conjunction conj = (Conjunction)obj;
            ArrayList<au.csiro.ontology.model.Concept> conjs = new ArrayList<au.csiro.ontology.model.Concept>();
            for (AbstractConcept ac : conj.getConcepts()) {
                conjs.add(this.transformToModel(ac));
            }
            return new au.csiro.ontology.model.Conjunction(conjs.toArray(new au.csiro.ontology.model.Concept[conjs.size()]));
        }
        if (obj instanceof Existential) {
            Existential ex = (Existential)obj;
            String roleId = (String)this.factory.lookupRoleId(ex.getRole());
            au.csiro.ontology.model.Concept con = this.transformToModel(ex.getConcept());
            return new au.csiro.ontology.model.Existential((Role)new NamedRole(roleId), con);
        }
        if (obj instanceof Datatype) {
            Datatype dt = (Datatype)obj;
            String featureId = this.factory.lookupFeatureId(dt.getFeature());
            Literal l = this.transformLiteralToModel(dt.getLiteral());
            return new au.csiro.ontology.model.Datatype((Feature)new NamedFeature(featureId), dt.getOperator(), l);
        }
        if (obj instanceof Concept) {
            Concept c = (Concept)obj;
            Object id = this.factory.lookupConceptId(c.hashCode());
            if (id instanceof String) {
                return new NamedConcept((String)id);
            }
            if (id instanceof NamedConcept) {
                return (NamedConcept)id;
            }
            return this.transformToModel(id);
        }
        throw new RuntimeException("Unexpected abstract concept " + obj.getClass());
    }

    protected Literal transformLiteralToModel(AbstractLiteral al) {
        if (al instanceof BigIntegerLiteral) {
            return new au.csiro.ontology.model.BigIntegerLiteral(((BigIntegerLiteral)al).getValue());
        }
        if (al instanceof DateLiteral) {
            return new au.csiro.ontology.model.DateLiteral(((DateLiteral)al).getValue());
        }
        if (al instanceof DecimalLiteral) {
            return new au.csiro.ontology.model.DecimalLiteral(((DecimalLiteral)al).getValue());
        }
        if (al instanceof FloatLiteral) {
            return new au.csiro.ontology.model.FloatLiteral(((FloatLiteral)al).getValue());
        }
        if (al instanceof IntegerLiteral) {
            return new au.csiro.ontology.model.IntegerLiteral(((IntegerLiteral)al).getValue());
        }
        if (al instanceof StringLiteral) {
            return new au.csiro.ontology.model.StringLiteral(((StringLiteral)al).getValue());
        }
        throw new RuntimeException("Unexpected abstract literal " + al);
    }

    public Collection<Axiom> getInferredAxioms() {
        HashSet<Axiom> inferred = new HashSet<Axiom>();
        if (!this.isClassified) {
            this.classify();
        }
        if (!this.no.isTaxonomyComputed()) {
            log.info((Object)"Building taxonomy");
            this.no.buildTaxonomy();
        }
        Map<String, Node> taxonomy = this.no.getTaxonomy();
        IConceptMap<Context> contextIndex = this.no.getContextIndex();
        IntIterator itr = contextIndex.keyIterator();
        while (itr.hasNext()) {
            au.csiro.ontology.model.Concept rhs;
            NamedConcept lhs;
            int key = itr.next();
            String id = this.factory.lookupConceptId(key).toString();
            if (this.factory.isVirtualConcept(key) || NamedConcept.BOTTOM == id || (lhs = new NamedConcept(id)).equals((Object)(rhs = this.getNecessary(contextIndex, taxonomy, key))) || rhs.equals((Object)NamedConcept.TOP_CONCEPT)) continue;
            inferred.add((Axiom)new ConceptInclusion((au.csiro.ontology.model.Concept)lhs, rhs));
        }
        return inferred;
    }

    protected au.csiro.ontology.model.Concept getNecessary(IConceptMap<Context> contextIndex, Map<String, Node> taxonomy, int key) {
        Object id = this.factory.lookupConceptId(key);
        ArrayList<au.csiro.ontology.model.Concept> result = new ArrayList<au.csiro.ontology.model.Concept>();
        Node node = taxonomy.get(id);
        if (node != null) {
            for (Node parent : node.getParents()) {
                String parentId = (String)parent.getEquivalentConcepts().iterator().next();
                if (NamedConcept.TOP.equals(parentId)) continue;
                result.add((au.csiro.ontology.model.Concept)new NamedConcept(parentId));
            }
            IntIterator ancestorItr = contextIndex.get(key).getS().iterator();
            while (ancestorItr.hasNext()) {
                Object c;
                int anc = ancestorItr.next();
                if (!this.factory.isVirtualConcept(anc) || !((c = this.factory.lookupConceptId(anc)) instanceof Datatype)) continue;
                this.addDatatype(result, (Datatype)c);
            }
        } else if (id instanceof Conjunction) {
            for (AbstractConcept conjunct : ((Conjunction)id).getConcepts()) {
                if (conjunct instanceof Concept) {
                    int conjunctInt = ((Concept)conjunct).hashCode();
                    String conjunctId = this.factory.lookupConceptId(conjunctInt).toString();
                    result.add((au.csiro.ontology.model.Concept)new NamedConcept(conjunctId));
                    continue;
                }
                if (!(conjunct instanceof Datatype)) continue;
                this.addDatatype(result, (Datatype)conjunct);
            }
        }
        Context ctx = contextIndex.get(key);
        CR succ = ctx.getSucc();
        for (int roleId : succ.getRoles()) {
            NamedRole role = new NamedRole(this.factory.lookupRoleId(roleId).toString());
            IConceptSet values = this.getLeaves(succ.lookupConcept(roleId));
            IntIterator itr2 = values.iterator();
            while (itr2.hasNext()) {
                int valueInt = itr2.next();
                if (!this.factory.isVirtualConcept(valueInt)) {
                    String valueId = this.factory.lookupConceptId(valueInt).toString();
                    result.add((au.csiro.ontology.model.Concept)new au.csiro.ontology.model.Existential((Role)role, (au.csiro.ontology.model.Concept)new NamedConcept(valueId)));
                    continue;
                }
                au.csiro.ontology.model.Concept valueConcept = this.getNecessary(contextIndex, taxonomy, valueInt);
                au.csiro.ontology.model.Existential x = new au.csiro.ontology.model.Existential((Role)role, Builder.build(this.no, valueConcept));
                result.add((au.csiro.ontology.model.Concept)x);
            }
        }
        if (result.size() == 0) {
            return NamedConcept.TOP_CONCEPT;
        }
        if (result.size() == 1) {
            return (au.csiro.ontology.model.Concept)result.get(0);
        }
        return new au.csiro.ontology.model.Conjunction(result);
    }

    protected void addDatatype(List<au.csiro.ontology.model.Concept> result, Datatype datatype) {
        au.csiro.ontology.model.DecimalLiteral literal;
        NamedFeature feature = new NamedFeature(this.factory.lookupFeatureId(datatype.getFeature()));
        Operator operator = Operator.EQUALS;
        if (datatype.getLiteral() instanceof DecimalLiteral) {
            literal = new au.csiro.ontology.model.DecimalLiteral(((DecimalLiteral)datatype.getLiteral()).getValue());
        } else if (datatype.getLiteral() instanceof IntegerLiteral) {
            literal = new au.csiro.ontology.model.IntegerLiteral(((IntegerLiteral)datatype.getLiteral()).getValue());
        } else if (datatype.getLiteral() instanceof StringLiteral) {
            literal = new au.csiro.ontology.model.StringLiteral(((StringLiteral)datatype.getLiteral()).getValue());
        } else {
            throw new UnsupportedOperationException("Literals of type " + datatype.getLiteral().getClass().getName() + " not yet supported");
        }
        result.add((au.csiro.ontology.model.Concept)new au.csiro.ontology.model.Datatype((Feature)feature, operator, (Literal)literal));
    }

    private IConceptSet getLeaves(IConceptSet concepts) {
        IConceptSet leafBs = IConceptSet.FACTORY.createConceptSet(concepts);
        IConceptSet set = IConceptSet.FACTORY.createConceptSet(leafBs);
        IntIterator bItr = set.iterator();
        while (bItr.hasNext()) {
            int b = bItr.next();
            IConceptSet ancestors = IConceptSet.FACTORY.createConceptSet(SnorocketReasoner.getAncestors(this.no, b));
            ancestors.remove(b);
            leafBs.removeAll(ancestors);
        }
        return leafBs;
    }

    protected String printConcept(int id) {
        Object oid = this.factory.lookupConceptId(id);
        if (this.factory.isVirtualConcept(id)) {
            if (oid instanceof AbstractConcept) {
                return this.printAbstractConcept((AbstractConcept)oid);
            }
            return oid.toString();
        }
        return (String)oid;
    }

    private String printAbstractConcept(AbstractConcept ac) {
        if (ac instanceof Concept) {
            Concept c = (Concept)ac;
            Object o = this.factory.lookupConceptId(c.hashCode());
            if (o instanceof String) {
                return (String)o;
            }
            return this.printAbstractConcept((AbstractConcept)o);
        }
        if (ac instanceof Conjunction) {
            Conjunction c = (Conjunction)ac;
            AbstractConcept[] acs = c.getConcepts();
            StringBuilder sb = new StringBuilder();
            sb.append(this.printAbstractConcept(acs[0]));
            for (int i = 1; i < acs.length; ++i) {
                sb.append(" + ");
                sb.append(this.printAbstractConcept(acs[i]));
            }
            return sb.toString();
        }
        if (ac instanceof Existential) {
            Existential e = (Existential)ac;
            return "E" + this.factory.lookupRoleId(e.getRole()).toString() + "." + this.printAbstractConcept(e.getConcept());
        }
        if (ac instanceof Datatype) {
            Datatype d = (Datatype)ac;
            return "F" + this.factory.lookupFeatureId(d.getFeature()) + ".(" + d.getOperator() + ", " + d.getLiteral() + ")";
        }
        throw new RuntimeException("Unexpected concept: " + ac);
    }

    private static IConceptSet getAncestors(NormalisedOntology no, int conceptInt) {
        return no.getContextIndex().get(conceptInt).getS();
    }

    public void save(OutputStream out) {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(out);
            oos.writeObject(this);
            oos.flush();
        }
        catch (Exception e) {
            log.error((Object)"Problem saving reasoner.", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean isClassified() {
        return this.isClassified;
    }

    public void loadAxioms(Set<Axiom> axioms) {
        if (!this.isClassified) {
            this.no.loadAxioms(axioms);
        } else {
            this.no.loadIncremental(axioms);
        }
    }

    public void loadAxioms(Iterator<Axiom> axioms) {
        HashSet<Axiom> axiomSet = new HashSet<Axiom>();
        while (axioms.hasNext()) {
            Axiom axiom = axioms.next();
            if (axiom == null) continue;
            axiomSet.add(axiom);
            if (axiomSet.size() != 10) continue;
            this.loadAxioms(axiomSet);
            axiomSet.clear();
        }
        if (!axiomSet.isEmpty()) {
            this.loadAxioms(axiomSet);
        }
    }

    public void loadAxioms(Ontology ont) {
        this.loadAxioms(new HashSet<Axiom>(ont.getStatedAxioms()));
    }

    public IReasoner classify() {
        if (!this.isClassified) {
            this.no.classify();
            this.isClassified = true;
        } else {
            this.no.classifyIncremental();
        }
        return this;
    }

    static final class Builder {
        private final NormalisedOntology no;
        private final IFactory factory;
        private final Map<Integer, RoleSet> rc;
        private final Set<au.csiro.ontology.model.Existential> items = new HashSet<au.csiro.ontology.model.Existential>();

        private Builder(NormalisedOntology no) {
            this.no = no;
            this.factory = no.factory;
            this.rc = no.getRoleClosureCache();
        }

        static au.csiro.ontology.model.Concept build(NormalisedOntology no, au.csiro.ontology.model.Concept ... concepts) {
            ArrayList<Object> list = new ArrayList<Object>();
            Builder b = new Builder(no);
            for (au.csiro.ontology.model.Concept member : concepts) {
                if (member instanceof au.csiro.ontology.model.Existential) {
                    au.csiro.ontology.model.Existential existential = (au.csiro.ontology.model.Existential)member;
                    b.build((NamedRole)existential.getRole(), Builder.build(no, existential.getConcept()));
                    continue;
                }
                list.add(Builder.buildOne(no, member));
            }
            list.addAll(b.get());
            if (list.size() == 1) {
                return (au.csiro.ontology.model.Concept)list.get(0);
            }
            return new au.csiro.ontology.model.Conjunction(list);
        }

        private static au.csiro.ontology.model.Concept buildOne(NormalisedOntology no, au.csiro.ontology.model.Concept concept) {
            if (concept instanceof au.csiro.ontology.model.Existential) {
                au.csiro.ontology.model.Existential existential = (au.csiro.ontology.model.Existential)concept;
                return new au.csiro.ontology.model.Existential(existential.getRole(), Builder.buildOne(no, existential.getConcept()));
            }
            if (concept instanceof au.csiro.ontology.model.Conjunction) {
                return Builder.build(no, ((au.csiro.ontology.model.Conjunction)concept).getConcepts());
            }
            if (concept instanceof NamedConcept) {
                return concept;
            }
            if (concept instanceof au.csiro.ontology.model.Datatype) {
                return concept;
            }
            throw new RuntimeException("Unexpected type: " + concept);
        }

        private void build(NamedRole role, au.csiro.ontology.model.Concept concept) {
            if (!(concept instanceof NamedConcept)) {
                log.debug((Object)("WARNING: pass through of complex value: " + concept));
                this.doAdd(role, concept);
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("check for subsumption: " + role + "." + concept));
            }
            int cInt = this.factory.getConcept(((NamedConcept)concept).getId());
            IConceptSet cAncestorSet = SnorocketReasoner.getAncestors(this.no, cInt);
            int rInt = this.factory.getRole(role.getId());
            RoleSet rSet = this.rc.get(rInt);
            ArrayList<au.csiro.ontology.model.Existential> remove = new ArrayList<au.csiro.ontology.model.Existential>();
            boolean subsumed = false;
            for (au.csiro.ontology.model.Existential candidate : this.items) {
                au.csiro.ontology.model.Concept value = candidate.getConcept();
                if (!(value instanceof NamedConcept)) {
                    log.debug((Object)("WARNING: pass through of nested complex value: " + value));
                    continue;
                }
                int dInt = this.factory.getConcept(((NamedConcept)value).getId());
                IConceptSet dAncestorSet = SnorocketReasoner.getAncestors(this.no, dInt);
                int sInt = this.factory.getRole(((NamedRole)candidate.getRole()).getId());
                RoleSet sSet = this.rc.get(sInt);
                if (rInt == sInt && cInt == dInt) {
                    subsumed = true;
                    continue;
                }
                if (rSet.contains(sInt) && cAncestorSet.contains(dInt)) {
                    remove.add(candidate);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("\tremove " + candidate));
                    }
                }
                if (!sSet.contains(rInt) || !dAncestorSet.contains(cInt)) continue;
                subsumed = true;
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)"\tsubsumed");
            }
            if (subsumed && !remove.isEmpty()) {
                throw new AssertionError((Object)"Should not have items to remove if item to be added is already subsumed.");
            }
            this.items.removeAll(remove);
            if (!subsumed) {
                this.doAdd(role, concept);
            }
        }

        private Collection<au.csiro.ontology.model.Existential> get() {
            return this.items;
        }

        private void doAdd(NamedRole role, au.csiro.ontology.model.Concept concept) {
            this.items.add(new au.csiro.ontology.model.Existential((Role)role, concept));
        }
    }
}

