/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.util;

import au.csiro.ontology.Node;
import au.csiro.ontology.Ontology;
import au.csiro.ontology.util.AbstractTraversal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public interface Traversal {
    public static final Traversal BFS_MIN = new AbstractTraversal(){

        @Override
        public void accept(Node start, Visitor ... visitors) {
            HashSet<Node> done = new HashSet<Node>();
            LinkedList<Node> queue = new LinkedList<Node>();
            queue.add(start);
            while (!queue.isEmpty()) {
                Node node = (Node)queue.poll();
                if (done.contains(node)) continue;
                for (Visitor v : visitors) {
                    v.visit(node);
                }
                done.add(node);
                queue.addAll(node.getChildren());
            }
        }
    };
    public static final Traversal BFS_MAX = new AbstractTraversal(){

        @Override
        public void accept(Node start, Visitor ... visitors) {
            HashSet<Node> done = new HashSet<Node>();
            LinkedList<Node> queue = new LinkedList<Node>();
            queue.add(start);
            while (!queue.isEmpty()) {
                Node node = (Node)queue.poll();
                if (done.contains(node)) continue;
                for (Visitor v : visitors) {
                    v.visit(node);
                }
                done.add(node);
                for (Node child : node.getChildren()) {
                    if (!done.containsAll(child.getParents())) continue;
                    queue.add(child);
                }
            }
        }
    };

    public void accept(Ontology var1, Visitor ... var2);

    public void accept(Node var1, Visitor ... var2);

    public static class Stats {
        public static Map<Node, Object> computeStats(final Ontology ont) {
            final HashMap<Node, Object> result = new HashMap<Node, Object>();
            final HashMap minLevel = new HashMap();
            final HashMap maxLevel = new HashMap();
            Visitor v = new Visitor(){

                @Override
                public void visit(Node node) {
                    int min;
                    int max;
                    if (ont.getTopNode().equals(node)) {
                        max = 0;
                        min = 0;
                    } else {
                        min = Integer.MAX_VALUE;
                        max = Integer.MIN_VALUE;
                        for (Node parent : node.getParents()) {
                            min = Math.min(min, (Integer)minLevel.get(parent) + 1);
                            max = Math.max(max, (Integer)maxLevel.get(parent) + 1);
                        }
                    }
                    minLevel.put(node, min);
                    maxLevel.put(node, max);
                    result.put(node, new int[]{min, max});
                }
            };
            BFS_MAX.accept(ont, v);
            return result;
        }
    }

    public static interface Visitor {
        public void visit(Node var1);
    }
}

